/*
 * Decompiled with CFR 0.152.
 */
package nc.worldgen;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import nc.NuclearCraft;
import nc.block.NCBlocks;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;

public class OreGen
implements IWorldGenerator {
    WorldGenMinable copper = new WorldGenMinable(NCBlocks.blockOre, 0, NuclearCraft.oreSizeCopper, Blocks.field_150348_b);
    WorldGenMinable tin = new WorldGenMinable(NCBlocks.blockOre, 1, NuclearCraft.oreSizeTin, Blocks.field_150348_b);
    WorldGenMinable lead = new WorldGenMinable(NCBlocks.blockOre, 2, NuclearCraft.oreSizeLead, Blocks.field_150348_b);
    WorldGenMinable silver = new WorldGenMinable(NCBlocks.blockOre, 3, NuclearCraft.oreSizeSilver, Blocks.field_150348_b);
    WorldGenMinable uranium = new WorldGenMinable(NCBlocks.blockOre, 4, NuclearCraft.oreSizeUranium, Blocks.field_150348_b);
    WorldGenMinable thorium = new WorldGenMinable(NCBlocks.blockOre, 5, NuclearCraft.oreSizeThorium, Blocks.field_150348_b);
    WorldGenMinable lithium = new WorldGenMinable(NCBlocks.blockOre, 7, NuclearCraft.oreSizeLithium, Blocks.field_150348_b);
    WorldGenMinable boron = new WorldGenMinable(NCBlocks.blockOre, 8, NuclearCraft.oreSizeBoron, Blocks.field_150348_b);
    WorldGenMinable magnesium = new WorldGenMinable(NCBlocks.blockOre, 9, NuclearCraft.oreSizeMagnesium, Blocks.field_150348_b);
    WorldGenMinable plutonium = new WorldGenMinable(NCBlocks.blockOre, 6, NuclearCraft.oreSizePlutonium, Blocks.field_150424_aL);
    WorldGenMinable liquidHelium = new WorldGenMinable(NCBlocks.blockHelium, 0, 8, Blocks.field_150377_bs);

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.field_76575_d) {
            this.generateNether(random, chunkX * 16, chunkZ * 16, world);
        } else if (world.field_73011_w.field_76574_g == 1) {
            this.generateEnd(random, chunkX * 16, chunkZ * 16, world);
        } else if (world.field_73011_w.field_76577_b != WorldType.field_77138_c) {
            this.generateSurface(random, chunkX * 16, chunkZ * 16, world);
        }
    }

    void generateSurface(Random random, int xChunk, int zChunk, World world) {
        int zPos;
        int yPos;
        int xPos;
        int i;
        if (NuclearCraft.oreGenCopper) {
            for (i = 0; i < NuclearCraft.oreRarityCopper; ++i) {
                xPos = xChunk + random.nextInt(16);
                yPos = random.nextInt(NuclearCraft.oreMaxHeightCopper);
                zPos = zChunk + random.nextInt(16);
                this.copper.func_76484_a(world, random, xPos, yPos, zPos);
            }
        }
        if (NuclearCraft.oreGenTin) {
            for (i = 0; i < NuclearCraft.oreRarityTin; ++i) {
                xPos = xChunk + random.nextInt(16);
                yPos = random.nextInt(NuclearCraft.oreMaxHeightTin);
                zPos = zChunk + random.nextInt(16);
                this.tin.func_76484_a(world, random, xPos, yPos, zPos);
            }
        }
        if (NuclearCraft.oreGenLead) {
            for (i = 0; i < NuclearCraft.oreRarityLead; ++i) {
                xPos = xChunk + random.nextInt(16);
                yPos = random.nextInt(NuclearCraft.oreMaxHeightLead);
                zPos = zChunk + random.nextInt(16);
                this.lead.func_76484_a(world, random, xPos, yPos, zPos);
            }
        }
        if (NuclearCraft.oreGenSilver) {
            for (i = 0; i < NuclearCraft.oreRaritySilver; ++i) {
                xPos = xChunk + random.nextInt(16);
                yPos = random.nextInt(NuclearCraft.oreMaxHeightSilver);
                zPos = zChunk + random.nextInt(16);
                this.silver.func_76484_a(world, random, xPos, yPos, zPos);
            }
        }
        if (NuclearCraft.oreGenUranium) {
            for (i = 0; i < NuclearCraft.oreRarityUranium; ++i) {
                xPos = xChunk + random.nextInt(16);
                yPos = random.nextInt(NuclearCraft.oreMaxHeightUranium);
                zPos = zChunk + random.nextInt(16);
                this.uranium.func_76484_a(world, random, xPos, yPos, zPos);
            }
        }
        if (NuclearCraft.oreGenThorium) {
            for (i = 0; i < NuclearCraft.oreRarityThorium; ++i) {
                xPos = xChunk + random.nextInt(16);
                yPos = random.nextInt(NuclearCraft.oreMaxHeightThorium);
                zPos = zChunk + random.nextInt(16);
                this.thorium.func_76484_a(world, random, xPos, yPos, zPos);
            }
        }
        if (NuclearCraft.oreGenLithium) {
            for (i = 0; i < NuclearCraft.oreRarityLithium; ++i) {
                xPos = xChunk + random.nextInt(16);
                yPos = random.nextInt(NuclearCraft.oreMaxHeightLithium);
                zPos = zChunk + random.nextInt(16);
                this.lithium.func_76484_a(world, random, xPos, yPos, zPos);
            }
        }
        if (NuclearCraft.oreGenBoron) {
            for (i = 0; i < NuclearCraft.oreRarityBoron; ++i) {
                xPos = xChunk + random.nextInt(16);
                yPos = random.nextInt(NuclearCraft.oreMaxHeightBoron);
                zPos = zChunk + random.nextInt(16);
                this.boron.func_76484_a(world, random, xPos, yPos, zPos);
            }
        }
        if (NuclearCraft.oreGenMagnesium) {
            for (i = 0; i < NuclearCraft.oreRarityMagnesium; ++i) {
                xPos = xChunk + random.nextInt(16);
                yPos = random.nextInt(NuclearCraft.oreMaxHeightMagnesium);
                zPos = zChunk + random.nextInt(16);
                this.magnesium.func_76484_a(world, random, xPos, yPos, zPos);
            }
        }
    }

    void generateNether(Random random, int xChunk, int zChunk, World world) {
        if (NuclearCraft.oreGenPlutonium) {
            for (int i = 0; i < NuclearCraft.oreRarityPlutonium; ++i) {
                int xPos = xChunk + random.nextInt(16);
                int yPos = random.nextInt(NuclearCraft.oreMaxHeightPlutonium);
                int zPos = zChunk + random.nextInt(16);
                this.plutonium.func_76484_a(world, random, xPos, yPos, zPos);
            }
        }
    }

    void generateEnd(Random random, int xChunk, int zChunk, World world) {
        if (NuclearCraft.liquidHeliumLakeGen > 0) {
            for (int i = 0; i < NuclearCraft.liquidHeliumLakeGen; ++i) {
                int xPos = xChunk + random.nextInt(16);
                int yPos = random.nextInt(128);
                int zPos = zChunk + random.nextInt(16);
                this.liquidHelium.func_76484_a(world, random, xPos, yPos, zPos);
            }
        }
    }

    public void addOreSpawn(Block block, World world, Random random, int blockXPos, int blockZPos, int maxX, int maxZ, int maxVeinSize, int chancesToSpawn, int minY, int maxY) {
        assert (maxY > minY) : "The maximum Y must be greater than the Minimum Y";
        assert (maxX > 0 && maxX <= 16) : "addOreSpawn: The Maximum X must be greater than 0 and less than 16";
        assert (minY > 0) : "addOreSpawn: The Minimum Y must be greater than 0";
        assert (maxY < 256 && maxY > 0) : "addOreSpawn: The Maximum Y must be less than 256 but greater than 0";
        assert (maxZ > 0 && maxZ <= 16) : "addOreSpawn: The Maximum Z must be greater than 0 and less than 16";
        int diffBtwnMinMaxY = maxY - minY;
        for (int x = 0; x < chancesToSpawn; ++x) {
            int posX = blockXPos + random.nextInt(maxX);
            int posY = minY + random.nextInt(diffBtwnMinMaxY);
            int posZ = blockZPos + random.nextInt(maxZ);
            new WorldGenMinable(block, maxVeinSize).func_76484_a(world, random, posX, posY, posZ);
        }
    }
}

