/*
 * Decompiled with CFR 0.152.
 */
package nc.util;

import nc.util.Complex;

public class Matrix {
    public static int delta(int a, int b) {
        return a == b ? 1 : 0;
    }

    public static Complex[][] I(int n) {
        Complex[][] c = new Complex[n][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                c[j][i] = new Complex(Matrix.delta(j, i), 0.0);
            }
        }
        return c;
    }

    public static Complex[][] zero(int n) {
        Complex[][] c = new Complex[n][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                c[j][i] = new Complex(0.0, 0.0);
            }
        }
        return c;
    }

    public static Complex[][] add(Complex[][] a, Complex[][] b) {
        Complex[][] c = new Complex[a[0].length][a[0].length];
        for (int i = 0; i < a[0].length; ++i) {
            for (int j = 0; j < a[0].length; ++j) {
                c[j][i] = Complex.add(a[j][i], b[j][i]);
            }
        }
        return c;
    }

    public static Complex[][] subtract(Complex[][] a, Complex[][] b) {
        Complex[][] c = new Complex[a[0].length][a[0].length];
        for (int i = 0; i < a[0].length; ++i) {
            for (int j = 0; j < a[0].length; ++j) {
                c[j][i] = Complex.subtract(a[j][i], b[j][i]);
            }
        }
        return c;
    }

    public static Complex[][] hadamard(Complex[][] a, Complex[][] b) {
        Complex[][] c = new Complex[a[0].length][a[0].length];
        for (int i = 0; i < a[0].length; ++i) {
            for (int j = 0; j < a[0].length; ++j) {
                c[j][i] = Complex.multiply(a[j][i], b[j][i]);
            }
        }
        return c;
    }

    public static Complex[][] multiply(Complex a, Complex[][] b) {
        Complex[][] c = new Complex[b[0].length][b[0].length];
        for (int i = 0; i < b[0].length; ++i) {
            for (int j = 0; j < b[0].length; ++j) {
                c[j][i] = Complex.multiply(a, b[j][i]);
            }
        }
        return c;
    }

    public static Complex[][] multiply(double a, Complex[][] b) {
        return Matrix.multiply(new Complex(a, 0.0), b);
    }

    public static Complex[][] multiply(Complex[][] a, Complex[][] b) {
        Complex[][] c = new Complex[a[0].length][a[0].length];
        for (int i = 0; i < a[0].length; ++i) {
            for (int j = 0; j < a[0].length; ++j) {
                c[j][i] = new Complex(0.0, 0.0);
                for (int k = 0; k < a[0].length; ++k) {
                    c[j][i].add(Complex.multiply(a[k][i], b[j][k]));
                }
            }
        }
        return c;
    }

    public static Complex[] transform(Complex[] a, Complex[][] b) {
        Complex[] c = new Complex[a.length];
        for (int i = 0; i < a.length; ++i) {
            c[i] = new Complex(0.0, 0.0);
            for (int j = 0; j < a.length; ++j) {
                c[i].add(Complex.multiply(b[i][j], a[j]));
            }
        }
        return c;
    }

    public static Complex[] normalise(Complex[] a) {
        int i;
        Complex[] b = new Complex[a.length];
        double n = 0.0;
        for (i = 0; i < a.length; ++i) {
            n += Complex.absSq(a[i]);
        }
        for (i = 0; i < a.length; ++i) {
            b[i] = Complex.divide(a[i], Math.sqrt(n));
        }
        return b;
    }

    public static Complex dot(Complex[] a, Complex[] b) {
        Complex c = new Complex(0.0, 0.0);
        for (int i = 0; i < a.length; ++i) {
            c.add(Complex.multiply(a[i].conjugate(), b[i]));
        }
        return c;
    }

    public static Complex expectation(Complex[] a, Complex[][] b) {
        return Matrix.dot(a, Matrix.transform(a, b));
    }

    public static Complex trace(Complex[][] a) {
        Complex b = new Complex(0.0, 0.0);
        for (int i = 0; i < a.length; ++i) {
            b.add(a[i][i]);
        }
        return b;
    }

    public static Complex[][] transpose(Complex[][] a) {
        Complex[][] b = new Complex[a[0].length][a[0].length];
        for (int i = 0; i < a[0].length; ++i) {
            for (int j = 0; j < a[0].length; ++j) {
                b[j][i] = a[i][j];
            }
        }
        return b;
    }

    public static Complex[][] dyad(Complex[] a, Complex[] b) {
        Complex[][] c = new Complex[a.length][a.length];
        for (int i = 0; i < a.length; ++i) {
            for (int j = 0; j < a.length; ++j) {
                c[j][i] = Complex.multiply(a[j], b[i].conjugate());
            }
        }
        return c;
    }

    public static Complex[][] tensorProduct(Complex[][] a, Complex[][] b) {
        Complex[][] c = new Complex[a[0].length * b[0].length][a[0].length * b[0].length];
        for (int m = 0; m < a[0].length; ++m) {
            for (int n = 0; n < a[0].length; ++n) {
                for (int i = 0; i < b[0].length; ++i) {
                    for (int j = 0; j < b[0].length; ++j) {
                        c[j + b[0].length * n][i + b[0].length * m] = Complex.multiply(a[n][m], b[j][i]);
                    }
                }
            }
        }
        return c;
    }

    public static Complex[][] commutator(Complex[][] a, Complex[][] b) {
        return Matrix.subtract(Matrix.multiply(a, b), Matrix.multiply(b, a));
    }

    public static Complex[][] square(Complex[][] a) {
        return Matrix.multiply(a, a);
    }

    public static Complex[][] conjugate(Complex[][] a) {
        Complex[][] b = new Complex[a[0].length][a[0].length];
        for (int i = 0; i < a[0].length; ++i) {
            for (int j = 0; j < a[0].length; ++j) {
                b[j][i] = a[j][i].conjugate();
            }
        }
        return b;
    }

    public static Complex[][] hermitian(Complex[][] a) {
        return Matrix.conjugate(Matrix.transpose(a));
    }

    public static int dim(double s) {
        return (int)(2.0 * s + 1.0);
    }

    public static double rPlus(double s, double m) {
        return Math.sqrt(s * (s + 1.0) - m * (m + 1.0));
    }

    public static double rMinus(double s, double m) {
        return Math.sqrt(s * (s + 1.0) - m * (m - 1.0));
    }

    public static Complex[][] spinSquared(double s) {
        Complex[][] c = Matrix.I(Matrix.dim(s));
        return Matrix.multiply(s * (s + 1.0), c);
    }

    public static Complex[][] spinZ(double s) {
        Complex[][] c = new Complex[Matrix.dim(s)][Matrix.dim(s)];
        for (int i = 0; i < Matrix.dim(s); ++i) {
            for (int j = 0; j < Matrix.dim(s); ++j) {
                c[j][i] = new Complex((double)Matrix.delta(j, i) * (s - (double)i), 0.0);
            }
        }
        return c;
    }

    public static Complex[][] spinPlus(double s) {
        Complex[][] c = new Complex[Matrix.dim(s)][Matrix.dim(s)];
        for (int i = 0; i < Matrix.dim(s); ++i) {
            for (int j = 0; j < Matrix.dim(s); ++j) {
                if (i < 0 || j < 0) continue;
                c[j][i] = new Complex((double)Matrix.delta(j, i - 1) * Matrix.rPlus(s, s - (double)j - 1.0), 0.0);
            }
        }
        return c;
    }

    public static Complex[][] spinMinus(double s) {
        Complex[][] c = new Complex[Matrix.dim(s)][Matrix.dim(s)];
        for (int i = 0; i < Matrix.dim(s); ++i) {
            for (int j = 0; j < Matrix.dim(s); ++j) {
                if (i < 0 || j < 0) continue;
                c[j][i] = new Complex((double)Matrix.delta(j - 1, i) * Matrix.rMinus(s, s - (double)i), 0.0);
            }
        }
        return c;
    }

    public static Complex[][] spinX(double s) {
        return Matrix.multiply(0.5, Matrix.add(Matrix.spinPlus(s), Matrix.spinMinus(s)));
    }

    public static Complex[][] spinY(double s) {
        return Matrix.multiply(new Complex(0.0, 0.5), Matrix.subtract(Matrix.spinMinus(s), Matrix.spinPlus(s)));
    }

    public static Complex[][] spinW(double s, double t, double p) {
        return Matrix.add(Matrix.multiply(Math.cos(t * Math.PI / 180.0), Matrix.spinZ(s)), Matrix.add(Matrix.multiply(Math.sin(t * Math.PI / 180.0) * Math.cos(p * Math.PI / 180.0), Matrix.spinX(s)), Matrix.multiply(Math.sin(t * Math.PI / 180.0) * Math.sin(p * Math.PI / 180.0), Matrix.spinY(s))));
    }

    public static Complex[][] projection(Complex[] a) {
        Complex[] b = Matrix.normalise(a);
        return Matrix.dyad(b, b);
    }

    public static Complex[][] spinZ(int a, double ... spin) {
        int i;
        double[] s = new double[spin.length];
        for (int i2 = 0; i2 < spin.length; ++i2) {
            s[i2] = spin[i2];
        }
        int x = 1;
        int y = 1;
        for (i = 1; i <= a - 1; ++i) {
            x *= Matrix.dim(s[i - 1]);
        }
        for (i = a + 1; i <= spin.length; ++i) {
            y *= Matrix.dim(s[i - 1]);
        }
        return Matrix.tensorProduct(Matrix.I(x), Matrix.tensorProduct(Matrix.spinZ(s[a - 1]), Matrix.I(y)));
    }

    public static Complex[][] spinX(int a, double ... spin) {
        int i;
        double[] s = new double[spin.length];
        for (int i2 = 0; i2 < spin.length; ++i2) {
            s[i2] = spin[i2];
        }
        int x = 1;
        int y = 1;
        for (i = 1; i <= a - 1; ++i) {
            x *= Matrix.dim(s[i - 1]);
        }
        for (i = a + 1; i <= spin.length; ++i) {
            y *= Matrix.dim(s[i - 1]);
        }
        return Matrix.tensorProduct(Matrix.I(x), Matrix.tensorProduct(Matrix.spinX(s[a - 1]), Matrix.I(y)));
    }

    public static Complex[][] spinY(int a, double ... spin) {
        int i;
        double[] s = new double[spin.length];
        for (int i2 = 0; i2 < spin.length; ++i2) {
            s[i2] = spin[i2];
        }
        int x = 1;
        int y = 1;
        for (i = 1; i <= a - 1; ++i) {
            x *= Matrix.dim(s[i - 1]);
        }
        for (i = a + 1; i <= spin.length; ++i) {
            y *= Matrix.dim(s[i - 1]);
        }
        return Matrix.tensorProduct(Matrix.I(x), Matrix.tensorProduct(Matrix.spinY(s[a - 1]), Matrix.I(y)));
    }

    public static Complex[][] spinW(int a, double t, double p, double ... spin) {
        int i;
        double[] s = new double[spin.length];
        for (int i2 = 0; i2 < spin.length; ++i2) {
            s[i2] = spin[i2];
        }
        int x = 1;
        int y = 1;
        for (i = 1; i <= a - 1; ++i) {
            x *= Matrix.dim(s[i - 1]);
        }
        for (i = a + 1; i <= spin.length; ++i) {
            y *= Matrix.dim(s[i - 1]);
        }
        return Matrix.tensorProduct(Matrix.I(x), Matrix.tensorProduct(Matrix.spinW(s[a - 1], t, p), Matrix.I(y)));
    }

    public static int dim(double ... spin) {
        double[] s = new double[spin.length];
        for (int i = 0; i < spin.length; ++i) {
            s[i] = spin[i];
        }
        int x = 1;
        for (int i = 1; i <= spin.length; ++i) {
            x *= Matrix.dim(s[i - 1]);
        }
        return x;
    }

    public static Complex[][] twoSpinInteraction(int a, int b, double ... spin) {
        return Matrix.add(Matrix.multiply(Matrix.spinZ(a, spin), Matrix.spinZ(b, spin)), Matrix.add(Matrix.multiply(Matrix.spinX(a, spin), Matrix.spinX(b, spin)), Matrix.multiply(Matrix.spinY(a, spin), Matrix.spinY(b, spin))));
    }

    public static Complex[][] totalSpinSquared(double ... spin) {
        double[] s = new double[spin.length];
        for (int i = 0; i < spin.length; ++i) {
            s[i] = spin[i];
        }
        Complex[][] c = Matrix.zero(Matrix.dim(s));
        for (int i = 1; i <= s.length; ++i) {
            for (int j = 1; j <= s.length; ++j) {
                c = Matrix.add(c, Matrix.twoSpinInteraction(i, j, spin));
            }
        }
        return c;
    }

    public static Complex[][] totalSpinHamiltonian(double ... spin) {
        double[] s = new double[spin.length];
        for (int i = 0; i < spin.length; ++i) {
            s[i] = spin[i];
        }
        Complex[][] c = Matrix.zero(Matrix.dim(s));
        for (int i = 1; i <= s.length; ++i) {
            for (int j = 1; j <= s.length; ++j) {
                if (i == j) continue;
                c = Matrix.add(c, Matrix.twoSpinInteraction(i, j, spin));
            }
        }
        return Matrix.multiply(new Complex(0.5, 0.0), c);
    }

    public static Complex[][] projection(Complex[][] p, int a, double ... spin) {
        int i;
        double[] s = new double[spin.length];
        for (int i2 = 0; i2 < spin.length; ++i2) {
            s[i2] = spin[i2];
        }
        if (spin.length == 1) {
            return p;
        }
        int x = 1;
        int y = 1;
        for (i = 1; i <= a - 1; ++i) {
            x *= Matrix.dim(s[i - 1]);
        }
        for (i = a + 1; i <= spin.length; ++i) {
            y *= Matrix.dim(s[i - 1]);
        }
        return Matrix.tensorProduct(Matrix.I(x), Matrix.tensorProduct(p, Matrix.I(y)));
    }

    public static Complex[][] projection(Complex[] v, int a, double ... spin) {
        return Matrix.projection(Matrix.projection(v), a, spin);
    }
}

