/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.machine;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyReceiver;
import nc.crafting.NCRecipeHelper;
import nc.item.NCItems;
import nc.tile.machine.TileInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileMachineBase
extends TileInventory
implements IEnergyHandler,
IEnergyReceiver {
    public final double processTime;
    public final double energyRequired;
    public final int inputSize;
    public final int outputSize;
    public int speedMod = 100;
    public int timeMod = 100;
    public String localizedName;
    public EnergyStorage energyStorage;
    public boolean flag;
    public boolean flag1 = false;
    public boolean hasUpgrades;
    public boolean hasEnergy;
    public NCRecipeHelper recipes;
    public int energy;
    public int cookTime = 0;
    public int[] automation;
    public double speedUpgrade = 1.0;
    public double energyUpgrade = 1.0;
    public double getProcessTime = Math.ceil(this.ProcessTime() / this.speedUpgrade);
    public double getEnergyRequired = Math.ceil(this.speedUpgrade * (this.EnergyRequired() / this.energyUpgrade));

    public TileMachineBase(String localName, int energyMax, int inSize, int outSize, boolean usesUpgrades, boolean usesEnergy, double pt, double er, int smod, int tmod, NCRecipeHelper ncrecipes) {
        this.energyStorage = new EnergyStorage(energyMax, energyMax);
        this.localizedName = localName;
        this.inputSize = inSize;
        this.outputSize = outSize;
        this.hasUpgrades = usesUpgrades;
        this.hasEnergy = usesEnergy;
        this.slots = new ItemStack[inSize + outSize + (usesUpgrades ? 2 : 0)];
        this.processTime = pt;
        this.energyRequired = er;
        this.speedMod = smod;
        this.timeMod = tmod;
        this.recipes = ncrecipes;
        int[] a = new int[inSize + outSize];
        for (int i = 0; i < a.length; ++i) {
            a[i] = i;
        }
        this.automation = a;
    }

    public void func_145845_h() {
        super.func_145845_h();
        this.upgradeSpeed();
        this.upgradeEnergy();
        this.getProcessTime = this.hasUpgrades ? Math.ceil(this.ProcessTime() / this.speedUpgrade) : this.ProcessTime();
        this.getEnergyRequired = this.hasUpgrades ? Math.ceil(this.speedUpgrade * (this.EnergyRequired() / this.energyUpgrade)) : this.EnergyRequired();
        if (!this.field_145850_b.field_72995_K) {
            if (this.canCook()) {
                ++this.cookTime;
                this.energyStorage.extractEnergy((int)Math.ceil(this.getEnergyRequired / this.getProcessTime), false);
                if ((double)this.cookTime >= this.getProcessTime) {
                    this.cookTime = 0;
                    this.cookItem();
                }
            } else {
                this.cookTime = 0;
            }
        }
    }

    public boolean isOxygen(ItemStack stack) {
        return false;
    }

    public boolean isOxidiser() {
        return false;
    }

    public boolean isNeutronCapsule(ItemStack stack) {
        return false;
    }

    public boolean isIrradiator() {
        return false;
    }

    public boolean isHydrogen(ItemStack stack) {
        return false;
    }

    public boolean isIoniser() {
        return false;
    }

    public ItemStack[] inputs() {
        ItemStack[] input = new ItemStack[this.inputSize];
        for (int i = 0; i < this.inputSize; ++i) {
            input[i] = this.slots[i];
        }
        return input;
    }

    public boolean canCook() {
        ItemStack[] output;
        for (int i = 0; i < this.inputSize; ++i) {
            if (this.slots[i] != null) continue;
            this.flag = false;
            return false;
        }
        if ((double)this.cookTime >= this.getProcessTime) {
            this.flag = true;
            return true;
        }
        if (this.getEnergyRequired > (double)this.energyStorage.getMaxEnergyStored() && this.cookTime <= 0 && this.energyStorage.getEnergyStored() < this.energyStorage.getMaxEnergyStored() - (int)Math.ceil(this.getEnergyRequired / this.getProcessTime)) {
            this.flag = false;
            return false;
        }
        if (this.getEnergyRequired < (double)this.energyStorage.getMaxEnergyStored() && this.cookTime <= 0 && this.getEnergyRequired > (double)this.energyStorage.getEnergyStored()) {
            this.flag = false;
            return false;
        }
        if (this.hasEnergy) {
            if (this.energyStorage.getEnergyStored() < 1 * (int)Math.ceil(this.getEnergyRequired / this.getProcessTime)) {
                this.flag = false;
                return false;
            }
            if (this.energyStorage.getEnergyStored() == 0) {
                this.flag = false;
                return false;
            }
        }
        if ((output = this.getOutput(this.inputs())) == null || output.length != this.outputSize) {
            return false;
        }
        for (int j = 0; j < this.outputSize; ++j) {
            if (output[j] == null) {
                this.flag = false;
                return false;
            }
            if (this.slots[j + this.inputSize] == null) continue;
            if (!this.slots[j + this.inputSize].func_77969_a(output[j])) {
                this.flag = false;
                return false;
            }
            if (this.slots[j + this.inputSize].field_77994_a + output[j].field_77994_a <= this.slots[j + this.inputSize].func_77976_d()) continue;
            this.flag = false;
            return false;
        }
        this.flag = true;
        return true;
    }

    public ItemStack[] getOutput(ItemStack ... itemstacks) {
        return this.recipes.getOutput(itemstacks);
    }

    public double ProcessTime() {
        return this.processTime * (100.0 / (double)this.speedMod);
    }

    public double EnergyRequired() {
        return this.energyRequired * (100.0 / (double)this.timeMod);
    }

    public void cookItem() {
        ItemStack[] output = this.getOutput(this.inputs());
        for (int j = 0; j < this.outputSize; ++j) {
            if (output[j] == null) continue;
            if (this.slots[j + this.inputSize] == null) {
                ItemStack outputStack;
                this.slots[j + this.inputSize] = outputStack = output[j].func_77946_l();
                continue;
            }
            if (!this.slots[j + this.inputSize].func_77969_a(output[j])) continue;
            this.slots[j + this.inputSize].field_77994_a += output[j].field_77994_a;
        }
        for (int i = 0; i < this.inputSize; ++i) {
            this.slots[i].field_77994_a = this.recipes != null ? (this.slots[i].field_77994_a -= this.recipes.getInputSize(i, output)) : --this.slots[i].field_77994_a;
            if (this.slots[i].field_77994_a > 0) continue;
            this.slots[i] = null;
        }
    }

    public void upgradeSpeed() {
        if (this.hasUpgrades) {
            ItemStack stack = this.func_70301_a(this.inputSize + this.outputSize);
            this.speedUpgrade = stack != null && TileMachineBase.isSpeedUpgrade(stack) ? Math.pow(1.8, stack.field_77994_a) : 1.0;
        }
    }

    public static boolean isSpeedUpgrade(ItemStack stack) {
        return stack.func_77973_b() == NCItems.upgradeSpeed;
    }

    public void upgradeEnergy() {
        if (this.hasUpgrades) {
            ItemStack stack = this.func_70301_a(this.inputSize + this.outputSize + 1);
            this.energyUpgrade = stack != null && TileMachineBase.isEnergyUpgrade(stack) ? Math.pow(1.7, stack.field_77994_a) : 1.0;
        }
    }

    public static boolean isEnergyUpgrade(ItemStack stack) {
        return stack.func_77973_b() == NCItems.upgradeEnergy;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("energyStorage")) {
            this.energyStorage.readFromNBT(nbt.func_74775_l("energyStorage"));
            this.speedUpgrade = nbt.func_74769_h("sU");
            this.energyUpgrade = nbt.func_74769_h("eU");
            this.getProcessTime = nbt.func_74769_h("s");
            this.getEnergyRequired = nbt.func_74769_h("e");
        }
        NBTTagList list = nbt.func_150295_c("Items", 10);
        this.slots = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound compound = list.func_150305_b(i);
            byte b = compound.func_74771_c("Slot");
            if (b < 0 || b >= this.slots.length) continue;
            this.slots[b] = ItemStack.func_77949_a((NBTTagCompound)compound);
        }
        this.cookTime = nbt.func_74765_d("CookTime");
        this.flag = nbt.func_74767_n("flag");
        this.flag1 = nbt.func_74767_n("flag1");
    }

    public void readSides(NBTTagCompound nbt) {
    }

    public void readEnergy(NBTTagCompound nbt) {
        if (nbt.func_74764_b("energyStorage")) {
            this.energyStorage.readFromNBT(nbt.func_74775_l("energyStorage"));
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagCompound energyTag = new NBTTagCompound();
        this.energyStorage.writeToNBT(energyTag);
        nbt.func_74782_a("energyStorage", (NBTBase)energyTag);
        NBTTagList list = new NBTTagList();
        nbt.func_74757_a("flag", this.flag);
        nbt.func_74757_a("flag1", this.flag1);
        nbt.func_74780_a("sU", this.speedUpgrade);
        nbt.func_74780_a("eU", this.energyUpgrade);
        nbt.func_74780_a("s", this.getProcessTime);
        nbt.func_74780_a("e", this.getEnergyRequired);
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74774_a("Slot", (byte)i);
            this.slots[i].func_77955_b(compound);
            list.func_74742_a((NBTBase)compound);
        }
        nbt.func_74777_a("CookTime", (short)this.cookTime);
        nbt.func_74782_a("Items", (NBTBase)list);
    }

    public void writeSides(NBTTagCompound nbt) {
    }

    public void writeEnergy(NBTTagCompound nbt) {
        NBTTagCompound energyTag = new NBTTagCompound();
        this.energyStorage.writeToNBT(energyTag);
        nbt.func_74782_a("energyStorage", (NBTBase)energyTag);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        nbtTag.func_74768_a("Energy", this.energyStorage.getEnergyStored());
        this.energy = nbtTag.func_74762_e("Energy");
        this.writeSides(nbtTag);
        this.writeEnergy(nbtTag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbtTag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        this.readSides(packet.func_148857_g());
        this.readEnergy(packet.func_148857_g());
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return this.hasEnergy;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.energyStorage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.energyStorage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.energyStorage.getMaxEnergyStored();
    }

    public int getEnergy() {
        if (this.energyStorage.getEnergyStored() == 0) {
            return this.energy;
        }
        return this.energyStorage.getEnergyStored();
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        if (this.isOxidiser()) {
            if (this.isOxygen(itemstack)) {
                return slot == 1;
            }
            return slot == 0;
        }
        if (this.isIrradiator()) {
            if (this.isNeutronCapsule(itemstack)) {
                return slot == 1;
            }
            return slot == 0;
        }
        if (this.isIoniser()) {
            if (this.isHydrogen(itemstack)) {
                return slot == 1;
            }
            return slot == 0;
        }
        return slot < this.inputSize;
    }

    public int[] func_94128_d(int i) {
        return this.automation;
    }

    public boolean func_102007_a(int slot, ItemStack itemstack, int side) {
        return this.func_94041_b(slot, itemstack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot > this.inputSize - 1 && slot < this.outputSize + this.inputSize;
    }

    @Override
    public int func_70302_i_() {
        return this.slots.length;
    }

    public String getName() {
        return this.func_145838_q().func_149739_a();
    }

    public int getType() {
        return this.func_145832_p();
    }
}

