/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.accelerator;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyReceiver;
import nc.NuclearCraft;
import nc.block.NCBlocks;
import nc.block.accelerator.BlockSynchrotron;
import nc.item.NCItems;
import nc.tile.machine.TileInventory;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileSynchrotron
extends TileInventory
implements IEnergyHandler,
IEnergyReceiver,
ISidedInventory {
    public int maxStorage;
    public boolean flag;
    public boolean flag1 = false;
    public int complete;
    public int energy;
    public int orientation;
    public EnergyStorage storage;
    public static int rawLength;
    public int length;
    public double fuel;
    public double radiationPower;
    public double antimatter;
    public double efficiency;
    public double particleEnergy;
    public double percentageOn;
    public static int fuelMax;
    private static double k;
    private static double c;
    private static double e;
    private static double m;
    public String problem = StatCollector.func_74838_a((String)"gui.ringIncomplete");
    private static final int[] slots1;
    private int soundCount = 0;
    private int checkCount = 0;

    public TileSynchrotron() {
        this.storage = new EnergyStorage(1000000, 1000000);
        this.localizedName = "Synchrotron";
        this.slots = new ItemStack[3];
    }

    private void sound(int x, int y, int z) {
        ForgeDirection forward = ForgeDirection.getOrientation((int)this.func_145832_p()).getOpposite();
        int xc = this.field_145851_c + 2 * forward.offsetX;
        int yc = this.field_145848_d + y + 3;
        int zc = this.field_145849_e + 2 * forward.offsetZ;
        if (this.func_145832_p() == 4) {
            this.field_145850_b.func_72908_a((double)(xc + x), (double)yc, (double)(zc + z), "nc:shield2", 0.85f, 1.0f);
        } else if (this.func_145832_p() == 2) {
            this.field_145850_b.func_72908_a((double)(xc - z), (double)yc, (double)(zc + x), "nc:shield2", 0.85f, 1.0f);
        } else if (this.func_145832_p() == 5) {
            this.field_145850_b.func_72908_a((double)(xc - x), (double)yc, (double)(zc - z), "nc:shield2", 0.85f, 1.0f);
        } else if (this.func_145832_p() == 3) {
            this.field_145850_b.func_72908_a((double)(xc + z), (double)yc, (double)(zc - x), "nc:shield2", 0.85f, 1.0f);
        }
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            this.percentageOn();
            this.fuel();
            this.power();
        }
        if (this.flag != this.flag1) {
            this.flag1 = this.flag;
            BlockSynchrotron.updateBlockState(this.flag, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (this.soundCount >= 67) {
            if (this.storage.getEnergyStored() >= (int)(1000.0 * ((200.0 - this.efficiency / 10000.0) / 100.0)) && this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e) && this.flag1 && this.percentageOn > 0.0 && this.fuel - (double)this.length >= 0.0 && NuclearCraft.acceleratorSounds) {
                for (int r = 0; r <= (this.length - 7) / 7; ++r) {
                    if (this.orientation == 0) {
                        this.sound(7 * r, 0, 0);
                        this.sound(this.length + 1 - 7 * r, 0, this.length + 1);
                        this.sound(0, 0, this.length + 1 - 7 * r);
                        this.sound(this.length + 1, 0, 7 * r);
                        continue;
                    }
                    if (this.orientation != 1) continue;
                    this.sound(7 * r, 0, 0);
                    this.sound(this.length + 1 - 7 * r, 0, -this.length - 1);
                    this.sound(0, 0, -this.length - 1 + 7 * r);
                    this.sound(this.length + 1, 0, -7 * r);
                }
            }
            this.soundCount = 0;
        } else {
            ++this.soundCount;
        }
        this.func_70296_d();
        if (this.fuel < 0.0) {
            this.fuel = 0.0;
        }
        if (!this.field_145850_b.field_72995_K && this.checkCount >= NuclearCraft.acceleratorUpdateRate) {
            this.checkRing();
            this.checkCount = 0;
        } else {
            ++this.checkCount;
        }
    }

    private void fuel() {
        ItemStack stack = this.func_70301_a(0);
        ItemStack stack1 = this.func_70301_a(1);
        if (stack != null && TileSynchrotron.isFuel(stack) && this.fuel + 10000.0 <= (double)fuelMax && (stack1 == null || stack1 != null && stack1.field_77994_a < 64)) {
            this.fuel += 10000.0;
            --this.slots[0].field_77994_a;
            if (this.slots[0].field_77994_a <= 0) {
                this.slots[0] = null;
            }
            if (this.slots[1] == null) {
                this.slots[1] = new ItemStack(NCItems.fuel, 1, 48);
            } else if (this.slots[1].field_77994_a < 64) {
                ++this.slots[1].field_77994_a;
            }
        }
    }

    private void power() {
        if (this.storage.getEnergyStored() >= (int)(1000.0 * ((200.0 - this.efficiency / 10000.0) / 100.0)) && this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e) && this.flag1 && this.percentageOn > 0.0 && this.fuel - (double)this.length >= 0.0) {
            this.fuel -= (this.fuel < (double)(fuelMax / 2) ? (double)this.length * (this.fuel * 2.0 + 7500.0) / (double)fuelMax : (double)(this.length * (fuelMax + 7500) / fuelMax)) / 4.0;
            this.storage.receiveEnergy(-((int)(1000.0 * ((200.0 - this.efficiency / 10000.0) / 100.0))), false);
            this.efficiency = this.efficiency >= 1000000.0 ? 1000000.0 : (this.efficiency += (double)(5000 / (this.length + 1)));
            if (this.length > 0) {
                this.radiationPower = (this.fuel < (double)(fuelMax / 2) ? this.fuel * 2.0 / (double)fuelMax : 1.0) * ((double)(32 * ((this.length * 100 + 1) / 100) * ((this.length * 100 + 1) / 100)) * this.percentageOn * (double)(NuclearCraft.superElectromagnetRF / 100) * (this.efficiency / 10000.0)) / 1000.0;
            }
            this.particleEnergy = this.percentageOn / 100.0 * (m * c * c * (1.0 / Math.sqrt(1.0 - Math.pow(Math.sqrt((2.0 * Math.sqrt(6.0) * e * Math.pow(c, 2.0) * Math.sqrt(k) * (double)(this.length * 100) * ((double)(32 * ((this.length * 100 + 1) / 100) * ((this.length * 100 + 1) / 100)) * this.percentageOn * (double)(NuclearCraft.superElectromagnetRF / 100) * (this.efficiency / 10000.0)) * Math.pow(10.0, 5.5) - 3.0 * c * c * (double)(this.length * 100) * (double)(this.length * 100) * ((double)(32 * ((this.length * 100 + 1) / 100) * ((this.length * 100 + 1) / 100)) * this.percentageOn * (double)(NuclearCraft.superElectromagnetRF / 100) * (this.efficiency / 10000.0)) * Math.pow(10.0, 10.0)) / (8.0 * e * e * c * k * Math.pow(10.0, -15.0) - (double)(3 * (this.length * 100) * (this.length * 100)) * ((double)(32 * ((this.length * 100 + 1) / 100) * ((this.length * 100 + 1) / 100)) * this.percentageOn * (double)(NuclearCraft.superElectromagnetRF / 100) * (this.efficiency / 10000.0)) * Math.pow(10.0, -6.0))) / 2.99792458E8, 2.0)) - 1.0) * Math.pow(10.0, 4.0)) / (1000.0 * e);
            if (this.antimatter < 2.56E8) {
                this.antimatter += this.radiationPower / (double)(64000 / NuclearCraft.acceleratorProduction);
            }
        } else {
            this.efficiency = this.efficiency > 2500.0 ? (this.efficiency -= 2500.0) : 0.0;
            this.radiationPower = 0.0;
            this.particleEnergy = 0.0;
        }
        if (this.antimatter >= 6.4E7) {
            if (this.slots[2] == null || this.slots[2].field_77994_a == 0) {
                this.slots[2] = new ItemStack(NCItems.antimatter, 1);
                this.antimatter -= 6.4E7;
            } else if (this.slots[2].field_77994_a < 64) {
                ++this.slots[2].field_77994_a;
                this.antimatter -= 6.4E7;
            }
        }
    }

    private boolean find(Block block, int x, int y, int z) {
        ForgeDirection forward = ForgeDirection.getOrientation((int)this.func_145832_p()).getOpposite();
        int xc = this.field_145851_c + 2 * forward.offsetX;
        int yc = this.field_145848_d + y;
        int zc = this.field_145849_e + 2 * forward.offsetZ;
        if (this.func_145832_p() == 4) {
            return this.field_145850_b.func_147439_a(xc + x, yc, zc + z) == block;
        }
        if (this.func_145832_p() == 2) {
            return this.field_145850_b.func_147439_a(xc - z, yc, zc + x) == block;
        }
        if (this.func_145832_p() == 5) {
            return this.field_145850_b.func_147439_a(xc - x, yc, zc - z) == block;
        }
        if (this.func_145832_p() == 3) {
            return this.field_145850_b.func_147439_a(xc + z, yc, zc - x) == block;
        }
        return false;
    }

    private boolean find(Block block, Block block2, int x, int y, int z) {
        ForgeDirection forward = ForgeDirection.getOrientation((int)this.func_145832_p()).getOpposite();
        int xc = this.field_145851_c + 2 * forward.offsetX;
        int yc = this.field_145848_d + y;
        int zc = this.field_145849_e + 2 * forward.offsetZ;
        if (this.func_145832_p() == 4) {
            return this.field_145850_b.func_147439_a(xc + x, yc, zc + z) == block || this.field_145850_b.func_147439_a(xc + x, yc, zc + z) == block2;
        }
        if (this.func_145832_p() == 2) {
            return this.field_145850_b.func_147439_a(xc - z, yc, zc + x) == block || this.field_145850_b.func_147439_a(xc - z, yc, zc + x) == block2;
        }
        if (this.func_145832_p() == 5) {
            return this.field_145850_b.func_147439_a(xc - x, yc, zc - z) == block || this.field_145850_b.func_147439_a(xc - x, yc, zc - z) == block2;
        }
        if (this.func_145832_p() == 3) {
            return this.field_145850_b.func_147439_a(xc + z, yc, zc - x) == block || this.field_145850_b.func_147439_a(xc + z, yc, zc - x) == block2;
        }
        return false;
    }

    private boolean tubef(int x, int y, int z) {
        Block a = Blocks.field_150350_a;
        Block e = NCBlocks.superElectromagnetIdle;
        Block ee = NCBlocks.superElectromagnetActive;
        Block c = NCBlocks.supercoolerIdle;
        Block cc = NCBlocks.supercoolerActive;
        return this.find(c, cc, x, y - 1, z - 1) && this.find(c, cc, x, y + 1, z - 1) && this.find(c, cc, x, y - 1, z + 1) && this.find(c, cc, x, y + 1, z + 1) && this.find(e, ee, x, y - 1, z) && this.find(e, ee, x, y, z + 1) && this.find(e, ee, x, y + 1, z) && this.find(e, ee, x, y, z - 1) && this.find(a, x, y, z);
    }

    private boolean tuber(int x, int y, int z) {
        Block a = Blocks.field_150350_a;
        Block e = NCBlocks.superElectromagnetIdle;
        Block ee = NCBlocks.superElectromagnetActive;
        Block c = NCBlocks.supercoolerIdle;
        Block cc = NCBlocks.supercoolerActive;
        return this.find(c, cc, x + 1, y - 1, z) && this.find(c, cc, x - 1, y - 1, z) && this.find(c, cc, x + 1, y + 1, z) && this.find(c, cc, x - 1, y + 1, z) && this.find(e, ee, x, y - 1, z) && this.find(e, ee, x + 1, y, z) && this.find(e, ee, x, y + 1, z) && this.find(e, ee, x - 1, y, z) && this.find(a, x, y, z);
    }

    private boolean tubefOn(int x, int y, int z) {
        Block a = Blocks.field_150350_a;
        Block ee = NCBlocks.superElectromagnetActive;
        Block cc = NCBlocks.supercoolerActive;
        return this.find(cc, x, y - 1, z - 1) && this.find(cc, x, y + 1, z - 1) && this.find(cc, x, y - 1, z + 1) && this.find(cc, x, y + 1, z + 1) && this.find(ee, x, y - 1, z) && this.find(ee, x, y, z + 1) && this.find(ee, x, y + 1, z) && this.find(ee, x, y, z - 1) && this.find(a, x, y, z);
    }

    private boolean tuberOn(int x, int y, int z) {
        Block a = Blocks.field_150350_a;
        Block ee = NCBlocks.superElectromagnetActive;
        Block cc = NCBlocks.supercoolerActive;
        return this.find(cc, x + 1, y - 1, z) && this.find(cc, x - 1, y - 1, z) && this.find(cc, x + 1, y + 1, z) && this.find(cc, x - 1, y + 1, z) && this.find(ee, x, y - 1, z) && this.find(ee, x + 1, y, z) && this.find(ee, x, y + 1, z) && this.find(ee, x - 1, y, z) && this.find(a, x, y, z);
    }

    private boolean cornertl(int x, int y, int z) {
        Block a = Blocks.field_150350_a;
        Block e = NCBlocks.superElectromagnetIdle;
        Block ee = NCBlocks.superElectromagnetActive;
        Block c = NCBlocks.supercoolerIdle;
        Block cc = NCBlocks.supercoolerActive;
        return this.find(c, cc, x - 1, y - 1, z - 1) && this.find(c, cc, x, y - 1, z - 1) && this.find(c, cc, x + 1, y - 1, z - 1) && this.find(c, cc, x + 1, y - 1, z) && this.find(c, cc, x + 1, y - 1, z + 1) && this.find(c, cc, x - 1, y - 1, z + 1) && this.find(e, ee, x - 1, y - 1, z) && this.find(e, ee, x, y - 1, z) && this.find(e, ee, x, y - 1, z + 1) && this.find(e, ee, x - 1, y, z - 1) && this.find(e, ee, x, y, z - 1) && this.find(e, ee, x + 1, y, z - 1) && this.find(e, ee, x + 1, y, z) && this.find(e, ee, x + 1, y, z + 1) && this.find(e, ee, x - 1, y, z + 1) && this.find(a, x - 1, y, z) && this.find(a, x, y, z) && this.find(a, x, y, z + 1) && this.find(c, cc, x - 1, y + 1, z - 1) && this.find(c, cc, x, y + 1, z - 1) && this.find(c, cc, x + 1, y + 1, z - 1) && this.find(c, cc, x + 1, y + 1, z) && this.find(c, cc, x + 1, y + 1, z + 1) && this.find(c, cc, x - 1, y + 1, z + 1) && this.find(e, ee, x - 1, y + 1, z) && this.find(e, ee, x, y + 1, z) && this.find(e, ee, x, y + 1, z + 1);
    }

    private boolean cornerbl(int x, int y, int z) {
        Block a = Blocks.field_150350_a;
        Block e = NCBlocks.superElectromagnetIdle;
        Block ee = NCBlocks.superElectromagnetActive;
        Block c = NCBlocks.supercoolerIdle;
        Block cc = NCBlocks.supercoolerActive;
        return this.find(c, cc, x + 1, y - 1, z - 1) && this.find(c, cc, x, y - 1, z - 1) && this.find(c, cc, x - 1, y - 1, z - 1) && this.find(c, cc, x - 1, y - 1, z) && this.find(c, cc, x - 1, y - 1, z + 1) && this.find(c, cc, x + 1, y - 1, z + 1) && this.find(e, ee, x + 1, y - 1, z) && this.find(e, ee, x, y - 1, z) && this.find(e, ee, x, y - 1, z + 1) && this.find(e, ee, x + 1, y, z - 1) && this.find(e, ee, x, y, z - 1) && this.find(e, ee, x - 1, y, z - 1) && this.find(e, ee, x - 1, y, z) && this.find(e, ee, x - 1, y, z + 1) && this.find(e, ee, x + 1, y, z + 1) && this.find(a, x + 1, y, z) && this.find(a, x, y, z) && this.find(a, x, y, z + 1) && this.find(c, cc, x + 1, y + 1, z - 1) && this.find(c, cc, x, y + 1, z - 1) && this.find(c, cc, x - 1, y + 1, z - 1) && this.find(c, cc, x - 1, y + 1, z) && this.find(c, cc, x - 1, y + 1, z + 1) && this.find(c, cc, x + 1, y + 1, z + 1) && this.find(e, ee, x + 1, y + 1, z) && this.find(e, ee, x, y + 1, z) && this.find(e, ee, x, y + 1, z + 1);
    }

    private boolean cornertr(int x, int y, int z) {
        Block a = Blocks.field_150350_a;
        Block e = NCBlocks.superElectromagnetIdle;
        Block ee = NCBlocks.superElectromagnetActive;
        Block c = NCBlocks.supercoolerIdle;
        Block cc = NCBlocks.supercoolerActive;
        return this.find(c, cc, x - 1, y - 1, z + 1) && this.find(c, cc, x, y - 1, z + 1) && this.find(c, cc, x + 1, y - 1, z + 1) && this.find(c, cc, x + 1, y - 1, z) && this.find(c, cc, x + 1, y - 1, z - 1) && this.find(c, cc, x - 1, y - 1, z - 1) && this.find(e, ee, x - 1, y - 1, z) && this.find(e, ee, x, y - 1, z) && this.find(e, ee, x, y - 1, z - 1) && this.find(e, ee, x - 1, y, z + 1) && this.find(e, ee, x, y, z + 1) && this.find(e, ee, x + 1, y, z + 1) && this.find(e, ee, x + 1, y, z) && this.find(e, ee, x + 1, y, z - 1) && this.find(e, ee, x - 1, y, z - 1) && this.find(a, x - 1, y, z) && this.find(a, x, y, z) && this.find(a, x, y, z - 1) && this.find(c, cc, x - 1, y + 1, z + 1) && this.find(c, cc, x, y + 1, z + 1) && this.find(c, cc, x + 1, y + 1, z + 1) && this.find(c, cc, x + 1, y + 1, z) && this.find(c, cc, x + 1, y + 1, z - 1) && this.find(c, cc, x - 1, y + 1, z - 1) && this.find(e, ee, x - 1, y + 1, z) && this.find(e, ee, x, y + 1, z) && this.find(e, ee, x, y + 1, z - 1);
    }

    private boolean cornerbr(int x, int y, int z) {
        Block a = Blocks.field_150350_a;
        Block e = NCBlocks.superElectromagnetIdle;
        Block ee = NCBlocks.superElectromagnetActive;
        Block c = NCBlocks.supercoolerIdle;
        Block cc = NCBlocks.supercoolerActive;
        return this.find(c, cc, x + 1, y - 1, z + 1) && this.find(c, cc, x, y - 1, z + 1) && this.find(c, cc, x - 1, y - 1, z + 1) && this.find(c, cc, x - 1, y - 1, z) && this.find(c, cc, x - 1, y - 1, z - 1) && this.find(c, cc, x + 1, y - 1, z - 1) && this.find(e, ee, x + 1, y - 1, z) && this.find(e, ee, x, y - 1, z) && this.find(e, ee, x, y - 1, z - 1) && this.find(e, ee, x + 1, y, z + 1) && this.find(e, ee, x, y, z + 1) && this.find(e, ee, x - 1, y, z + 1) && this.find(e, ee, x - 1, y, z) && this.find(e, ee, x - 1, y, z - 1) && this.find(e, ee, x + 1, y, z - 1) && this.find(a, x + 1, y, z) && this.find(a, x, y, z) && this.find(a, x, y, z - 1) && this.find(c, cc, x + 1, y + 1, z + 1) && this.find(c, cc, x, y + 1, z + 1) && this.find(c, cc, x - 1, y + 1, z + 1) && this.find(c, cc, x - 1, y + 1, z) && this.find(c, cc, x - 1, y + 1, z - 1) && this.find(c, cc, x + 1, y + 1, z - 1) && this.find(e, ee, x + 1, y + 1, z) && this.find(e, ee, x, y + 1, z) && this.find(e, ee, x, y + 1, z - 1);
    }

    private boolean cornertlOn(int x, int y, int z) {
        Block a = Blocks.field_150350_a;
        Block e = NCBlocks.superElectromagnetIdle;
        Block ee = NCBlocks.superElectromagnetActive;
        Block cc = NCBlocks.supercoolerActive;
        return this.find(cc, x - 1, y - 1, z - 1) && this.find(cc, x, y - 1, z - 1) && this.find(cc, x + 1, y - 1, z - 1) && this.find(cc, x + 1, y - 1, z) && this.find(cc, x + 1, y - 1, z + 1) && this.find(cc, x - 1, y - 1, z + 1) && this.find(ee, x - 1, y - 1, z) && this.find(ee, x, y - 1, z) && this.find(ee, x, y - 1, z + 1) && this.find(ee, x - 1, y, z - 1) && this.find(ee, x, y, z - 1) && this.find(ee, x + 1, y, z - 1) && this.find(ee, x + 1, y, z) && this.find(ee, x + 1, y, z + 1) && this.find(e, ee, x - 1, y, z + 1) && this.find(a, x - 1, y, z) && this.find(a, x, y, z) && this.find(a, x, y, z + 1) && this.find(cc, x - 1, y + 1, z - 1) && this.find(cc, x, y + 1, z - 1) && this.find(cc, x + 1, y + 1, z - 1) && this.find(cc, x + 1, y + 1, z) && this.find(cc, x + 1, y + 1, z + 1) && this.find(cc, x - 1, y + 1, z + 1) && this.find(ee, x - 1, y + 1, z) && this.find(ee, x, y + 1, z) && this.find(ee, x, y + 1, z + 1);
    }

    private boolean cornertrOn(int x, int y, int z) {
        Block a = Blocks.field_150350_a;
        Block e = NCBlocks.superElectromagnetIdle;
        Block ee = NCBlocks.superElectromagnetActive;
        Block cc = NCBlocks.supercoolerActive;
        return this.find(cc, x - 1, y - 1, z + 1) && this.find(cc, x, y - 1, z + 1) && this.find(cc, x + 1, y - 1, z + 1) && this.find(cc, x + 1, y - 1, z) && this.find(cc, x + 1, y - 1, z - 1) && this.find(cc, x - 1, y - 1, z - 1) && this.find(ee, x - 1, y - 1, z) && this.find(ee, x, y - 1, z) && this.find(ee, x, y - 1, z - 1) && this.find(ee, x - 1, y, z + 1) && this.find(ee, x, y, z + 1) && this.find(ee, x + 1, y, z + 1) && this.find(ee, x + 1, y, z) && this.find(ee, x + 1, y, z - 1) && this.find(e, ee, x - 1, y, z - 1) && this.find(a, x - 1, y, z) && this.find(a, x, y, z) && this.find(a, x, y, z - 1) && this.find(cc, x - 1, y + 1, z + 1) && this.find(cc, x, y + 1, z + 1) && this.find(cc, x + 1, y + 1, z + 1) && this.find(cc, x + 1, y + 1, z) && this.find(cc, x + 1, y + 1, z - 1) && this.find(cc, x - 1, y + 1, z - 1) && this.find(ee, x - 1, y + 1, z) && this.find(ee, x, y + 1, z) && this.find(ee, x, y + 1, z - 1);
    }

    private boolean cornerblOnl(int x, int y, int z) {
        Block a = Blocks.field_150350_a;
        Block e = NCBlocks.superElectromagnetIdle;
        Block ee = NCBlocks.superElectromagnetActive;
        Block cc = NCBlocks.supercoolerActive;
        return this.find(cc, x + 1, y - 1, z - 1) && this.find(cc, x, y - 1, z - 1) && this.find(cc, x - 1, y - 1, z - 1) && this.find(cc, x - 1, y - 1, z) && this.find(cc, x - 1, y - 1, z + 1) && this.find(cc, x + 1, y - 1, z + 1) && this.find(ee, x + 1, y - 1, z) && this.find(ee, x, y - 1, z) && this.find(ee, x, y - 1, z + 1) && this.find(ee, x + 1, y, z - 1) && this.find(ee, x, y, z - 1) && this.find(ee, x - 1, y, z - 1) && this.find(e, ee, x - 1, y, z) && this.find(ee, x - 1, y, z + 1) && this.find(e, ee, x + 1, y, z + 1) && this.find(a, x + 1, y, z) && this.find(a, x, y, z) && this.find(a, x, y, z + 1) && this.find(cc, x + 1, y + 1, z - 1) && this.find(cc, x, y + 1, z - 1) && this.find(cc, x - 1, y + 1, z - 1) && this.find(cc, x - 1, y + 1, z) && this.find(cc, x - 1, y + 1, z + 1) && this.find(cc, x + 1, y + 1, z + 1) && this.find(ee, x + 1, y + 1, z) && this.find(ee, x, y + 1, z) && this.find(ee, x, y + 1, z + 1);
    }

    private boolean cornerbrOnl(int x, int y, int z) {
        Block a = Blocks.field_150350_a;
        Block e = NCBlocks.superElectromagnetIdle;
        Block ee = NCBlocks.superElectromagnetActive;
        Block cc = NCBlocks.supercoolerActive;
        return this.find(cc, x + 1, y - 1, z + 1) && this.find(cc, x, y - 1, z + 1) && this.find(cc, x - 1, y - 1, z + 1) && this.find(cc, x - 1, y - 1, z) && this.find(cc, x - 1, y - 1, z - 1) && this.find(cc, x + 1, y - 1, z - 1) && this.find(ee, x + 1, y - 1, z) && this.find(ee, x, y - 1, z) && this.find(ee, x, y - 1, z - 1) && this.find(ee, x + 1, y, z + 1) && this.find(ee, x, y, z + 1) && this.find(ee, x - 1, y, z + 1) && this.find(ee, x - 1, y, z) && this.find(ee, x - 1, y, z - 1) && this.find(e, ee, x + 1, y, z - 1) && this.find(a, x + 1, y, z) && this.find(a, x, y, z) && this.find(a, x, y, z - 1) && this.find(cc, x + 1, y + 1, z + 1) && this.find(cc, x, y + 1, z + 1) && this.find(cc, x - 1, y + 1, z + 1) && this.find(cc, x - 1, y + 1, z) && this.find(cc, x - 1, y + 1, z - 1) && this.find(cc, x + 1, y + 1, z - 1) && this.find(ee, x + 1, y + 1, z) && this.find(ee, x, y + 1, z) && this.find(ee, x, y + 1, z - 1);
    }

    private boolean cornerblOnr(int x, int y, int z) {
        Block a = Blocks.field_150350_a;
        Block e = NCBlocks.superElectromagnetIdle;
        Block ee = NCBlocks.superElectromagnetActive;
        Block cc = NCBlocks.supercoolerActive;
        return this.find(cc, x + 1, y - 1, z - 1) && this.find(cc, x, y - 1, z - 1) && this.find(cc, x - 1, y - 1, z - 1) && this.find(cc, x - 1, y - 1, z) && this.find(cc, x - 1, y - 1, z + 1) && this.find(cc, x + 1, y - 1, z + 1) && this.find(ee, x + 1, y - 1, z) && this.find(ee, x, y - 1, z) && this.find(ee, x, y - 1, z + 1) && this.find(ee, x + 1, y, z - 1) && this.find(ee, x, y, z - 1) && this.find(ee, x - 1, y, z - 1) && this.find(ee, x - 1, y, z) && this.find(ee, x - 1, y, z + 1) && this.find(e, ee, x + 1, y, z + 1) && this.find(a, x + 1, y, z) && this.find(a, x, y, z) && this.find(a, x, y, z + 1) && this.find(cc, x + 1, y + 1, z - 1) && this.find(cc, x, y + 1, z - 1) && this.find(cc, x - 1, y + 1, z - 1) && this.find(cc, x - 1, y + 1, z) && this.find(cc, x - 1, y + 1, z + 1) && this.find(cc, x + 1, y + 1, z + 1) && this.find(ee, x + 1, y + 1, z) && this.find(ee, x, y + 1, z) && this.find(ee, x, y + 1, z + 1);
    }

    private boolean cornerbrOnr(int x, int y, int z) {
        Block a = Blocks.field_150350_a;
        Block e = NCBlocks.superElectromagnetIdle;
        Block ee = NCBlocks.superElectromagnetActive;
        Block cc = NCBlocks.supercoolerActive;
        return this.find(cc, x + 1, y - 1, z + 1) && this.find(cc, x, y - 1, z + 1) && this.find(cc, x - 1, y - 1, z + 1) && this.find(cc, x - 1, y - 1, z) && this.find(cc, x - 1, y - 1, z - 1) && this.find(cc, x + 1, y - 1, z - 1) && this.find(ee, x + 1, y - 1, z) && this.find(ee, x, y - 1, z) && this.find(ee, x, y - 1, z - 1) && this.find(ee, x + 1, y, z + 1) && this.find(ee, x, y, z + 1) && this.find(ee, x - 1, y, z + 1) && this.find(e, ee, x - 1, y, z) && this.find(ee, x - 1, y, z - 1) && this.find(e, ee, x + 1, y, z - 1) && this.find(a, x + 1, y, z) && this.find(a, x, y, z) && this.find(a, x, y, z - 1) && this.find(cc, x + 1, y + 1, z + 1) && this.find(cc, x, y + 1, z + 1) && this.find(cc, x - 1, y + 1, z + 1) && this.find(cc, x - 1, y + 1, z) && this.find(cc, x - 1, y + 1, z - 1) && this.find(cc, x + 1, y + 1, z - 1) && this.find(ee, x + 1, y + 1, z) && this.find(ee, x, y + 1, z) && this.find(ee, x, y + 1, z - 1);
    }

    public int lengthl() {
        int l = 0;
        for (int i = 0; i < NuclearCraft.ringMaxSize; ++i) {
            if (!this.tubef(1 + i, 0, 0) || !this.cornertl(2 + i, 0, 0)) continue;
            l = i + 1;
            break;
        }
        this.length = l;
        return l;
    }

    public int lengthr() {
        int l = 0;
        for (int i = 0; i < NuclearCraft.ringMaxSize; ++i) {
            if (!this.tubef(1 + i, 0, 0) || !this.cornertr(2 + i, 0, 0)) continue;
            l = i + 1;
            break;
        }
        this.length = l;
        return l;
    }

    private boolean checkRing() {
        Block s = NCBlocks.synchrotronIdle;
        Block ss = NCBlocks.synchrotronActive;
        int l = 0;
        if (this.cornerbl(0, 0, 0)) {
            this.orientation = 0;
            l = this.lengthl();
            if (l < 1) {
                this.problem = StatCollector.func_74838_a((String)"gui.ringNotBigEnough");
                this.flag = false;
                this.complete = 0;
                return false;
            }
            if (l > 2) {
                for (int i = 0; i < l - 2; ++i) {
                    if (this.tubef(2 + i, 0, 0) && this.tuber(l + 1, 0, 2 + i) && this.tubef(2 + i, 0, l + 1) && this.tuber(0, 0, 2 + i)) continue;
                    this.problem = StatCollector.func_74838_a((String)"gui.tubeIncomplete");
                    this.flag = false;
                    this.complete = 0;
                    return false;
                }
            }
            if (!(this.cornerbl(0, 0, 0) && this.cornertl(1 + l, 0, 0) && this.cornertr(1 + l, 0, 1 + l) && this.cornerbr(0, 0, 1 + l))) {
                this.problem = StatCollector.func_74838_a((String)"gui.cornerIncomplete");
                this.flag = false;
                this.complete = 0;
                return false;
            }
            if (this.find(s, ss, 0, 0, -2) || this.find(s, ss, l + 1, 0, -2) || this.find(s, ss, l + 3, 0, 0) || this.find(s, ss, l + 3, 0, l + 1) || this.find(s, ss, l + 1, 0, l + 3) || this.find(s, ss, 0, 0, l + 3) || this.find(s, ss, -2, 0, l + 1)) {
                this.problem = StatCollector.func_74838_a((String)"gui.multipleControllers");
                this.flag = false;
                this.complete = 0;
                return false;
            }
        } else if (this.cornerbr(0, 0, 0)) {
            this.orientation = 1;
            l = this.lengthr();
            if (l < 1) {
                this.problem = StatCollector.func_74838_a((String)"gui.ringNotBigEnough");
                this.flag = false;
                this.complete = 0;
                return false;
            }
            if (l > 2) {
                for (int i = 0; i < l - 2; ++i) {
                    if (this.tubef(2 + i, 0, 0) && this.tuber(l + 1, 0, -(2 + i)) && this.tubef(2 + i, 0, -(l + 1)) && this.tuber(0, 0, -(2 + i))) continue;
                    this.problem = StatCollector.func_74838_a((String)"gui.tubeIncomplete");
                    this.flag = false;
                    this.complete = 0;
                    return false;
                }
            }
            if (!(this.cornerbr(0, 0, 0) && this.cornertr(1 + l, 0, 0) && this.cornertl(1 + l, 0, -(1 + l)) && this.cornerbl(0, 0, -(1 + l)))) {
                this.problem = StatCollector.func_74838_a((String)"gui.cornerIncomplete");
                this.flag = false;
                this.complete = 0;
                return false;
            }
            if (this.find(s, ss, 0, 0, 2) || this.find(s, ss, l + 1, 0, 2) || this.find(s, ss, l + 3, 0, 0) || this.find(s, ss, l + 3, 0, -(l + 1)) || this.find(s, ss, l + 1, 0, -(l + 3)) || this.find(s, ss, 0, 0, -(l + 3)) || this.find(s, ss, -2, 0, -(l + 1))) {
                this.problem = StatCollector.func_74838_a((String)"gui.multipleControllers");
                this.flag = false;
                this.complete = 0;
                return false;
            }
        } else {
            this.problem = StatCollector.func_74838_a((String)"gui.ringIncomplete");
            this.flag = false;
            this.complete = 0;
            return false;
        }
        this.flag = true;
        this.complete = 1;
        return true;
    }

    public boolean multiblock(World world, int x, int y, int z) {
        return this.complete == 1;
    }

    public boolean multiblockstring() {
        return this.complete == 1;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean percentageOn() {
        int l = 0;
        int e = 0;
        if (this.complete == 0) {
            this.percentageOn = 0.0;
            return false;
        }
        if (this.cornerbl(0, 0, 0)) {
            int i;
            l = this.lengthl();
            if (!(this.cornerblOnl(0, 0, 0) && this.cornertlOn(1 + l, 0, 0) && this.cornertrOn(1 + l, 0, 1 + l) && this.cornerbrOnl(0, 0, 1 + l))) {
                this.percentageOn = 0.0;
                return false;
            }
            if (l <= 2) {
                this.percentageOn = 100.0;
                return true;
            }
            for (i = 0; i < l - 2; ++i) {
                if (!this.tubefOn(2 + i, 0, 0)) continue;
                ++e;
            }
            for (i = 0; i < l - 2; ++i) {
                if (!this.tuberOn(l + 1, 0, 2 + i)) continue;
                ++e;
            }
            for (i = 0; i < l - 2; ++i) {
                if (!this.tubefOn(2 + i, 0, l + 1)) continue;
                ++e;
            }
            for (i = 0; i < l - 2; ++i) {
                if (!this.tuberOn(0, 0, 2 + i)) continue;
                ++e;
            }
        } else {
            int i;
            if (!this.cornerbr(0, 0, 0)) {
                this.percentageOn = 0.0;
                return false;
            }
            l = this.lengthr();
            if (!(this.cornerbrOnr(0, 0, 0) && this.cornertrOn(1 + l, 0, 0) && this.cornertlOn(1 + l, 0, -(1 + l)) && this.cornerblOnr(0, 0, -(1 + l)))) {
                this.percentageOn = 0.0;
                return false;
            }
            if (l <= 2) {
                this.percentageOn = 100.0;
                return true;
            }
            for (i = 0; i < l - 2; ++i) {
                if (!this.tubefOn(2 + i, 0, 0)) continue;
                ++e;
            }
            for (i = 0; i < l - 2; ++i) {
                if (!this.tuberOn(l + 1, 0, -(2 + i))) continue;
                ++e;
            }
            for (i = 0; i < l - 2; ++i) {
                if (!this.tubefOn(2 + i, 0, -(l + 1))) continue;
                ++e;
            }
            for (i = 0; i < l - 2; ++i) {
                if (!this.tuberOn(0, 0, -(2 + i))) continue;
                ++e;
            }
        }
        this.percentageOn = (400 + 100 * e) / (4 * (l - 1));
        return true;
    }

    @Override
    public String func_145825_b() {
        return this.isInventoryNameLocalized() ? this.localizedName : "Synchrotron";
    }

    @Override
    public boolean isInventoryNameLocalized() {
        return this.localizedName != null && this.localizedName.length() > 0;
    }

    @Override
    public int func_70302_i_() {
        return this.slots.length;
    }

    @Override
    public void setGuiDisplayName(String name) {
        this.localizedName = name;
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    @Override
    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this;
    }

    @Override
    public boolean func_145818_k_() {
        return false;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("storage")) {
            this.storage.readFromNBT(nbt.func_74775_l("storage"));
        }
        this.flag = nbt.func_74767_n("flag");
        this.flag1 = nbt.func_74767_n("flag1");
        this.complete = nbt.func_74762_e("complete");
        this.length = nbt.func_74762_e("length");
        this.orientation = nbt.func_74762_e("orientation");
        this.fuel = nbt.func_74769_h("fuel");
        this.efficiency = nbt.func_74769_h("efficiency");
        this.radiationPower = nbt.func_74769_h("radiationPower");
        this.antimatter = nbt.func_74769_h("antimatter");
        this.particleEnergy = nbt.func_74769_h("particleEnergy");
        this.percentageOn = nbt.func_74769_h("percentageOn");
        this.problem = nbt.func_74779_i("problem");
        NBTTagList list = nbt.func_150295_c("Items", 10);
        this.slots = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound compound = list.func_150305_b(i);
            byte b = compound.func_74771_c("Slot");
            if (b < 0 || b >= this.slots.length) continue;
            this.slots[b] = ItemStack.func_77949_a((NBTTagCompound)compound);
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagCompound energyTag = new NBTTagCompound();
        this.storage.writeToNBT(energyTag);
        nbt.func_74782_a("storage", (NBTBase)energyTag);
        nbt.func_74757_a("flag", this.flag);
        nbt.func_74757_a("flag1", this.flag1);
        nbt.func_74768_a("complete", this.complete);
        nbt.func_74768_a("length", this.length);
        nbt.func_74768_a("orientation", this.orientation);
        nbt.func_74780_a("fuel", this.fuel);
        nbt.func_74780_a("efficiency", this.efficiency);
        nbt.func_74780_a("radiationPower", this.radiationPower);
        nbt.func_74780_a("antimatter", this.antimatter);
        nbt.func_74780_a("particleEnergy", this.particleEnergy);
        nbt.func_74780_a("percentageOn", this.percentageOn);
        nbt.func_74778_a("problem", this.problem);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74774_a("Slot", (byte)i);
            this.slots[i].func_77955_b(compound);
            list.func_74742_a((NBTBase)compound);
        }
        nbt.func_74782_a("Items", (NBTBase)list);
        if (this.isInventoryNameLocalized()) {
            nbt.func_74778_a("CustomName", this.localizedName);
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        nbtTag.func_74768_a("Energy", this.storage.getEnergyStored());
        this.energy = nbtTag.func_74762_e("Energy");
        this.func_145841_b(nbtTag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbtTag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        this.func_145839_a(packet.func_148857_g());
    }

    public static boolean isFuel(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        Item item = stack.func_77973_b();
        return item == new ItemStack(NCItems.fuel, 1, 50).func_77973_b() && item.getDamage(stack) == 50;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    @Override
    public int getEnergyStored(ForgeDirection paramForgeDirection) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection paramForgeDirection) {
        return this.storage.getMaxEnergyStored();
    }

    public int[] func_94128_d(int slot) {
        return slots1;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int par) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int slots) {
        return slot != 0;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot == 0) {
            return TileSynchrotron.isFuel(stack);
        }
        return false;
    }

    static {
        fuelMax = 100000;
        k = 8.987551787368176;
        c = 2.99792458;
        e = 1.60217662;
        m = 9.10938356;
        slots1 = new int[]{0, 1, 2};
    }
}

