/*
 * Decompiled with CFR 0.152.
 */
package nc.itemblock.storage;

import cofh.api.energy.IEnergyContainerItem;
import java.util.List;
import nc.itemblock.ItemBlockNC;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;

public abstract class ItemBlockEnergyStorage
extends ItemBlockNC
implements IEnergyContainerItem {
    public int storedRF;

    public ItemBlockEnergyStorage(Block block, int storage) {
        super(block, "Stores " + (storage >= 10000000 ? storage / 1000000 + " M" : (storage >= 10000 ? storage / 1000 + " k" : storage + " ")) + "RF. Right click on a side without sneaking to", "change the side mode to input, output or disabled.");
        this.storedRF = storage;
    }

    @Override
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean whatIsThis) {
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null && tagCompound.func_74762_e("Energy") > 0) {
            list.add(EnumChatFormatting.LIGHT_PURPLE + "Energy: " + this.getEnergyStored(itemStack) + " / " + this.storedRF + " RF");
        }
        super.func_77624_a(itemStack, player, list, whatIsThis);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getEnergyStored(stack) > 0;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)this.getEnergyStored(stack) / (double)this.storedRF;
    }

    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (container.field_77994_a > 1) {
            return 0;
        }
        int energy = this.getEnergyStored(container);
        int energyReceived = Math.min(this.storedRF - energy, Math.min(maxReceive, (int)Math.ceil(this.storedRF / 20)));
        if (!simulate) {
            ItemBlockEnergyStorage.setStoredEnergyForItem(container, energy += energyReceived);
        }
        return energyReceived;
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (container.field_77994_a > 1) {
            return 0;
        }
        int energy = this.getEnergyStored(container);
        int energyExtracted = Math.min(energy, Math.min(maxExtract, (int)Math.ceil(this.storedRF / 20)));
        if (!simulate) {
            ItemBlockEnergyStorage.setStoredEnergyForItem(container, energy -= energyExtracted);
        }
        return energyExtracted;
    }

    public static void setStoredEnergyForItem(ItemStack item, int storedEnergy) {
        NBTTagCompound tag = item.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        tag.func_74768_a("Energy", storedEnergy);
        item.func_77982_d(tag);
    }

    public static int getStoredEnergyForItem(ItemStack item) {
        NBTTagCompound tag = item.func_77978_p();
        if (tag == null) {
            return 0;
        }
        return tag.func_74762_e("Energy");
    }

    @Override
    public int getEnergyStored(ItemStack container) {
        return ItemBlockEnergyStorage.getStoredEnergyForItem(container);
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        return this.storedRF;
    }
}

