/*
 * Decompiled with CFR 0.152.
 */
package nc.handler;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import nc.item.NCItems;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AnvilUpdateEvent;

public final class AnvilRepairHandler {
    private static final int RENAME_COST = 5;

    public static int getItemDamage(ItemStack stack) {
        assert (stack != null);
        return stack.func_77960_j();
    }

    public static boolean isRepairable(ItemStack stack) {
        Item item = stack.func_77973_b();
        return item != null ? item.isRepairable() : false;
    }

    public static void setItemName(ItemStack stack, String name) {
        if (stack != null) {
            stack.func_151001_c(name);
        }
    }

    private boolean isValidRepairItem(Item tool, ItemStack stack) {
        if (stack != null && tool != null) {
            if (tool == NCItems.bronzeAxe || tool == NCItems.bronzeHoe || tool == NCItems.bronzePickaxe || tool == NCItems.bronzeShovel || tool == NCItems.bronzeSword) {
                return stack.func_77973_b() == new ItemStack(NCItems.material, 1, 6).func_77973_b();
            }
            if (tool == NCItems.toughAlloyAxe || tool == NCItems.toughAlloyHoe || tool == NCItems.toughAlloyPickaxe || tool == NCItems.toughAlloyShovel || tool == NCItems.toughAlloySword) {
                return stack.func_77973_b() == new ItemStack(NCItems.material, 1, 7).func_77973_b();
            }
            if (tool == NCItems.dUAxe || tool == NCItems.dUHoe || tool == NCItems.dUPickaxe || tool == NCItems.dUShovel || tool == NCItems.dUSword) {
                return stack.func_77973_b() == new ItemStack(NCItems.parts, 1, 8).func_77973_b();
            }
            if (tool == NCItems.boronAxe || tool == NCItems.boronHoe || tool == NCItems.boronPickaxe || tool == NCItems.boronShovel || tool == NCItems.boronSword) {
                return stack.func_77973_b() == new ItemStack(NCItems.material, 1, 43).func_77973_b();
            }
            if (tool == NCItems.toughAlloyPaxel || tool == NCItems.toughBow) {
                return stack.func_77973_b() == new ItemStack(NCItems.material, 1, 7).func_77973_b();
            }
            if (tool == NCItems.dUPaxel) {
                return stack.func_77973_b() == new ItemStack(NCItems.parts, 1, 8).func_77973_b();
            }
        }
        return false;
    }

    private boolean canBeRepaired(ItemStack stack) {
        return AnvilRepairHandler.isRepairable(stack) && stack.func_77951_h();
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=false)
    public void onAnvilChange(AnvilUpdateEvent event) {
        ItemStack itemToRepair = event.left;
        ItemStack repairMaterial = event.right;
        if (itemToRepair == null || repairMaterial == null || !this.isValidRepairItem(itemToRepair.func_77973_b(), repairMaterial)) {
            return;
        }
        event.output = itemToRepair.func_77946_l();
        if (!event.name.isEmpty()) {
            event.cost = 5;
            event.materialCost = 1;
            AnvilRepairHandler.setItemName(event.output, event.name);
        }
        if (this.canBeRepaired(itemToRepair)) {
            int repairAmount = 5000;
            if (itemToRepair.func_77973_b() == NCItems.bronzeAxe || itemToRepair.func_77973_b() == NCItems.bronzeHoe || itemToRepair.func_77973_b() == NCItems.bronzePickaxe || itemToRepair.func_77973_b() == NCItems.bronzeShovel || itemToRepair.func_77973_b() == NCItems.bronzeSword) {
                repairAmount = 300;
            }
            if (itemToRepair.func_77973_b() == NCItems.toughAlloyAxe || itemToRepair.func_77973_b() == NCItems.toughAlloyHoe || itemToRepair.func_77973_b() == NCItems.toughAlloyPickaxe || itemToRepair.func_77973_b() == NCItems.toughAlloyShovel || itemToRepair.func_77973_b() == NCItems.toughAlloySword || itemToRepair.func_77973_b() == NCItems.toughBow) {
                repairAmount = 1250;
            }
            if (itemToRepair.func_77973_b() == NCItems.dUAxe || itemToRepair.func_77973_b() == NCItems.dUHoe || itemToRepair.func_77973_b() == NCItems.dUPickaxe || itemToRepair.func_77973_b() == NCItems.dUShovel || itemToRepair.func_77973_b() == NCItems.dUSword) {
                repairAmount = 3200;
            }
            if (itemToRepair.func_77973_b() == NCItems.boronAxe || itemToRepair.func_77973_b() == NCItems.boronHoe || itemToRepair.func_77973_b() == NCItems.boronPickaxe || itemToRepair.func_77973_b() == NCItems.boronShovel || itemToRepair.func_77973_b() == NCItems.boronSword) {
                repairAmount = 1200;
            }
            if (itemToRepair.func_77973_b() == NCItems.toughAlloyPaxel) {
                repairAmount = 1875;
            }
            if (itemToRepair.func_77973_b() == NCItems.dUPaxel) {
                repairAmount = 4000;
            }
            int itemDamage = AnvilRepairHandler.getItemDamage(itemToRepair);
            int howManyUnits = (int)Math.ceil(itemDamage / repairAmount);
            if (itemDamage % repairAmount != 0) {
                ++howManyUnits;
            }
            howManyUnits = Math.min(howManyUnits, repairMaterial.field_77994_a);
            int damageRepaired = Math.min(itemDamage, howManyUnits * repairAmount);
            event.cost += Math.round(2 + 2 * itemDamage / repairAmount);
            event.materialCost += howManyUnits;
            event.output.func_77964_b(AnvilRepairHandler.getItemDamage(event.output) - damageRepaired);
        }
    }

    public static void register() {
        MinecraftForge.EVENT_BUS.register((Object)new AnvilRepairHandler());
    }
}

