/*
 * Decompiled with CFR 0.152.
 */
package nc.crafting.workspace;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.toposort.TopologicalSort;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nc.crafting.workspace.NuclearWorkspaceCraftingManager;
import nc.crafting.workspace.NuclearWorkspaceShapedOreRecipe;
import nc.crafting.workspace.NuclearWorkspaceShapedRecipes;
import nc.crafting.workspace.NuclearWorkspaceShapelessOreRecipe;
import nc.crafting.workspace.NuclearWorkspaceShapelessRecipes;
import net.minecraft.item.crafting.IRecipe;

public class NuclearWorkspaceRecipeSorter
implements Comparator<IRecipe> {
    private static Map<Class, Category> categories = Maps.newHashMap();
    private static Map<String, SortEntry> entries = Maps.newHashMap();
    private static Map<Class, Integer> priorities = Maps.newHashMap();
    public static NuclearWorkspaceRecipeSorter INSTANCE = new NuclearWorkspaceRecipeSorter();
    private static boolean isDirty = true;
    private static SortEntry before = new SortEntry("Before", null, Category.UNKNOWN, "");
    private static SortEntry after = new SortEntry("After", null, Category.UNKNOWN, "");
    private static Set<Class> warned = Sets.newHashSet();

    public NuclearWorkspaceRecipeSorter() {
        NuclearWorkspaceRecipeSorter.register("nc:shaped", NuclearWorkspaceShapedRecipes.class, Category.SHAPED, "before:nc:shapeless");
        NuclearWorkspaceRecipeSorter.register("nc:shapeless", NuclearWorkspaceShapelessRecipes.class, Category.SHAPELESS, "after:nc:shaped");
        NuclearWorkspaceRecipeSorter.register("nc:shapedore", NuclearWorkspaceShapedOreRecipe.class, Category.SHAPED, "after:nc:shaped before:nc:shapeless");
        NuclearWorkspaceRecipeSorter.register("nc:shapelessore", NuclearWorkspaceShapelessOreRecipe.class, Category.SHAPELESS, "after:nc:shapeless");
    }

    @Override
    public int compare(IRecipe r1, IRecipe r2) {
        Category c1 = NuclearWorkspaceRecipeSorter.getCategory(r1);
        Category c2 = NuclearWorkspaceRecipeSorter.getCategory(r2);
        if (c1 == Category.SHAPELESS && c2 == Category.SHAPED) {
            return 1;
        }
        if (c1 == Category.SHAPED && c2 == Category.SHAPELESS) {
            return -1;
        }
        if (r2.func_77570_a() < r1.func_77570_a()) {
            return -1;
        }
        if (r2.func_77570_a() > r1.func_77570_a()) {
            return 1;
        }
        return NuclearWorkspaceRecipeSorter.getPriority(r2) - NuclearWorkspaceRecipeSorter.getPriority(r1);
    }

    public static void sortCraftManager() {
        NuclearWorkspaceRecipeSorter.bake();
        FMLLog.fine((String)"Sorting recipies", (Object[])new Object[0]);
        warned.clear();
        Collections.sort(NuclearWorkspaceCraftingManager.getInstance().getRecipeList(), INSTANCE);
    }

    public static void register(String name, Class<?> recipe, Category category, String dependancies) {
        assert (category != Category.UNKNOWN) : "Category must not be unknown!";
        isDirty = true;
        SortEntry entry = new SortEntry(name, recipe, category, dependancies);
        entries.put(name, entry);
        NuclearWorkspaceRecipeSorter.setCategory(recipe, category);
    }

    public static void setCategory(Class<?> recipe, Category category) {
        assert (category != Category.UNKNOWN) : "Category must not be unknown!";
        categories.put(recipe, category);
    }

    public static Category getCategory(IRecipe recipe) {
        return NuclearWorkspaceRecipeSorter.getCategory(recipe.getClass());
    }

    public static Category getCategory(Class<?> recipe) {
        Class<?> cls = recipe;
        Category ret = categories.get(cls);
        if (ret == null) {
            while (cls != Object.class) {
                ret = categories.get(cls = cls.getSuperclass());
                if (ret == null) continue;
                categories.put(recipe, ret);
                return ret;
            }
        }
        return ret == null ? Category.UNKNOWN : ret;
    }

    private static int getPriority(IRecipe recipe) {
        Class<?> cls = recipe.getClass();
        Integer ret = priorities.get(cls);
        if (ret == null) {
            if (!warned.contains(cls)) {
                FMLLog.info((String)"  Unknown recipe class! %s Modder please refer to %s", (Object[])new Object[]{cls.getName(), NuclearWorkspaceRecipeSorter.class.getName()});
                warned.add(cls);
            }
            cls = cls.getSuperclass();
            while (cls != Object.class) {
                ret = priorities.get(cls);
                if (ret == null) continue;
                priorities.put(recipe.getClass(), ret);
                FMLLog.fine((String)"    Parent Found: %d - %s", (Object[])new Object[]{(int)ret, cls.getName()});
                return ret;
            }
        }
        return ret == null ? 0 : ret;
    }

    private static void bake() {
        if (!isDirty) {
            return;
        }
        FMLLog.fine((String)"Forge RecipeSorter Baking:", (Object[])new Object[0]);
        TopologicalSort.DirectedGraph sorter = new TopologicalSort.DirectedGraph();
        sorter.addNode((Object)before);
        sorter.addNode((Object)after);
        sorter.addEdge((Object)before, (Object)after);
        for (Map.Entry<String, SortEntry> entry : entries.entrySet()) {
            sorter.addNode((Object)entry.getValue());
        }
        for (Map.Entry<String, SortEntry> e : entries.entrySet()) {
            SortEntry entry = e.getValue();
            boolean postAdded = false;
            sorter.addEdge((Object)before, (Object)entry);
            for (String dep : entry.after) {
                if (!entries.containsKey(dep)) continue;
                sorter.addEdge((Object)entries.get(dep), (Object)entry);
            }
            for (String dep : entry.before) {
                postAdded = true;
                sorter.addEdge((Object)entry, (Object)after);
                if (!entries.containsKey(dep)) continue;
                sorter.addEdge((Object)entry, (Object)entries.get(dep));
            }
            if (postAdded) continue;
            sorter.addEdge((Object)entry, (Object)after);
        }
        List sorted = TopologicalSort.topologicalSort((TopologicalSort.DirectedGraph)sorter);
        int x = sorted.size();
        for (SortEntry entry : sorted) {
            FMLLog.fine((String)"  %d: %s", (Object[])new Object[]{x, entry});
            priorities.put(entry.cls, x--);
        }
    }

    private static class SortEntry {
        private String name;
        private Class<?> cls;
        private Category cat;
        List<String> before = Lists.newArrayList();
        List<String> after = Lists.newArrayList();

        private SortEntry(String name, Class<?> cls, Category cat, String deps) {
            this.name = name;
            this.cls = cls;
            this.cat = cat;
            this.parseDepends(deps);
        }

        private void parseDepends(String deps) {
            if (deps.isEmpty()) {
                return;
            }
            for (String dep : deps.split(" ")) {
                if (dep.startsWith("before:")) {
                    this.before.add(dep.substring(7));
                    continue;
                }
                if (dep.startsWith("after:")) {
                    this.after.add(dep.substring(6));
                    continue;
                }
                throw new IllegalArgumentException("Invalid dependancy: " + dep);
            }
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("RecipeEntry(\"").append(this.name).append("\", ");
            buf.append(this.cat.name()).append(", ");
            buf.append(this.cls == null ? "" : this.cls.getName()).append(")");
            if (this.before.size() > 0) {
                buf.append(" Before: ").append(Joiner.on((String)", ").join(this.before));
            }
            if (this.after.size() > 0) {
                buf.append(" After: ").append(Joiner.on((String)", ").join(this.after));
            }
            return buf.toString();
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    public static enum Category {
        UNKNOWN,
        SHAPELESS,
        SHAPED;

    }
}

