/*
 * Decompiled with CFR 0.152.
 */
package nc.crafting.nei;

import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import nc.crafting.nei.NuclearWorkspaceRecipeHandler;
import nc.crafting.workspace.NuclearWorkspaceCraftingManager;
import nc.crafting.workspace.NuclearWorkspaceShapelessOreRecipe;
import nc.crafting.workspace.NuclearWorkspaceShapelessRecipes;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;

public class NuclearWorkspaceShapelessRecipeHandler
extends NuclearWorkspaceRecipeHandler {
    public int[][] stackorder = new int[][]{{0, 0}, {1, 0}, {0, 1}, {1, 1}, {0, 2}, {1, 2}, {2, 0}, {2, 1}, {2, 2}};

    @Override
    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("nwcrafting") && ((Object)((Object)this)).getClass() == NuclearWorkspaceShapelessRecipeHandler.class) {
            List allrecipes = NuclearWorkspaceCraftingManager.getInstance().getRecipeList();
            for (IRecipe irecipe : allrecipes) {
                CachedShapelessRecipe recipe = null;
                if (irecipe instanceof NuclearWorkspaceShapelessRecipes) {
                    recipe = this.shapelessRecipe((NuclearWorkspaceShapelessRecipes)irecipe);
                } else if (irecipe instanceof NuclearWorkspaceShapelessOreRecipe) {
                    recipe = this.forgeShapelessRecipe((NuclearWorkspaceShapelessOreRecipe)irecipe);
                }
                if (recipe == null) continue;
                this.arecipes.add(recipe);
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    @Override
    public void loadCraftingRecipes(ItemStack result) {
        List allrecipes = NuclearWorkspaceCraftingManager.getInstance().getRecipeList();
        for (IRecipe irecipe : allrecipes) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)irecipe.func_77571_b(), (ItemStack)result)) continue;
            CachedShapelessRecipe recipe = null;
            if (irecipe instanceof NuclearWorkspaceShapelessRecipes) {
                recipe = this.shapelessRecipe((NuclearWorkspaceShapelessRecipes)irecipe);
            } else if (irecipe instanceof NuclearWorkspaceShapelessOreRecipe) {
                recipe = this.forgeShapelessRecipe((NuclearWorkspaceShapelessOreRecipe)irecipe);
            }
            if (recipe == null) continue;
            this.arecipes.add(recipe);
        }
    }

    @Override
    public void loadUsageRecipes(ItemStack ingredient) {
        List allrecipes = NuclearWorkspaceCraftingManager.getInstance().getRecipeList();
        for (IRecipe irecipe : allrecipes) {
            CachedShapelessRecipe recipe = null;
            if (irecipe instanceof NuclearWorkspaceShapelessRecipes) {
                recipe = this.shapelessRecipe((NuclearWorkspaceShapelessRecipes)irecipe);
            } else if (irecipe instanceof NuclearWorkspaceShapelessOreRecipe) {
                recipe = this.forgeShapelessRecipe((NuclearWorkspaceShapelessOreRecipe)irecipe);
            }
            if (recipe == null || !recipe.contains(recipe.ingredients, ingredient)) continue;
            recipe.setIngredientPermutation(recipe.ingredients, ingredient);
            this.arecipes.add(recipe);
        }
    }

    private CachedShapelessRecipe shapelessRecipe(NuclearWorkspaceShapelessRecipes recipe) {
        if (recipe.recipeItems == null) {
            return null;
        }
        try {
            return new CachedShapelessRecipe(recipe.recipeItems, recipe.func_77571_b());
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public CachedShapelessRecipe forgeShapelessRecipe(NuclearWorkspaceShapelessOreRecipe recipe) {
        ArrayList<Object> items = recipe.getInput();
        for (Object item : items) {
            if (!(item instanceof List) || !((List)item).isEmpty()) continue;
            return null;
        }
        try {
            return new CachedShapelessRecipe(items, recipe.func_77571_b());
        }
        catch (Exception e) {
            NEIClientConfig.logger.error("Error loading recipe: ", (Throwable)e);
            return null;
        }
    }

    public class CachedShapelessRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public ArrayList<PositionedStack> ingredients;
        public PositionedStack result;

        public CachedShapelessRecipe() {
            super((TemplateRecipeHandler)NuclearWorkspaceShapelessRecipeHandler.this);
            this.ingredients = new ArrayList();
        }

        public CachedShapelessRecipe(ItemStack output) {
            this();
            this.setResult(output);
        }

        public CachedShapelessRecipe(Object[] input, ItemStack output) {
            this(Arrays.asList(input), output);
        }

        public CachedShapelessRecipe(List<?> input, ItemStack output) {
            this(output);
            this.setIngredients(input);
        }

        public void setIngredients(List<?> items) {
            this.ingredients.clear();
            for (int ingred = 0; ingred < items.size(); ++ingred) {
                PositionedStack stack = new PositionedStack(items.get(ingred), 25 + NuclearWorkspaceShapelessRecipeHandler.this.stackorder[ingred][0] * 18, 6 + NuclearWorkspaceShapelessRecipeHandler.this.stackorder[ingred][1] * 18);
                stack.setMaxSize(1);
                this.ingredients.add(stack);
            }
        }

        public void setResult(ItemStack output) {
            this.result = new PositionedStack((Object)output, 119, 24);
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(NuclearWorkspaceShapelessRecipeHandler.this.cycleticks / 20, this.ingredients);
        }

        public PositionedStack getResult() {
            return this.result;
        }
    }
}

