/*
 * Decompiled with CFR 0.152.
 */
package nc.crafting.nei;

import codechicken.nei.ItemList;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nc.NuclearCraft;
import nc.crafting.machine.CrusherRecipesOld;
import nc.gui.machine.GuiCrusher;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;

public class CrusherRecipeHandler
extends TemplateRecipeHandler {
    public static ArrayList<CrusherFuelPair> acrushfuels;
    public static HashSet<Block> ecrushfuels;

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(50, 23, 18, 18), "crushfuel", new Object[0]));
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(74, 23, 24, 18), "crushing", new Object[0]));
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiCrusher.class;
    }

    public String getRecipeName() {
        return "Crusher";
    }

    public TemplateRecipeHandler newInstance() {
        if (ecrushfuels == null) {
            CrusherRecipeHandler.findCrushFuels();
        }
        return super.newInstance();
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("crushing") && ((Object)((Object)this)).getClass() == CrusherRecipeHandler.class) {
            Map<ItemStack, ItemStack> recipes = CrusherRecipesOld.smelting().getSmeltingList();
            for (Map.Entry<ItemStack, ItemStack> recipe : recipes.entrySet()) {
                this.arecipes.add(new CrushingPair(recipe.getKey(), recipe.getValue()));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        Map<ItemStack, ItemStack> recipes = CrusherRecipesOld.smelting().getSmeltingList();
        for (Map.Entry<ItemStack, ItemStack> recipe : recipes.entrySet()) {
            if (!NEIServerUtils.areStacksSameType((ItemStack)recipe.getValue(), (ItemStack)result)) continue;
            this.arecipes.add(new CrushingPair(recipe.getKey(), recipe.getValue()));
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("crushfuel") && ((Object)((Object)this)).getClass() == CrusherRecipeHandler.class) {
            this.loadCraftingRecipes("crushing", new Object[0]);
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        Map<ItemStack, ItemStack> recipes = CrusherRecipesOld.smelting().getSmeltingList();
        for (Map.Entry<ItemStack, ItemStack> recipe : recipes.entrySet()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)recipe.getKey(), (ItemStack)ingredient)) continue;
            CrushingPair arecipe = new CrushingPair(recipe.getKey(), recipe.getValue());
            arecipe.setIngredientPermutation(Arrays.asList(arecipe.ingred), ingredient);
            this.arecipes.add(arecipe);
        }
    }

    public String getGuiTexture() {
        return "nc:textures/gui/crusher.png";
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(51, 25, 176, 0, 14, 14, 24, 7);
        this.drawProgressBar(74, 23, 176, 14, 24, 16, 48, 0);
    }

    private static Set<Item> excludedFuels() {
        HashSet<Item> ecrushfuels = new HashSet<Item>();
        ecrushfuels.add(Item.func_150898_a((Block)Blocks.field_150338_P));
        ecrushfuels.add(Item.func_150898_a((Block)Blocks.field_150337_Q));
        ecrushfuels.add(Item.func_150898_a((Block)Blocks.field_150472_an));
        ecrushfuels.add(Item.func_150898_a((Block)Blocks.field_150444_as));
        ecrushfuels.add(Item.func_150898_a((Block)Blocks.field_150466_ao));
        ecrushfuels.add(Item.func_150898_a((Block)Blocks.field_150447_bR));
        return ecrushfuels;
    }

    private static void findCrushFuels() {
        acrushfuels = new ArrayList();
        Set<Item> ecrushfuels = CrusherRecipeHandler.excludedFuels();
        for (ItemStack item : ItemList.items) {
            int burnTime;
            if (ecrushfuels.contains(item.func_77973_b()) || (burnTime = CrusherRecipeHandler.getItemBurnTime(item)) <= 0) continue;
            acrushfuels.add(new CrusherFuelPair(item.func_77946_l(), burnTime));
        }
    }

    public static int getItemBurnTime(ItemStack itemstack) {
        if (itemstack == null) {
            return 0;
        }
        Item item = itemstack.func_77973_b();
        if (item instanceof ItemBlock && Block.func_149634_a((Item)item) != Blocks.field_150350_a) {
            Block block = Block.func_149634_a((Item)item);
            if (block == Blocks.field_150376_bx) {
                return 8000 / NuclearCraft.crusherCrushEfficiency;
            }
            if (block.func_149688_o() == Material.field_151575_d) {
                return 16000 / NuclearCraft.crusherCrushEfficiency;
            }
            if (block == Blocks.field_150402_ci) {
                return 960000 / NuclearCraft.crusherCrushEfficiency;
            }
        }
        if (item instanceof ItemTool && ((ItemTool)item).func_77861_e().equals("WOOD")) {
            return 8000 / NuclearCraft.crusherCrushEfficiency;
        }
        if (item instanceof ItemSword && ((ItemSword)item).func_150932_j().equals("WOOD")) {
            return 8000 / NuclearCraft.crusherCrushEfficiency;
        }
        if (item instanceof ItemHoe && ((ItemHoe)item).func_77842_f().equals("WOOD")) {
            return 8000 / NuclearCraft.crusherCrushEfficiency;
        }
        if (item == Items.field_151055_y) {
            return 4000 / NuclearCraft.crusherCrushEfficiency;
        }
        if (item == Items.field_151044_h) {
            return 96000 / NuclearCraft.crusherCrushEfficiency;
        }
        if (item == Items.field_151129_at) {
            return 1200000 / NuclearCraft.crusherCrushEfficiency;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150345_g)) {
            return 4000 / NuclearCraft.crusherCrushEfficiency;
        }
        if (item == Items.field_151072_bj) {
            return 144000 / NuclearCraft.crusherCrushEfficiency;
        }
        return GameRegistry.getFuelValue((ItemStack)itemstack) * 48 / NuclearCraft.crusherCrushEfficiency;
    }

    public static class CrusherFuelPair {
        public PositionedStack stack;
        public int burnTime;

        public CrusherFuelPair(ItemStack ingred, int burnTime) {
            this.stack = new PositionedStack((Object)ingred, 51, 42, false);
            this.burnTime = burnTime;
        }
    }

    public class CrushingPair
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack ingred;
        PositionedStack result;

        public CrushingPair(ItemStack ingred, ItemStack result) {
            super((TemplateRecipeHandler)CrusherRecipeHandler.this);
            ingred.field_77994_a = 1;
            this.ingred = new PositionedStack((Object)ingred, 51, 6);
            this.result = new PositionedStack((Object)result, 111, 24);
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(CrusherRecipeHandler.this.cycleticks / 24, Arrays.asList(this.ingred));
        }

        public PositionedStack getResult() {
            return this.result;
        }

        public PositionedStack getOtherStack() {
            return CrusherRecipeHandler.acrushfuels.get((int)(CrusherRecipeHandler.this.cycleticks / 24 % CrusherRecipeHandler.acrushfuels.size())).stack;
        }
    }
}

