/*
 * Decompiled with CFR 0.152.
 */
package nc.crafting;

import cpw.mods.fml.common.FMLLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public abstract class NCRecipeHelper {
    public int outputSize;
    public int inputSize;
    private Map<Object[], Object[]> recipeList = new HashMap<Object[], Object[]>();

    public abstract void addRecipes();

    public NCRecipeHelper(int inputSize, int outputSize) {
        this.inputSize = inputSize;
        this.outputSize = outputSize;
        this.addRecipes();
    }

    public Map<Object[], Object[]> getRecipes() {
        return this.recipeList;
    }

    public void addRecipe(Object ... objects) {
        Object[] stack = new Object[objects.length];
        if (objects.length > this.inputSize + this.outputSize) {
            FMLLog.warning((String)"RecipeHelper - A recipe was removed because it was too long!", (Object[])new Object[0]);
            return;
        }
        for (int i = 0; i < objects.length; ++i) {
            if (objects[i] == null) {
                return;
            }
            if (objects[i] instanceof String) {
                if (i < this.inputSize) {
                    if (OreDictionary.getOres((String)((String)objects[i])).size() > 0) {
                        stack[i] = new OreStack((String)objects[i], 1);
                        continue;
                    }
                    return;
                }
                if (i - this.inputSize > this.outputSize) continue;
                ArrayList ores = OreDictionary.getOres((String)((String)objects[i]));
                if (ores.size() > 0) {
                    stack[i] = ores.get(0);
                    continue;
                }
                return;
            }
            if (objects[i] instanceof OreStack) {
                if (i < this.inputSize) {
                    if (OreDictionary.getOres((String)((OreStack)objects[i]).oreString).size() > 0) {
                        stack[i] = objects[i];
                        continue;
                    }
                    return;
                }
                if (i - this.inputSize > this.outputSize) continue;
                ArrayList ores = OreDictionary.getOres((String)((OreStack)objects[i]).oreString);
                if (ores.size() > 0) {
                    stack[i] = new ItemStack(((ItemStack)ores.get(0)).func_77973_b(), ((OreStack)objects[i]).stackSize, ((ItemStack)ores.get(0)).func_77960_j());
                    continue;
                }
                return;
            }
            if (objects[i] instanceof ItemStack[]) {
                int s = 0;
                while (s < ((ItemStack[])objects[i]).length) {
                    if (((ItemStack[])objects[i])[s] == null) {
                        return;
                    }
                    ++i;
                }
                stack[i] = objects[i];
                continue;
            }
            stack[i] = this.fixedStack(objects[i]);
        }
        this.addFinal(stack);
    }

    private void addFinal(Object[] stacks) {
        Object[] input = new Object[this.inputSize];
        Object[] output = new Object[this.outputSize];
        for (int i = 0; i < stacks.length; ++i) {
            if (i < this.inputSize) {
                input[i] = stacks[i];
                continue;
            }
            if (i - this.inputSize <= this.outputSize) {
                output[i - this.inputSize] = stacks[i];
                continue;
            }
            throw new RuntimeException("Recipe is too big!");
        }
        this.addRecipe(input, output);
    }

    private ItemStack fixedStack(Object obj) {
        if (obj instanceof ItemStack) {
            return ((ItemStack)obj).func_77946_l();
        }
        if (obj instanceof Item) {
            return new ItemStack((Item)obj, 1);
        }
        if (!(obj instanceof Block)) {
            throw new RuntimeException("Invalid Recipe!");
        }
        return new ItemStack((Block)obj, 1);
    }

    private void addRecipe(Object[] input, Object[] output) {
        this.recipeList.put(this.convertToArrays(input), output);
    }

    public ItemStack getOutput(int output, ItemStack ... input) {
        return this.getOutput(input)[output];
    }

    public ItemStack[] getOutput(ItemStack ... input) {
        Map.Entry<Object[], Object[]> entry;
        if (input.length != this.inputSize) {
            return new ItemStack[this.outputSize];
        }
        for (int i = 0; i < input.length; ++i) {
            if (input[i] != null) continue;
            return new ItemStack[this.outputSize];
        }
        Iterator<Map.Entry<Object[], Object[]>> iterator = this.recipeList.entrySet().iterator();
        do {
            if (iterator.hasNext()) continue;
            return new ItemStack[this.outputSize];
        } while (!this.checkInput(input, (entry = iterator.next()).getKey()));
        return this.convertOutput(entry.getValue());
    }

    public int getInputSize(int input, ItemStack ... output) {
        Object[] inputs = this.getInput(output);
        if (inputs == null) {
            return 1;
        }
        return this.getInputSize(inputs)[input];
    }

    public Object[] getInput(ItemStack ... output) {
        Map.Entry<Object[], Object[]> entry;
        if (output.length != this.outputSize) {
            return new Object[this.inputSize];
        }
        for (int i = 0; i < output.length; ++i) {
            if (output[i] != null) continue;
            return new Object[this.inputSize];
        }
        Iterator<Map.Entry<Object[], Object[]>> iterator = this.recipeList.entrySet().iterator();
        do {
            if (iterator.hasNext()) continue;
            return new Object[this.inputSize];
        } while (!this.checkOutput(output, (entry = iterator.next()).getValue()));
        return entry.getKey();
    }

    public boolean validInput(ItemStack input) {
        Map.Entry<Object[], Object[]> entry;
        if (input == null) {
            return false;
        }
        Iterator<Map.Entry<Object[], Object[]>> iterator = this.recipeList.entrySet().iterator();
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while (this.containsStack(input, (entry = iterator.next()).getKey(), false) == -1);
        return true;
    }

    public boolean validOutput(ItemStack output) {
        Map.Entry<Object[], Object[]> entry;
        if (output == null) {
            return false;
        }
        Iterator<Map.Entry<Object[], Object[]>> iterator = this.recipeList.entrySet().iterator();
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while (this.containsStack(output, (entry = iterator.next()).getKey(), false) == -1);
        return true;
    }

    private ItemStack[] convertOutput(Object[] output) {
        ItemStack[] stack = new ItemStack[output.length];
        for (int i = 0; i < output.length; ++i) {
            if (output[i] instanceof ItemStack) {
                stack[i] = (ItemStack)output[i];
                continue;
            }
            if (!(output[i] instanceof OreStack)) continue;
            ArrayList ore = OreDictionary.getOres((String)((OreStack)output[i]).oreString);
            stack[i] = new ItemStack(((ItemStack)ore.get(0)).func_77973_b(), ((OreStack)output[i]).stackSize, ((ItemStack)ore.get(0)).func_77960_j());
        }
        return stack;
    }

    private int[] getInputSize(Object[] input) {
        int[] sizes = new int[input.length];
        for (int i = 0; i < input.length; ++i) {
            if (input[i] instanceof ItemStack) {
                sizes[i] = ((ItemStack)input[i]).field_77994_a;
                continue;
            }
            if (!(input[i] instanceof ItemStack[])) continue;
            sizes[i] = ((ItemStack[])input[i])[0].field_77994_a;
        }
        return sizes;
    }

    private boolean checkInput(ItemStack[] input, Object[] key) {
        if (input.length != key.length && input.length == this.inputSize) {
            return false;
        }
        for (int i = 0; i < key.length; ++i) {
            if (!(key[i] instanceof ItemStack ? !this.equalStack(input[i], (ItemStack)key[i], true) : key[i] instanceof ItemStack[] && this.containsStack(input[i], (ItemStack[])key[i], true) == -1)) continue;
            return false;
        }
        return true;
    }

    private boolean checkOutput(ItemStack[] output, Object[] key) {
        if (output.length != key.length && output.length == this.inputSize) {
            return false;
        }
        for (int i = 0; i < output.length; ++i) {
            if (!(key[i] instanceof ItemStack ? !this.equalStack(output[i], (ItemStack)key[i], true) : key[i] instanceof ItemStack[] && this.containsStack(output[i], (ItemStack[])key[i], true) == -1)) continue;
            return false;
        }
        return true;
    }

    public int containsStack(ItemStack stack, Object[] key, boolean checkSize) {
        for (int i = 0; i < key.length; ++i) {
            if (key[i] == null) continue;
            if (key[i] instanceof ItemStack) {
                if (!this.equalStack(stack, (ItemStack)key[i], checkSize)) continue;
                return i;
            }
            if (!(key[i] instanceof ItemStack[])) continue;
            for (int s = 0; s < ((ItemStack[])key[i]).length; ++s) {
                if (((ItemStack[])key[i])[s] == null || !(((ItemStack[])key[i])[s] instanceof ItemStack) || !this.equalStack(stack, ((ItemStack[])key[i])[s], checkSize)) continue;
                return i;
            }
        }
        return -1;
    }

    private boolean equalStack(ItemStack stack, ItemStack key, boolean checkSize) {
        return stack.func_77973_b() == key.func_77973_b() && stack.func_77960_j() == key.func_77960_j() && (!checkSize || key.field_77994_a <= stack.field_77994_a);
    }

    private int findStackSize(ItemStack stack, Object[] key, int pos) {
        if (key[pos] != null) {
            if (key[pos] instanceof ItemStack) {
                if (this.equalStack(stack, (ItemStack)key[pos], false)) {
                    return ((ItemStack)key[pos]).field_77994_a;
                }
            } else if (key[pos] instanceof ItemStack[]) {
                return this.findStackSize(stack, (ItemStack[])key[pos], pos);
            }
        }
        return -1;
    }

    private Object[] convertToArrays(Object[] object) {
        Object[] stack = new Object[object.length];
        for (int i = 0; i < object.length; ++i) {
            if (object[i] instanceof ItemStack) {
                stack[i] = (ItemStack)object[i];
                continue;
            }
            if (object[i] instanceof ItemStack[]) {
                stack[i] = (ItemStack[])object[i];
                continue;
            }
            if (!(object[i] instanceof OreStack)) continue;
            ArrayList ore = OreDictionary.getOres((String)((OreStack)object[i]).oreString);
            ItemStack[] ores = new ItemStack[ore.size()];
            for (int o = 0; o < ore.size(); ++o) {
                ores[o] = new ItemStack(((ItemStack)ore.get(o)).func_77973_b(), ((OreStack)object[i]).stackSize, ((ItemStack)ore.get(o)).func_77960_j());
            }
            stack[i] = ores;
        }
        return stack;
    }

    public OreStack oreStack(String oreString, int stackSize) {
        return new OreStack(oreString, stackSize);
    }

    private static class OreStack {
        public String oreString;
        public int stackSize;

        public OreStack(String oreString, int stackSize) {
            this.oreString = oreString;
            this.stackSize = stackSize;
        }
    }
}

