/*
 * Decompiled with CFR 0.152.
 */
package nc.block.machine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import nc.block.NCBlocks;
import nc.block.machine.BlockMachine;
import nc.tile.machine.TileCollector;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class BlockCollector
extends BlockMachine {
    public BlockCollector(boolean active) {
        super(active, 10, "", "", "collector");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.field_149761_L = iconRegister.func_94245_a("nc:machine/collector/texture");
        this.iconBottom = iconRegister.func_94245_a("nc:machine/collector/bottom");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        return side == 0 ? this.iconBottom : this.field_149761_L;
    }

    @Override
    public TileEntity func_149915_a(World world, int par1) {
        return new TileCollector();
    }

    public static void updateBlockState(boolean active, World worldObj, int xCoord, int yCoord, int zCoord) {
        int i = worldObj.func_72805_g(xCoord, yCoord, zCoord);
        TileEntity tileentity = worldObj.func_147438_o(xCoord, yCoord, zCoord);
        keepInventory = true;
        if (active) {
            worldObj.func_147449_b(xCoord, yCoord, zCoord, NCBlocks.collectorActive);
        } else {
            worldObj.func_147449_b(xCoord, yCoord, zCoord, NCBlocks.collectorIdle);
        }
        keepInventory = false;
        worldObj.func_72921_c(xCoord, yCoord, zCoord, i, 2);
        if (tileentity != null) {
            tileentity.func_145829_t();
            worldObj.func_147455_a(xCoord, yCoord, zCoord, tileentity);
        }
    }

    @Override
    public Item func_149650_a(int par1, Random random, int par3) {
        return Item.func_150898_a((Block)NCBlocks.collectorIdle);
    }

    @Override
    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        return new ItemStack(NCBlocks.collectorIdle);
    }

    @Override
    public void func_149749_a(World world, int x, int y, int z, Block oldBlockID, int oldMetadata) {
        TileCollector tileentity;
        if (!keepInventory && (tileentity = (TileCollector)world.func_147438_o(x, y, z)) != null) {
            for (int i = 0; i < tileentity.func_70302_i_(); ++i) {
                ItemStack itemstack = tileentity.func_70301_a(i);
                if (itemstack == null) continue;
                float f = this.rand.nextFloat() * 0.8f + 0.1f;
                float f1 = this.rand.nextFloat() * 0.8f + 0.1f;
                float f2 = this.rand.nextFloat() * 0.8f + 0.1f;
                while (itemstack.field_77994_a > 0) {
                    int j = this.rand.nextInt(21) + 10;
                    if (j > itemstack.field_77994_a) {
                        j = itemstack.field_77994_a;
                    }
                    itemstack.field_77994_a -= j;
                    EntityItem item = new EntityItem(world, (double)((float)x + f), (double)((float)y + f1), (double)((float)z + f2), new ItemStack(itemstack.func_77973_b(), j, itemstack.func_77960_j()));
                    if (itemstack.func_77942_o()) {
                        item.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                    }
                    float f3 = 0.05f;
                    item.field_70159_w = (float)this.rand.nextGaussian() * f3;
                    item.field_70181_x = (float)this.rand.nextGaussian() * f3 + 0.2f;
                    item.field_70179_y = (float)this.rand.nextGaussian() * f3;
                    world.func_72838_d((Entity)item);
                }
            }
            world.func_147453_f(x, y, z, oldBlockID);
        }
        super.func_149749_a(world, x, y, z, oldBlockID, oldMetadata);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random random) {
        if (this.isActive) {
            float x1 = (float)x + 0.5f;
            float y1 = (float)y + 0.5f + random.nextFloat() * 0.8f - 0.4f;
            float y2 = (float)y + 1.0f + random.nextFloat() / 16.0f;
            float z1 = (float)z + 0.5f;
            float f = 0.52f;
            float f0 = 0.59f;
            float f1 = random.nextFloat() * 0.6f - 0.3f;
            float f2 = random.nextFloat() * 0.6f - 0.3f;
            world.func_72869_a("depthsuspend", (double)(x1 + f1), (double)y2, (double)(z1 + f2), 0.0, 0.0, 0.0);
            world.func_72869_a("depthsuspend", (double)(x1 - f), (double)y1, (double)(z1 + f1), 0.0, 0.0, 0.0);
            world.func_72869_a("depthsuspend", (double)(x1 + f0), (double)y1, (double)(z1 + f1), 0.0, 0.0, 0.0);
            world.func_72869_a("depthsuspend", (double)(x1 + f1), (double)y1, (double)(z1 - f), 0.0, 0.0, 0.0);
            world.func_72869_a("depthsuspend", (double)(x1 + f1), (double)y1, (double)(z1 + f0), 0.0, 0.0, 0.0);
        }
    }
}

