/*
 * Decompiled with CFR 0.152.
 */
package tehnut.harvest;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import tehnut.harvest.BlockStack;
import tehnut.harvest.Crop;
import tehnut.harvest.Harvest;

public class JsonConfigHandler {
    public static Gson gson = new GsonBuilder().setPrettyPrinting().serializeNulls().disableHtmlEscaping().registerTypeAdapter(BlockStack.class, (Object)new SerializerBlockStack()).create();
    public static List<Crop> tempList = new ArrayList<Crop>();

    public static void init(File jsonConfig) {
        try {
            if (!jsonConfig.exists() && jsonConfig.createNewFile()) {
                List<Crop> defaultList = JsonConfigHandler.handleDefaults();
                String json = gson.toJson(defaultList, new TypeToken<ArrayList<Crop>>(){}.getType());
                FileWriter writer = new FileWriter(jsonConfig);
                writer.write(json);
                writer.close();
            }
            tempList = (List)gson.fromJson((Reader)new FileReader(jsonConfig), new TypeToken<ArrayList<Crop>>(){}.getType());
            for (Crop crop : tempList) {
                Harvest.instance.cropMap.put(crop.getInitialBlock(), crop);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static List<Crop> handleDefaults() {
        ArrayList<Crop> defaultList = new ArrayList<Crop>();
        Crop wheat = new Crop(new BlockStack(Blocks.field_150464_aj, 7), new BlockStack(Blocks.field_150464_aj, 0));
        defaultList.add(wheat);
        Crop carrot = new Crop(new BlockStack(Blocks.field_150459_bM, 7), new BlockStack(Blocks.field_150459_bM, 0));
        defaultList.add(carrot);
        Crop potato = new Crop(new BlockStack(Blocks.field_150469_bN, 7), new BlockStack(Blocks.field_150469_bN, 0));
        defaultList.add(potato);
        Crop netherwart = new Crop(new BlockStack(Blocks.field_150388_bm, 3), new BlockStack(Blocks.field_150388_bm, 0));
        defaultList.add(netherwart);
        return defaultList;
    }

    public static class SerializerBlockStack
    implements JsonDeserializer<BlockStack>,
    JsonSerializer<BlockStack> {
        public BlockStack deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String name = json.getAsJsonObject().get("blockName").getAsString();
            int meta = 0;
            if (json.getAsJsonObject().get("meta") != null) {
                meta = json.getAsJsonObject().get("meta").getAsInt();
            }
            return new BlockStack((Block)Block.field_149771_c.func_82594_a(name), meta);
        }

        public JsonElement serialize(BlockStack src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("blockName", Block.field_149771_c.func_148750_c((Object)src.getBlock()));
            jsonObject.addProperty("meta", (Number)src.getMeta());
            return jsonObject;
        }
    }
}

