/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.utility;

import com.InfinityRaider.AgriCraft.utility.WorldCoordinates;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockPosition {
    private World world;
    private WorldCoordinates coords;

    public BlockPosition(World world, int x, int y, int z) {
        this.world = world;
        this.coords = new WorldCoordinates(x, y, z);
    }

    public World world() {
        return this.world;
    }

    public int x() {
        return this.coords.x();
    }

    public int y() {
        return this.coords.y();
    }

    public int z() {
        return this.coords.z();
    }

    public Block getBlock() {
        return this.coords.getBlock(this.world);
    }

    public int getMetaData() {
        return this.coords.getMetaData(this.world);
    }

    public TileEntity getTileEntity() {
        return this.coords.getTileEntity(this.world);
    }

    public void setBlock(Block block, int meta, int flag) {
        this.coords.setBlock(this.world, block, meta, flag);
    }

    public int dimensionId() {
        return this.world.field_73011_w.field_76574_g;
    }

    public BlockPosition getNeighbour(ForgeDirection dir) {
        if (dir == ForgeDirection.UNKNOWN) {
            return this;
        }
        return new BlockPosition(this.world, this.x() + dir.offsetX, this.y() + dir.offsetY, this.z() + dir.offsetZ);
    }

    public boolean equals(Object obj) {
        if (obj instanceof BlockPosition) {
            BlockPosition pos = (BlockPosition)obj;
            return pos.world == this.world && pos.coords.equals(this.coords);
        }
        return false;
    }
}

