/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.tileentity.decoration;

import com.InfinityRaider.AgriCraft.api.v1.IDebuggable;
import com.InfinityRaider.AgriCraft.tileentity.TileEntityCustomWood;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;

public class TileEntityGrate
extends TileEntityCustomWood
implements IDebuggable {
    private static final double WIDTH = 0.125;
    private static final double LENGTH = 1.0;
    private static final double[] OFFSETS = new double[]{0.0, 0.4375, 0.875};
    private int orientation;
    private int offset;
    private int vines;
    private double[] bounds;

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74777_a("ac_Flag", (short)this.orientation);
        tag.func_74777_a("meta", (short)this.offset);
        tag.func_74777_a("weed", (short)this.vines);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.orientation = tag.func_74765_d("ac_Flag");
        this.offset = tag.func_74765_d("meta");
        this.calculateBounds();
        this.vines = tag.func_74765_d("weed");
    }

    public void calculateBounds() {
        this.bounds = this.orientation == 0 ? new double[]{0.0, 0.0, OFFSETS[this.offset], 1.0, 1.0, OFFSETS[this.offset] + 0.125} : (this.orientation == 1 ? new double[]{OFFSETS[this.offset], 0.0, 0.0, OFFSETS[this.offset] + 0.125, 1.0, 1.0} : new double[]{0.0, OFFSETS[this.offset], 0.0, 1.0, OFFSETS[this.offset] + 0.125, 1.0});
    }

    public void setOrientationValue(short value) {
        value = (short)(value > 2 ? 2 : (int)value);
        short s = value = value < 0 ? (short)0 : value;
        if (this.orientation == value) {
            return;
        }
        this.orientation = value;
        this.markForUpdate();
    }

    public int getOrientationValue() {
        return this.orientation;
    }

    public void setOffSet(short value) {
        value = (short)(value > 2 ? 2 : (int)value);
        short s = value = value < 0 ? (short)0 : value;
        if (this.offset == value) {
            return;
        }
        this.offset = value;
        this.markForUpdate();
    }

    public int getOffset() {
        return this.offset;
    }

    public boolean isPlayerInFront(EntityPlayer player) {
        if (this.orientation == 0) {
            return player.field_70161_v < (double)this.field_145849_e + OFFSETS[this.offset] + 0.0625;
        }
        if (this.orientation == 1) {
            return player.field_70165_t < (double)this.field_145851_c + OFFSETS[this.offset] + 0.0625;
        }
        return player.field_70163_u < (double)this.field_145848_d + OFFSETS[this.offset] + 0.0625;
    }

    public boolean hasVines(boolean front) {
        return this.vines == 3 || (front ? this.vines == 1 : this.vines == 2);
    }

    public boolean addVines(boolean front) {
        if (this.hasVines(front)) {
            return false;
        }
        this.vines += front ? 1 : 2;
        this.markForUpdate();
        return true;
    }

    public boolean removeVines(boolean front) {
        if (this.hasVines(front)) {
            this.vines = Math.max(this.vines - (front ? 1 : 2), 0);
            this.markForUpdate();
            return true;
        }
        return false;
    }

    public AxisAlignedBB getBoundingBox() {
        if (this.orientation == 0) {
            return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)((double)this.field_145849_e + OFFSETS[this.offset]), (double)((double)this.field_145851_c + 1.0), (double)((double)this.field_145848_d + 1.0), (double)((double)this.field_145849_e + OFFSETS[this.offset] + 0.125));
        }
        if (this.orientation == 1) {
            return AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c + OFFSETS[this.offset]), (double)this.field_145848_d, (double)this.field_145849_e, (double)((double)this.field_145851_c + OFFSETS[this.offset] + 0.125), (double)((double)this.field_145848_d + 1.0), (double)((double)this.field_145849_e + 1.0));
        }
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)((double)this.field_145848_d + OFFSETS[this.offset]), (double)this.field_145849_e, (double)((double)this.field_145851_c + 1.0), (double)((double)this.field_145848_d + OFFSETS[this.offset] + 0.125), (double)((double)this.field_145849_e + 1.0));
    }

    public double[] getBlockBounds() {
        return this.bounds;
    }

    public boolean canUpdate() {
        return false;
    }

    @Override
    public void addDebugInfo(List<String> list) {
        list.add("GRATE:");
        super.addDebugInfo(list);
        list.add("Offset: " + this.offset);
        list.add("Orientation: " + this.orientation + " (" + (this.orientation == 0 ? "xy" : (this.orientation == 1 ? "zy" : "xz")) + ")");
        list.add("Bounds: ");
        list.add(" - x: " + this.bounds[0] + " - " + this.bounds[3]);
        list.add(" - y: " + this.bounds[1] + " - " + this.bounds[4]);
        list.add(" - z: " + this.bounds[2] + " - " + this.bounds[5]);
    }
}

