/*
 * Decompiled with CFR 0.152.
 */
package cubex2.mods.chesttransporter;

import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cubex2.mods.chesttransporter.TransportableChest;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;

public class VariertyChest
extends TransportableChest {
    private final boolean isGlow;
    private final IIcon[] icons;

    public VariertyChest(Block chestBlock, int chestMeta, int transporterDV, boolean isGlow) {
        super(chestBlock, chestMeta, transporterDV, null);
        this.isGlow = isGlow;
        this.icons = new IIcon[isGlow ? 6 : 5];
    }

    @Override
    public ItemStack createChestStack() {
        return new ItemStack(Item.func_150898_a((Block)this.getChestBlock()), 1, 0);
    }

    @Override
    public void preRemoveChest(ItemStack transporter, TileEntity chestTE) {
        try {
            Class<?> clazz = Class.forName("de.sanandrew.mods.varietychests.tileentity.TileEntityCustomChest");
            String chestType = (String)ObfuscationReflectionHelper.getPrivateValue(clazz, (Object)chestTE, (String[])new String[]{"chestType"});
            transporter.func_77978_p().func_74778_a("VCChestType", chestType);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void preDestroyTransporter(ItemStack transporter, TileEntity chestTE) {
        try {
            Class<?> clazz = Class.forName("de.sanandrew.mods.varietychests.tileentity.TileEntityCustomChest");
            String chestType = transporter.func_77978_p().func_74779_i("VCChestType");
            ObfuscationReflectionHelper.setPrivateValue(clazz, (Object)chestTE, (Object)chestType, (String[])new String[]{"chestType"});
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public IIcon getIcon(ItemStack stack) {
        String chestType = stack.func_77978_p().func_74779_i("VCChestType");
        if (chestType.equals("spruce")) {
            return this.icons[0];
        }
        if (chestType.equals("birch")) {
            return this.icons[1];
        }
        if (chestType.equals("jungle")) {
            return this.icons[2];
        }
        if (chestType.equals("acacia")) {
            return this.icons[3];
        }
        if (chestType.equals("darkoak")) {
            return this.icons[4];
        }
        if (chestType.equals("original")) {
            return this.icons[5];
        }
        return this.icons[0];
    }

    @Override
    public void registerIcon(IIconRegister iconRegister) {
        String[] chestTypes = new String[]{"spruce", "birch", "jungle", "acacia", "darkoak", "original"};
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = iconRegister.func_94245_a("chesttransporter:vc_" + chestTypes[i] + (this.isGlow ? "_glow" : ""));
        }
    }
}

