/*
 * Decompiled with CFR 0.152.
 */
package cubex2.mods.chesttransporter;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameRegistry;
import cubex2.mods.chesttransporter.ChestRegistry;
import cubex2.mods.chesttransporter.FzBarrel;
import cubex2.mods.chesttransporter.ItemChestTransporter;
import cubex2.mods.chesttransporter.Spawner;
import cubex2.mods.chesttransporter.TransportableChest;
import cubex2.mods.chesttransporter.VariertyChest;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityMinecartChest;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.oredict.ShapedOreRecipe;

@Mod(modid="ChestTransporter", name="Chest Transporter", version="2.0.6")
public class ChestTransporter {
    @Mod.Instance(value="ChestTransporter")
    public static ChestTransporter instance;
    public static ItemChestTransporter chestTransporter;
    public static ItemChestTransporter chestTransporterIron;
    public static ItemChestTransporter chestTransporterGold;
    public static ItemChestTransporter chestTransporterDiamond;
    private static boolean pickupSpawners;
    public static boolean spawnerWithWood;
    public static boolean spawnerWithIron;
    public static boolean spawnerWithGold;
    public static boolean spawnerWithDiamond;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        try {
            config.load();
            pickupSpawners = config.getBoolean("pickupSpawners", "general", true, "Set this to false to prevent picking up of mob spawners");
            spawnerWithWood = config.getBoolean("spawnerWithWood", "general", true, "Set this to false to prevent the wooden transporter to pick up mob spawners");
            spawnerWithIron = config.getBoolean("spawnerWithIron", "general", true, "Set this to false to prevent the iron transporter to pick up mob spawners");
            spawnerWithGold = config.getBoolean("spawnerWithGold", "general", true, "Set this to false to prevent the golden transporter to pick up mob spawners");
            spawnerWithDiamond = config.getBoolean("spawnerWithDiamond", "general", true, "Set this to false to prevent the diamond transporter to pick up mob spawners");
        }
        finally {
            config.save();
        }
        chestTransporter = new ItemChestTransporter(1, "wood");
        chestTransporterIron = new ItemChestTransporter(9, "iron");
        chestTransporterGold = new ItemChestTransporter(19, "gold");
        chestTransporterDiamond = new ItemChestTransporter(79, "diamond");
        GameRegistry.registerItem((Item)chestTransporter, (String)"chesttransporter");
        GameRegistry.registerItem((Item)chestTransporterIron, (String)"chesttransporter_iron");
        GameRegistry.registerItem((Item)chestTransporterGold, (String)"chesttransporter_gold");
        GameRegistry.registerItem((Item)chestTransporterDiamond, (String)"chesttransporter_diamond");
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)chestTransporter), new Object[]{"S S", "SSS", " S ", Character.valueOf('S'), Items.field_151055_y}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)chestTransporterIron), new Object[]{"S S", "SSS", " M ", Character.valueOf('S'), Items.field_151055_y, Character.valueOf('M'), Items.field_151042_j}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)chestTransporterGold), new Object[]{"S S", "SSS", " M ", Character.valueOf('S'), Items.field_151055_y, Character.valueOf('M'), Items.field_151043_k}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)chestTransporterDiamond), new Object[]{"S S", "SSS", " M ", Character.valueOf('S'), Items.field_151055_y, Character.valueOf('M'), Items.field_151045_i}));
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        String[] classNames;
        String[] names;
        Block block;
        TransportableChest chest = new TransportableChest((Block)Blocks.field_150486_ae, -1, 1, "vanilla");
        ChestRegistry.register(chest);
        ChestRegistry.registerMinecart(EntityMinecartChest.class, chest);
        ChestRegistry.register(new TransportableChest(Blocks.field_150447_bR, -1, 2, "vanilla_trapped"));
        if (Loader.isModLoaded((String)"IronChest") && (block = (Block)GameData.getBlockRegistry().func_82594_a("IronChest:BlockIronChest")) != null && block != Blocks.field_150350_a) {
            String[] names2 = new String[]{"iron", "gold", "diamond", "copper", "tin", "crystal", "obsidian"};
            for (int i = 0; i < 7; ++i) {
                ChestRegistry.register(new TransportableChest(block, i, 3 + i, names2[i]));
            }
        }
        if (Loader.isModLoaded((String)"MultiPageChest") && (block = (Block)GameData.getBlockRegistry().func_82594_a("MultiPageChest:multipagechest")) != null && block != Blocks.field_150350_a) {
            ChestRegistry.register(new TransportableChest(block, -1, 10, "multipagechest"));
        }
        if (Loader.isModLoaded((String)"factorization") && (block = (Block)GameData.getBlockRegistry().func_82594_a("factorization:FzBlock")) != null && block != Blocks.field_150350_a) {
            ChestRegistry.register(new FzBarrel(block, 2, 11));
        }
        if (Loader.isModLoaded((String)"varietychests")) {
            block = (Block)GameData.getBlockRegistry().func_82594_a("varietychests:customchest");
            if (block != null && block != Blocks.field_150350_a) {
                ChestRegistry.register(new VariertyChest(block, -1, 12, false));
            }
            if ((block = (Block)GameData.getBlockRegistry().func_82594_a("varietychests:customglowingchest")) != null && block != Blocks.field_150350_a) {
                ChestRegistry.register(new VariertyChest(block, -1, 13, true));
            }
        }
        if (Loader.isModLoaded((String)"compactchests")) {
            names = new String[]{"quadruple", "sextuple", "triple", "double", "quintuple"};
            for (int i = 0; i < names.length; ++i) {
                Block block2 = (Block)GameData.getBlockRegistry().func_82594_a("compactchests:" + names[i] + "Chest");
                if (block2 == null || block2 == Blocks.field_150350_a) continue;
                ChestRegistry.register(new TransportableChest(block2, -1, 14 + i, "cc_" + names[i]));
            }
        } else if (Loader.isModLoaded((String)"compactstorage")) {
            names = new String[]{"quadruple", "sextuple", "triple", "double", "quintuple"};
            for (int i = 0; i < names.length; ++i) {
                Block block3 = (Block)GameData.getBlockRegistry().func_82594_a("compactstorage:" + names[i] + "Chest");
                if (block3 == null || block3 == Blocks.field_150350_a) continue;
                ChestRegistry.register(new TransportableChest(block3, -1, 14 + i, "cc_" + names[i]));
            }
        }
        if (pickupSpawners) {
            ChestRegistry.register(new Spawner(Blocks.field_150474_ac, -1, 24, "spawner"));
        }
        if (Loader.isModLoaded((String)"ironchestminecarts") && Loader.isModLoaded((String)"IronChest")) {
            classNames = new String[]{"ganymedes01.ironchestminecarts.minecarts.types.EntityMinecartIronChest", "ganymedes01.ironchestminecarts.minecarts.types.EntityMinecartGoldChest", "ganymedes01.ironchestminecarts.minecarts.types.EntityMinecartDiamondChest", "ganymedes01.ironchestminecarts.minecarts.types.EntityMinecartCopperChest", "ganymedes01.ironchestminecarts.minecarts.types.EntityMinecartSilverChest", "ganymedes01.ironchestminecarts.minecarts.types.EntityMinecartCrystalChest", "ganymedes01.ironchestminecarts.minecarts.types.EntityMinecartObsidianChest"};
            try {
                for (int i = 0; i < 7; ++i) {
                    ChestRegistry.registerMinecart(Class.forName(classNames[i]), ChestRegistry.dvToChest.get(3 + i));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (Loader.isModLoaded((String)"extracarts") && Loader.isModLoaded((String)"IronChest")) {
            classNames = new String[]{"com.dta.extracarts.mods.ironchest.entities.EntityIronChestCart", "com.dta.extracarts.mods.ironchest.entities.EntityGoldChestCart", "com.dta.extracarts.mods.ironchest.entities.EntityDiamondChestCart", "com.dta.extracarts.mods.ironchest.entities.EntityCopperChestCart", "com.dta.extracarts.mods.ironchest.entities.EntitySilverChestCart", "com.dta.extracarts.mods.ironchest.entities.EntityCrystalChestCart", "com.dta.extracarts.mods.ironchest.entities.EntityObsidianChestCart"};
            try {
                for (int i = 0; i < 7; ++i) {
                    ChestRegistry.registerMinecart(Class.forName(classNames[i]), ChestRegistry.dvToChest.get(3 + i));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static {
        pickupSpawners = true;
        spawnerWithWood = true;
        spawnerWithIron = true;
        spawnerWithGold = true;
        spawnerWithDiamond = true;
    }
}

