/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.collectiveframework.utils;

import com.austinv11.collectiveframework.utils.ISerializable;
import com.austinv11.collectiveframework.utils.StringUtils;
import com.austinv11.collectiveframework.utils.math.MathUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class ReflectionUtils {
    public static List<Method> getDeclaredMethodsWithAnnotation(Class<? extends Annotation> annotation, Class clazz) {
        Method[] methods = clazz.getDeclaredMethods();
        ArrayList<Method> annotated = new ArrayList<Method>();
        for (Method m : methods) {
            if (!m.isAnnotationPresent(annotation)) continue;
            annotated.add(m);
        }
        return annotated;
    }

    public static List<Field> getDeclaredFieldsWithAnnotation(Class<? extends Annotation> annotation, Class clazz) {
        Field[] fields = clazz.getDeclaredFields();
        ArrayList<Field> annotated = new ArrayList<Field>();
        for (Field f : fields) {
            if (!f.isAnnotationPresent(annotation)) continue;
            annotated.add(f);
        }
        return annotated;
    }

    public static List<Method> getMethodsWithAnnotation(Class<? extends Annotation> annotation, Class clazz) {
        Method[] methods = clazz.getMethods();
        ArrayList<Method> annotated = new ArrayList<Method>();
        for (Method m : methods) {
            if (!m.isAnnotationPresent(annotation)) continue;
            annotated.add(m);
        }
        return annotated;
    }

    public static List<Field> getFieldsWithAnnotation(Class<? extends Annotation> annotation, Class clazz) {
        Field[] fields = clazz.getFields();
        ArrayList<Field> annotated = new ArrayList<Field>();
        for (Field f : fields) {
            if (!f.isAnnotationPresent(annotation)) continue;
            annotated.add(f);
        }
        return annotated;
    }

    public static boolean paramsMatch(Method method, Class<?> ... params) {
        Class<?>[] parameters = method.getParameterTypes();
        if (parameters.length == params.length) {
            for (int i = 0; i < parameters.length; ++i) {
                if (parameters[i].getName().equals(params[i].getName())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static Field getDeclaredOrNormalField(String fieldName, Class clazz) {
        for (Field f : clazz.getDeclaredFields()) {
            if (!f.getName().equals(fieldName)) continue;
            return f;
        }
        for (Field f1 : clazz.getFields()) {
            if (!f1.getName().equals(fieldName)) continue;
            return f1;
        }
        return null;
    }

    public static Method getDeclaredOrNormalMethod(String methodName, Class clazz) {
        for (Method m : clazz.getDeclaredMethods()) {
            if (!m.getName().equals(methodName)) continue;
            return m;
        }
        for (Method m1 : clazz.getMethods()) {
            if (!m1.getName().equals(methodName)) continue;
            return m1;
        }
        return null;
    }

    public static String getSignatureFromObject(Object o) {
        if (o.getClass().isArray()) {
            return o.getClass().getName().replace(".", "/");
        }
        return ReflectionUtils.getSignatureFromObject(o, false);
    }

    private static String getSignatureFromObject(Object o, boolean isRecursive) {
        if (o instanceof Integer) {
            return "I";
        }
        if (o instanceof Long) {
            return "J";
        }
        if (o instanceof Double) {
            return "D";
        }
        if (o instanceof Float) {
            return "F";
        }
        if (o instanceof Boolean) {
            return "Z";
        }
        if (!(o instanceof String) && o instanceof Character) {
            return "C";
        }
        if (o instanceof Byte) {
            return "B";
        }
        if (o instanceof Void) {
            return "V";
        }
        if (o instanceof Short) {
            return "S";
        }
        return "L" + o.getClass().getName().replace(".", "/") + ";";
    }

    public static Class getTypeFromSignature(String signature) throws ClassNotFoundException {
        if (signature.charAt(0) == '[') {
            if ((signature = signature.replace("[", "")).equals("I")) {
                return int[].class;
            }
            if (signature.equals("J")) {
                return long[].class;
            }
            if (signature.equals("D")) {
                return double[].class;
            }
            if (signature.equals("F")) {
                return float[].class;
            }
            if (signature.equals("Z")) {
                return boolean[].class;
            }
            if (signature.equals("C")) {
                return char[].class;
            }
            if (signature.equals("B")) {
                return byte[].class;
            }
            if (signature.equals("S")) {
                return short[].class;
            }
            if (signature.contains("L")) {
                return Array.newInstance(Class.forName(signature.substring(1, signature.length()).replace("/", ".")), 1).getClass();
            }
        } else {
            if (signature.equals("I")) {
                return Integer.TYPE;
            }
            if (signature.equals("J")) {
                return Long.TYPE;
            }
            if (signature.equals("D")) {
                return Double.TYPE;
            }
            if (signature.equals("F")) {
                return Float.TYPE;
            }
            if (signature.equals("Z")) {
                return Boolean.TYPE;
            }
            if (signature.equals("C")) {
                return Character.TYPE;
            }
            if (signature.equals("B")) {
                return Byte.TYPE;
            }
            if (signature.equals("V")) {
                return Void.TYPE;
            }
            if (signature.equals("S")) {
                return Short.TYPE;
            }
            if (signature.contains("L")) {
                return Class.forName(signature.substring(1, signature.length() - 1).replace("/", "."));
            }
        }
        return null;
    }

    public static Class getPrimitiveSafeClassForName(String name) throws ClassNotFoundException {
        if (name.equalsIgnoreCase("int")) {
            return Integer.TYPE;
        }
        if (name.equalsIgnoreCase("long")) {
            return Long.TYPE;
        }
        if (name.equalsIgnoreCase("double")) {
            return Double.TYPE;
        }
        if (name.equalsIgnoreCase("float")) {
            return Float.TYPE;
        }
        if (name.equalsIgnoreCase("boolean")) {
            return Boolean.TYPE;
        }
        if (name.equalsIgnoreCase("char")) {
            return Character.TYPE;
        }
        if (name.equalsIgnoreCase("byte")) {
            return Byte.TYPE;
        }
        if (name.equalsIgnoreCase("void")) {
            return Void.TYPE;
        }
        if (name.equalsIgnoreCase("short")) {
            return Short.TYPE;
        }
        return Class.forName(name);
    }

    public static boolean isNamePrimitive(String name) {
        return name.equalsIgnoreCase("int") || name.equalsIgnoreCase("long") || name.equalsIgnoreCase("double") || name.equalsIgnoreCase("float") || name.equalsIgnoreCase("boolean") || name.equalsIgnoreCase("char") || name.equalsIgnoreCase("byte") || name.equalsIgnoreCase("void") || name.equalsIgnoreCase("short") || name.equalsIgnoreCase("integer") || name.equalsIgnoreCase("character");
    }

    public static boolean isNamePrimitiveOrPrimitiveObject(String name) {
        return name.equalsIgnoreCase("int") || name.equalsIgnoreCase("long") || name.equalsIgnoreCase("double") || name.equalsIgnoreCase("float") || name.equalsIgnoreCase("boolean") || name.equalsIgnoreCase("char") || name.equalsIgnoreCase("byte") || name.equalsIgnoreCase("void") || name.equalsIgnoreCase("short") || name.equalsIgnoreCase("integer") || name.equalsIgnoreCase("character");
    }

    public static boolean isPrimitiveObject(Object o) {
        return o instanceof Integer || o instanceof Long || o instanceof Double || o instanceof Float || o instanceof Boolean || o instanceof Character || o instanceof Byte || o instanceof Void || o instanceof Short;
    }

    public static Object coerceStringToJavaObject(String containingString) {
        if (MathUtils.isStringNumber(containingString)) {
            if (containingString.contains(".")) {
                return Double.parseDouble(containingString);
            }
            return Integer.parseInt(containingString);
        }
        if (containingString.length() == 1) {
            return Character.valueOf(containingString.charAt(0));
        }
        if (containingString.equals("false") || containingString.equals("true")) {
            return Boolean.parseBoolean(containingString);
        }
        if (containingString.equals("void")) {
            return null;
        }
        return containingString;
    }

    public static Object[] coerceStringToArray(String containingString) {
        containingString = containingString.replace("{", "").replace("}", "").trim();
        String[] objects = containingString.split(",");
        Object[] array = new Object[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            array[i] = ReflectionUtils.coerceStringToJavaObject(objects[i].trim());
        }
        return array;
    }

    public static Object[] coerceStringToArray(String containingString, Object toObject) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IOException {
        containingString = containingString.replace("{", "").replace("}", "").trim();
        String[] objects = containingString.split(",");
        Object[] array = new Object[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            array[i] = ReflectionUtils.objectFromString(objects[i].trim(), toObject.getClass().newInstance());
        }
        return array;
    }

    public static Object objectFromString(String objectString, Object object) throws IOException, IllegalAccessException, ClassNotFoundException, InstantiationException {
        String line;
        if (object == null) {
            if (objectString.contains("[") && objectString.endsWith("]")) {
                return ReflectionUtils.coerceStringToArray(objectString);
            }
            return ReflectionUtils.coerceStringToJavaObject(objectString);
        }
        if (object instanceof ISerializable) {
            return ((ISerializable)object).deserialize(objectString);
        }
        if (object.getClass().isArray()) {
            return ReflectionUtils.coerceStringToArray(objectString, object);
        }
        BufferedReader reader = new BufferedReader(new StringReader(objectString));
        String block = "";
        String blockField = null;
        String blockType = null;
        boolean isReadingBlock = false;
        while ((line = reader.readLine()) != null) {
            Field field;
            line = line.replace("\t", "");
            if (!isReadingBlock && line.contains("{")) {
                blockType = line.trim().substring(0, line.indexOf(":"));
                blockField = line.trim().substring(line.indexOf(":") + 1, line.indexOf("="));
                isReadingBlock = true;
                continue;
            }
            if (isReadingBlock && line.trim().equals("}")) {
                isReadingBlock = false;
                field = ReflectionUtils.getDeclaredOrNormalField(blockField, object.getClass());
                field.setAccessible(true);
                field.set(object, ReflectionUtils.objectFromString(objectString, ReflectionUtils.getTypeFromSignature(blockType).newInstance()));
                continue;
            }
            if (isReadingBlock) {
                block = block + line;
                continue;
            }
            if (line.length() <= 4 || (field = ReflectionUtils.getDeclaredOrNormalField(line.trim().substring(line.indexOf(":") + 1, line.contains("=") ? line.indexOf("=") : line.length()), object.getClass())) == null) continue;
            field.setAccessible(true);
            field.set(object, ReflectionUtils.coerceStringToJavaObject(line.substring(line.indexOf("=") + 1).trim()));
        }
        return object;
    }

    public static String objectToString(Object o) {
        return ReflectionUtils.objectToString(o, 0);
    }

    public static String objectToString(Object o, int tabs) {
        Field[] normal;
        Field[] declared;
        if (o.getClass().isArray()) {
            String array = "[";
            for (int i = 0; i < Array.getLength(o); ++i) {
                array = array + "," + ReflectionUtils.objectToString(Array.get(o, i), tabs);
            }
            array = array.replaceFirst(",", "");
            return array + "]";
        }
        if (o instanceof ISerializable) {
            return ((ISerializable)o).serialize();
        }
        if (ReflectionUtils.isPrimitiveObject(o) || o instanceof String) {
            return o.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{\n");
        for (Field f : declared = o.getClass().getDeclaredFields()) {
            f.setAccessible(true);
            try {
                sb.append(StringUtils.repeatString("\t", tabs + 1));
                sb.append(ReflectionUtils.getSignatureFromObject(o));
                sb.append(":");
                sb.append(f.getName());
                sb.append("=");
                sb.append(ReflectionUtils.objectToString(f.get(o), tabs + 1));
                sb.append("\n");
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        for (Field f : normal = o.getClass().getFields()) {
            f.setAccessible(true);
            try {
                sb.append(StringUtils.repeatString("\t", tabs + 1));
                sb.append(ReflectionUtils.getSignatureFromObject(o));
                sb.append(":");
                sb.append(f.getName());
                sb.append("=");
                sb.append(ReflectionUtils.objectToString(f.get(o), tabs + 1));
                sb.append("\n");
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        sb.append(StringUtils.repeatString("\t", tabs));
        sb.append("}");
        return sb.toString();
    }

    public static boolean classImplementsInterface(Class classToExamine, Class interfaceClass) {
        return interfaceClass.isInterface() && interfaceClass.isAssignableFrom(classToExamine);
    }
}

