/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.collectiveframework.minecraft.utils;

import com.austinv11.collectiveframework.language.TranslationManager;
import com.austinv11.collectiveframework.language.translation.TranslationException;
import com.austinv11.collectiveframework.minecraft.reference.Config;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.StatCollector;
import net.minecraft.util.StringTranslate;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;

public class MinecraftTranslator {
    private static Field fallback;

    public static String translate(String text, String toLang) throws IOException, TranslationException {
        if (StatCollector.func_94522_b((String)text)) {
            return StatCollector.func_74838_a((String)text);
        }
        String toTranslate = StatCollector.func_150826_b((String)text);
        return TranslationManager.translate(toTranslate, toLang);
    }

    public static String translate(String text, String fromLang, String toLang) throws TranslationException, IOException {
        if (StatCollector.func_94522_b((String)text)) {
            return StatCollector.func_74838_a((String)text);
        }
        String toTranslate = StatCollector.func_150826_b((String)text);
        return TranslationManager.translate(toTranslate, fromLang, toLang);
    }

    public static String translateToLocal(String text, String fromLang) throws TranslationException, IOException {
        return MinecraftTranslator.translate(text, fromLang, MinecraftTranslator.langToUsable());
    }

    public static String translateToLocal(String text) throws TranslationException, IOException {
        return MinecraftTranslator.translate(text, MinecraftTranslator.langToUsable());
    }

    public static String langToUsable() {
        return MinecraftTranslator.mcLangCodesToUsable(Minecraft.func_71410_x().field_71474_y.field_74363_ab);
    }

    public static String mcLangCodesToUsable(String code) {
        String[] langInfo = code.split("_");
        Locale loc = new Locale(langInfo[0], langInfo[1]);
        return loc.getLanguage();
    }

    @SubscribeEvent
    public void onTooltipEvent(ItemTooltipEvent event) {
        if (Config.translateItems) {
            try {
                if (!StatCollector.func_94522_b((String)event.itemStack.func_77977_a()) && MinecraftTranslator.getFallback().func_94520_b(event.itemStack.func_77977_a()) && StatCollector.func_150826_b((String)event.itemStack.func_77977_a()).equals(event.itemStack.func_82833_r())) {
                    String toTranslate = event.itemStack.func_82833_r();
                    event.itemStack.func_151001_c(MinecraftTranslator.translateToLocal(toTranslate, "en"));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public void onChatEvent(ClientChatReceivedEvent event) {
        if (Config.translateChat && !event.isCanceled()) {
            try {
                String message = MinecraftTranslator.getFallback().func_94520_b(event.message.func_150260_c()) ? StatCollector.func_150826_b((String)event.message.func_150260_c()) : event.message.func_150260_c();
                event.message = new ChatComponentText(MinecraftTranslator.translateToLocal(message, "en"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static StringTranslate getFallback() throws IllegalAccessException, NoSuchFieldException {
        if (fallback == null) {
            fallback = StatCollector.class.getDeclaredField("fallbackTranslator");
            fallback.setAccessible(true);
        }
        return (StringTranslate)fallback.get(null);
    }
}

