/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.collectiveframework.minecraft.utils;

import com.austinv11.collectiveframework.utils.math.ThreeDimensionalVector;
import java.util.HashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class Location
extends ThreeDimensionalVector {
    private World world;

    private Location(double x, double y, double z) {
        super(x, y, z);
    }

    public Location(double x, double y, double z, World world) {
        super(x, y, z);
        this.world = world;
    }

    public Location(Entity entity) {
        this(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70170_p);
    }

    public Location(TileEntity tileEntity) {
        this(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e, tileEntity.func_145831_w());
    }

    public Location(Location location) {
        this(location.getX(), location.getY(), location.getZ(), location.getWorld());
    }

    public static Location locationFromChunkCoords(ChunkCoordinates coords, World world) {
        return new Location(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c, world);
    }

    public ChunkCoordinates chunkCoordsFromLocation() {
        return new ChunkCoordinates(this.getRoundedX(), this.getRoundedY(), this.getRoundedZ());
    }

    public World getWorld() {
        return this.world;
    }

    public HashMap<String, Double> getPlayers(double range) {
        HashMap<String, Double> map = new HashMap<String, Double>();
        for (EntityPlayer player : this.world.field_73010_i) {
            Location location = new Location((Entity)player);
            if (!(location.distanceTo(this) <= range)) continue;
            map.put(player.getDisplayName(), new Location((Entity)player).distanceTo(this));
        }
        return map;
    }

    public ChunkCoordinates toChunkCoordinates() {
        return new ChunkCoordinates(this.getRoundedX(), this.getRoundedY(), this.getRoundedZ());
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof Location) {
            return ((Location)other).getRoundedX() == this.getRoundedX() && ((Location)other).getRoundedY() == this.getRoundedY() && ((Location)other).getRoundedZ() == this.getRoundedZ() && ((Location)other).getWorld().field_73011_w.field_76574_g == this.getWorld().field_73011_w.field_76574_g;
        }
        return false;
    }

    public int hashCode() {
        return 0;
    }
}

