/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.recipe;

import gnu.trove.iterator.TIntIterator;
import gnu.trove.list.array.TIntArrayList;
import ic2.api.recipe.IRecipeInput;
import ic2.core.AdvRecipe;
import ic2.core.AdvShapelessRecipe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import wanion.unidict.MetaItem;
import wanion.unidict.UniOreDictionary;
import wanion.unidict.helper.RecipeHelper;
import wanion.unidict.recipe.IRecipeResearcher;
import wanion.unidict.resource.ResourceHandler;

public final class IC2RecipeResearcher
implements IRecipeResearcher<AdvRecipe, AdvShapelessRecipe> {
    @Override
    public int getShapedRecipeKey(@Nonnull IRecipe recipe, @Nonnull ResourceHandler resourceHandler) {
        TIntArrayList recipeKeys = new TIntArrayList();
        int recipeKey = 0;
        for (Object input : ((AdvRecipe)recipe).input) {
            if (input instanceof ItemStack) {
                recipeKeys.add(MetaItem.get(resourceHandler.getMainItemStack((ItemStack)input)));
                continue;
            }
            if (input instanceof List) {
                if (((List)input).isEmpty()) continue;
                Object obj = ((List)input).get(0);
                if (obj instanceof ItemStack) {
                    recipeKeys.add(MetaItem.get(resourceHandler.getMainItemStack((ItemStack)obj)));
                    continue;
                }
                if (!(obj instanceof IRecipeInput)) continue;
                recipeKeys.add(MetaItem.get((ItemStack)((IRecipeInput)obj).getInputs().get(0)));
                continue;
            }
            if (!(input instanceof IRecipeInput)) continue;
            recipeKeys.add(MetaItem.get((ItemStack)((IRecipeInput)input).getInputs().get(0)));
        }
        recipeKeys.sort();
        TIntIterator recipeKeysIterator = recipeKeys.iterator();
        while (recipeKeysIterator.hasNext()) {
            recipeKey += 31 * recipeKeysIterator.next();
        }
        return recipeKey;
    }

    @Override
    public int getShapelessRecipeKey(@Nonnull IRecipe recipe, @Nonnull ResourceHandler resourceHandler) {
        TIntArrayList recipeKeys = new TIntArrayList();
        int recipeKey = 0;
        for (Object input : ((AdvShapelessRecipe)recipe).input) {
            if (input instanceof ItemStack) {
                recipeKeys.add(MetaItem.get(resourceHandler.getMainItemStack((ItemStack)input)));
                continue;
            }
            if (input instanceof List) {
                if (((List)input).isEmpty()) continue;
                Object obj = ((List)input).get(0);
                if (obj instanceof ItemStack) {
                    recipeKeys.add(MetaItem.get(resourceHandler.getMainItemStack((ItemStack)obj)));
                    continue;
                }
                if (!(obj instanceof IRecipeInput)) continue;
                recipeKeys.add(MetaItem.get((ItemStack)((IRecipeInput)obj).getInputs().get(0)));
                continue;
            }
            if (!(input instanceof IRecipeInput)) continue;
            recipeKeys.add(MetaItem.get((ItemStack)((IRecipeInput)input).getInputs().get(0)));
        }
        recipeKeys.sort();
        TIntIterator recipeKeysIterator = recipeKeys.iterator();
        while (recipeKeysIterator.hasNext()) {
            recipeKey += 31 * recipeKeysIterator.next();
        }
        return recipeKey;
    }

    @Override
    @Nonnull
    public List<Class<? extends AdvRecipe>> getShapedRecipeClasses() {
        return Collections.singletonList(AdvRecipe.class);
    }

    @Override
    @Nonnull
    public List<Class<? extends AdvShapelessRecipe>> getShapelessRecipeClasses() {
        return Collections.singletonList(AdvShapelessRecipe.class);
    }

    @Override
    @Nonnull
    public ShapedOreRecipe getNewShapedRecipe(@Nonnull IRecipe recipe, @Nonnull ResourceHandler resourceHandler, @Nonnull UniOreDictionary uniOreDictionary) {
        Object[] newRecipeInputs = new Object[9];
        Object[] recipeInputs = ((AdvRecipe)recipe).input;
        for (int i = 0; i < 9 && i < recipeInputs.length; ++i) {
            Object obj;
            if (recipeInputs[i] instanceof IRecipeInput) {
                List inputs = ((IRecipeInput)recipeInputs[i]).getInputs();
                if (inputs.isEmpty()) continue;
                String bufferOreName = uniOreDictionary.getName(inputs);
                newRecipeInputs[i] = bufferOreName != null ? bufferOreName : ((bufferOreName = uniOreDictionary.getName(inputs.get(0))) != null ? bufferOreName : inputs.get(0));
                continue;
            }
            String bufferOreName = uniOreDictionary.getName(recipeInputs[i]);
            if (bufferOreName != null) {
                newRecipeInputs[i] = bufferOreName;
                continue;
            }
            if (recipeInputs[i] instanceof ItemStack) {
                newRecipeInputs[i] = resourceHandler.getMainItemStack((ItemStack)recipeInputs[i]);
                continue;
            }
            if (!(recipeInputs[i] instanceof List) || !((obj = ((List)recipeInputs[i]).get(0)) instanceof ItemStack)) continue;
            newRecipeInputs[i] = resourceHandler.getMainItemStack((ItemStack)obj);
        }
        return new ShapedOreRecipe(resourceHandler.getMainItemStack(recipe.func_77571_b()), RecipeHelper.rawShapeToShape(newRecipeInputs));
    }

    @Override
    @Nonnull
    public ShapedOreRecipe getNewShapedFromShapelessRecipe(@Nonnull IRecipe recipe, @Nonnull ResourceHandler resourceHandler, @Nonnull UniOreDictionary uniOreDictionary) {
        ArrayList<String> newInputs = new ArrayList<String>();
        for (Object recipeInput : ((AdvShapelessRecipe)recipe).input) {
            String bufferOreName;
            if (recipeInput instanceof List) {
                Object input = ((List)recipeInput).get(0);
                if (input instanceof IRecipeInput) {
                    List inputs = ((IRecipeInput)input).getInputs();
                    String bufferOreName2 = uniOreDictionary.getName(inputs);
                    newInputs.add(bufferOreName2 != null ? bufferOreName2 : ((bufferOreName2 = uniOreDictionary.getName(inputs.get(0))) != null ? bufferOreName2 : inputs.get(0)));
                    continue;
                }
                if (!(input instanceof ItemStack)) continue;
                bufferOreName = uniOreDictionary.getName(input);
                newInputs.add(bufferOreName != null ? bufferOreName : input);
                continue;
            }
            if (recipeInput instanceof IRecipeInput) {
                List inputs = ((IRecipeInput)recipeInput).getInputs();
                bufferOreName = uniOreDictionary.getName(inputs);
                newInputs.add(bufferOreName != null ? bufferOreName : ((bufferOreName = uniOreDictionary.getName(inputs.get(0))) != null ? bufferOreName : inputs.get(0)));
                continue;
            }
            String bufferOreName3 = uniOreDictionary.getName(recipeInput);
            if (bufferOreName3 != null) {
                newInputs.add(bufferOreName3);
                continue;
            }
            if (!(recipeInput instanceof ItemStack)) continue;
            newInputs.add((String)resourceHandler.getMainItemStack((ItemStack)recipeInput));
        }
        return new ShapedOreRecipe(resourceHandler.getMainItemStack(recipe.func_77571_b()), RecipeHelper.rawShapeToShape(newInputs.toArray()));
    }

    @Override
    @Nonnull
    public ShapelessOreRecipe getNewShapelessRecipe(@Nonnull IRecipe recipe, @Nonnull ResourceHandler resourceHandler, @Nonnull UniOreDictionary uniOreDictionary) {
        ArrayList<String> newInputs = new ArrayList<String>();
        for (Object recipeInput : ((AdvShapelessRecipe)recipe).input) {
            String bufferOreName;
            if (recipeInput instanceof List) {
                Object input = ((List)recipeInput).get(0);
                if (input instanceof IRecipeInput) {
                    List inputs = ((IRecipeInput)input).getInputs();
                    String bufferOreName2 = uniOreDictionary.getName(inputs);
                    newInputs.add(bufferOreName2 != null ? bufferOreName2 : ((bufferOreName2 = uniOreDictionary.getName(inputs.get(0))) != null ? bufferOreName2 : inputs.get(0)));
                    continue;
                }
                if (!(input instanceof ItemStack)) continue;
                bufferOreName = uniOreDictionary.getName(input);
                newInputs.add(bufferOreName != null ? bufferOreName : input);
                continue;
            }
            if (recipeInput instanceof IRecipeInput) {
                List inputs = ((IRecipeInput)recipeInput).getInputs();
                bufferOreName = uniOreDictionary.getName(inputs);
                newInputs.add(bufferOreName != null ? bufferOreName : ((bufferOreName = uniOreDictionary.getName(inputs.get(0))) != null ? bufferOreName : inputs.get(0)));
                continue;
            }
            String bufferOreName3 = uniOreDictionary.getName(recipeInput);
            if (bufferOreName3 != null) {
                newInputs.add(bufferOreName3);
                continue;
            }
            if (!(recipeInput instanceof ItemStack)) continue;
            newInputs.add((String)resourceHandler.getMainItemStack((ItemStack)recipeInput));
        }
        return new ShapelessOreRecipe(resourceHandler.getMainItemStack(recipe.func_77571_b()), newInputs.toArray());
    }

    @Override
    @Nonnull
    public ShapelessOreRecipe getNewShapelessFromShapedRecipe(@Nonnull IRecipe recipe, @Nonnull ResourceHandler resourceHandler, @Nonnull UniOreDictionary uniOreDictionary) {
        ArrayList<String> newInputs = new ArrayList<String>();
        for (Object recipeInput : ((AdvRecipe)recipe).input) {
            Object obj;
            if (recipeInput instanceof IRecipeInput) {
                List inputs = ((IRecipeInput)recipeInput).getInputs();
                String bufferOreName = uniOreDictionary.getName(inputs);
                newInputs.add(bufferOreName != null ? bufferOreName : ((bufferOreName = uniOreDictionary.getName(inputs.get(0))) != null ? bufferOreName : inputs.get(0)));
                continue;
            }
            String bufferOreName = uniOreDictionary.getName(recipeInput);
            if (bufferOreName != null) {
                newInputs.add(bufferOreName);
                continue;
            }
            if (recipeInput instanceof ItemStack) {
                newInputs.add((String)resourceHandler.getMainItemStack((ItemStack)recipeInput));
                continue;
            }
            if (!(recipeInput instanceof List) || !((obj = ((List)recipeInput).get(0)) instanceof ItemStack)) continue;
            newInputs.add((String)resourceHandler.getMainItemStack((ItemStack)obj));
        }
        return new ShapelessOreRecipe(resourceHandler.getMainItemStack(recipe.func_77571_b()), newInputs.toArray());
    }
}

