/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.integration;

import exter.foundry.api.recipe.IAlloyFurnaceRecipe;
import exter.foundry.api.recipe.IAtomizerRecipe;
import exter.foundry.api.recipe.ICastingRecipe;
import exter.foundry.recipes.AlloyFurnaceRecipe;
import exter.foundry.recipes.AtomizerRecipe;
import exter.foundry.recipes.CastingRecipe;
import exter.foundry.recipes.manager.AlloyFurnaceRecipeManager;
import exter.foundry.recipes.manager.AtomizerRecipeManager;
import exter.foundry.recipes.manager.CastingRecipeManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.ItemStack;
import wanion.unidict.UniDict;
import wanion.unidict.integration.AbstractIntegrationThread;

final class FoundryIntegration
extends AbstractIntegrationThread {
    FoundryIntegration() {
        super("Foundry");
    }

    @Override
    public String call() {
        try {
            this.fixAlloyFurnaceRecipes();
            this.fixAtomizerRecipes();
            this.fixCastingRecipes();
        }
        catch (Exception e) {
            UniDict.getLogger().error(this.threadName + e);
        }
        return this.threadName + "Somethings that are made in casts had to change.";
    }

    private void fixAlloyFurnaceRecipes() {
        List alloyFurnaceRecipes = AlloyFurnaceRecipeManager.instance.recipes;
        ArrayList<AlloyFurnaceRecipe> newRecipes = new ArrayList<AlloyFurnaceRecipe>();
        Iterator alloyFurnaceRecipeIterator = alloyFurnaceRecipes.iterator();
        while (alloyFurnaceRecipeIterator.hasNext()) {
            IAlloyFurnaceRecipe atomizerRecipe = (IAlloyFurnaceRecipe)alloyFurnaceRecipeIterator.next();
            ItemStack correctOutput = this.resourceHandler.getMainItemStack(atomizerRecipe.GetOutput());
            if (correctOutput == atomizerRecipe.GetOutput()) continue;
            newRecipes.add(new AlloyFurnaceRecipe(correctOutput, atomizerRecipe.GetInputA(), atomizerRecipe.GetInputB()));
            alloyFurnaceRecipeIterator.remove();
        }
        alloyFurnaceRecipes.addAll(newRecipes);
    }

    private void fixAtomizerRecipes() {
        List atomizerRecipes = AtomizerRecipeManager.instance.recipes;
        ArrayList<AtomizerRecipe> newRecipes = new ArrayList<AtomizerRecipe>();
        Iterator atomizerRecipeIterator = atomizerRecipes.iterator();
        while (atomizerRecipeIterator.hasNext()) {
            ItemStack correctOutput;
            IAtomizerRecipe atomizerRecipe = (IAtomizerRecipe)atomizerRecipeIterator.next();
            Object output = atomizerRecipe.GetOutput();
            if (!(output instanceof ItemStack) || (correctOutput = this.resourceHandler.getMainItemStack((ItemStack)output)) == output) continue;
            newRecipes.add(new AtomizerRecipe((Object)correctOutput, atomizerRecipe.GetInputFluid()));
            atomizerRecipeIterator.remove();
        }
        atomizerRecipes.addAll(newRecipes);
    }

    private void fixCastingRecipes() {
        List castingRecipes = CastingRecipeManager.instance.recipes;
        ArrayList<CastingRecipe> newRecipes = new ArrayList<CastingRecipe>();
        Iterator castingRecipeIterator = castingRecipes.iterator();
        while (castingRecipeIterator.hasNext()) {
            ItemStack correctOutput;
            ICastingRecipe castingRecipe = (ICastingRecipe)castingRecipeIterator.next();
            Object output = castingRecipe.GetOutput();
            if (!(output instanceof ItemStack) || (correctOutput = this.resourceHandler.getMainItemStack((ItemStack)output)) == output) continue;
            newRecipes.add(new CastingRecipe((Object)correctOutput, castingRecipe.GetInputFluid(), castingRecipe.GetInputMold(), null, castingRecipe.GetCastingSpeed()));
            castingRecipeIterator.remove();
        }
        castingRecipes.addAll(newRecipes);
    }
}

