/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.integration;

import cpw.mods.fml.common.registry.GameData;
import forestry.api.recipes.ICarpenterRecipe;
import forestry.api.recipes.IDescriptiveRecipe;
import forestry.core.items.ItemCrated;
import forestry.core.recipes.ShapedRecipeCustom;
import forestry.factory.recipes.CarpenterRecipe;
import forestry.factory.recipes.CarpenterRecipeManager;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import wanion.unidict.Config;
import wanion.unidict.MetaItem;
import wanion.unidict.UniDict;
import wanion.unidict.api.helper.ForestryUniHelper;
import wanion.unidict.common.Util;
import wanion.unidict.helper.NEIHelper;
import wanion.unidict.integration.AbstractIntegrationThread;
import wanion.unidict.resource.UniResourceContainer;

final class ForestryIntegration
extends AbstractIntegrationThread {
    private Set<Integer> thingsToRemove = new HashSet<Integer>(64);
    private Map<UniResourceContainer, ItemCrated> uniDictCrates = new LinkedHashMap<UniResourceContainer, ItemCrated>();
    private Set<ICarpenterRecipe> carpenterRecipes = (Set)Util.getField(CarpenterRecipeManager.class, "recipes", null, Set.class);

    ForestryIntegration() {
        super("Forestry");
        this.populateThingsToRemove();
    }

    private void populateThingsToRemove() {
        if (this.resourceHandler.resourceExists("Bronze")) {
            this.thingsToRemove.add(MetaItem.get((Item)GameData.getItemRegistry().getRaw("Forestry:cratedBronze")));
            this.thingsToRemove.add(MetaItem.get((Item)GameData.getItemRegistry().getRaw("Forestry:cratedBrass")));
        }
        if (this.resourceHandler.resourceExists("Tin")) {
            this.thingsToRemove.add(MetaItem.get((Item)GameData.getItemRegistry().getRaw("Forestry:cratedTin")));
        }
        if (this.resourceHandler.resourceExists("Copper")) {
            this.thingsToRemove.add(MetaItem.get((Item)GameData.getItemRegistry().getRaw("Forestry:cratedCopper")));
        }
        if (this.resourceHandler.resourceExists("Silver")) {
            this.thingsToRemove.add(MetaItem.get((Item)GameData.getItemRegistry().getRaw("Forestry:cratedSilver")));
        }
    }

    @Override
    public String call() {
        try {
            this.removeBadCarpenterOutputs(this.carpenterRecipes);
            if (this.resourceHandler.containerExists("ingotBronze")) {
                this.bronzeThings();
            }
            this.createCratesDefault();
            ForestryUniHelper.registerCratesAndCreateRecipes(this.uniDictCrates);
        }
        catch (Exception e) {
            UniDict.getLogger().error(this.threadName + e);
        }
        return this.threadName + "All these bees... they can hurt, you know?";
    }

    private void removeBadCarpenterOutputs(Set<ICarpenterRecipe> carpenterRecipes) {
        Iterator<ICarpenterRecipe> carpenterRecipeIterator = carpenterRecipes.iterator();
        while (carpenterRecipeIterator.hasNext()) {
            IDescriptiveRecipe carpenterRecipe = carpenterRecipeIterator.next().getCraftingGridRecipe();
            ItemStack output = carpenterRecipe.func_77571_b();
            int id = MetaItem.get(output);
            boolean existsInResource = this.resourceHandler.exists(id);
            boolean existsInThingsToRemove = this.thingsToRemove.contains(id);
            if (Config.autoHideInNEI && existsInThingsToRemove) {
                NEIHelper.hide(output);
            }
            if (!existsInResource && !existsInThingsToRemove) continue;
            carpenterRecipeIterator.remove();
        }
    }

    private void bronzeThings() {
        UniResourceContainer ingotBronze = this.resourceHandler.getContainer("ingotBronze");
        this.carpenterRecipes.add((ICarpenterRecipe)new CarpenterRecipe(5, null, null, new ShapedRecipeCustom(ingotBronze.getMainEntry(2), new Object[]{"X  ", "   ", "   ", Character.valueOf('X'), new ItemStack((Item)GameData.getItemRegistry().getRaw("Forestry:brokenBronzePickaxe"))})));
        this.carpenterRecipes.add((ICarpenterRecipe)new CarpenterRecipe(5, null, null, new ShapedRecipeCustom(ingotBronze.getMainEntry(1), new Object[]{"X  ", "   ", "   ", Character.valueOf('X'), new ItemStack((Item)GameData.getItemRegistry().getRaw("Forestry:brokenBronzeShovel"))})));
    }

    private void createCratesDefault() {
        UniResourceContainer ingotCopper = this.resourceHandler.getContainer("ingotCopper");
        UniResourceContainer ingotTin = this.resourceHandler.getContainer("ingotTin");
        UniResourceContainer ingotSilver = this.resourceHandler.getContainer("ingotSilver");
        UniResourceContainer ingotBronze = this.resourceHandler.getContainer("ingotBronze");
        if (ingotCopper != null) {
            this.uniDictCrates.put(ingotCopper, new ItemCrated(ingotCopper.getMainEntry(), true));
        }
        if (ingotTin != null) {
            this.uniDictCrates.put(ingotTin, new ItemCrated(ingotTin.getMainEntry(), true));
        }
        if (ingotSilver != null) {
            this.uniDictCrates.put(ingotSilver, new ItemCrated(ingotSilver.getMainEntry(), true));
        }
        if (ingotBronze != null) {
            this.uniDictCrates.put(ingotBronze, new ItemCrated(ingotBronze.getMainEntry(), true));
        }
    }
}

