/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.api.helper;

import cpw.mods.fml.common.registry.GameRegistry;
import forestry.api.recipes.ICarpenterRecipe;
import forestry.core.fluids.Fluids;
import forestry.core.items.ItemCrated;
import forestry.core.recipes.ShapedRecipeCustom;
import forestry.factory.recipes.CarpenterRecipe;
import forestry.factory.recipes.CarpenterRecipeManager;
import forestry.plugins.PluginStorage;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.text.WordUtils;
import wanion.unidict.UniDict;
import wanion.unidict.common.Util;
import wanion.unidict.resource.Resource;
import wanion.unidict.resource.UniResourceContainer;

public final class ForestryUniHelper {
    private static final Set<ICarpenterRecipe> carpenterRecipes = (Set)Util.getField(CarpenterRecipeManager.class, "recipes", null, Set.class);

    private ForestryUniHelper() {
    }

    public static void createCrates(@Nonnull String kindName) {
        LinkedHashMap<UniResourceContainer, ItemCrated> crates = new LinkedHashMap<UniResourceContainer, ItemCrated>();
        long kind = Resource.getKindOfName(kindName);
        if (kind == 0L) {
            return;
        }
        for (Resource resource : UniDict.getResourceHandler().resources) {
            UniResourceContainer container = resource.getChild(kind);
            if (container == null) continue;
            crates.put(container, new ItemCrated(container.getMainEntry(), true));
        }
        ForestryUniHelper.registerCratesAndCreateRecipes(crates);
    }

    public static void registerCratesAndCreateRecipes(@Nonnull Map<UniResourceContainer, ItemCrated> crates) {
        if (carpenterRecipes == null) {
            return;
        }
        for (UniResourceContainer container : crates.keySet()) {
            ItemCrated crate = crates.get(container);
            crate.func_77655_b(WordUtils.capitalize((String)container.name));
            GameRegistry.registerItem((Item)crate, (String)crate.func_77658_a().replaceFirst("^item\\.", "crated"));
            PluginStorage.registerCrate((ItemCrated)crate);
            carpenterRecipes.add((ICarpenterRecipe)new CarpenterRecipe(5, Fluids.WATER.getFluid(100), null, new ShapedRecipeCustom(new ItemStack((Item)crate), new Object[]{"III", "III", "III", Character.valueOf('I'), container.name})));
            carpenterRecipes.add((ICarpenterRecipe)new CarpenterRecipe(5, null, null, new ShapedRecipeCustom(container.getMainEntry(9), new Object[]{"C  ", "   ", "   ", Character.valueOf('C'), crate.getItemStack()})));
        }
    }
}

