/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.storage;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.implementations.tiles.IColorableTile;
import appeng.api.implementations.tiles.IMEChest;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.events.MENetworkPowerStorage;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.security.PlayerSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.ICellHandler;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.MEMonitorHandler;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AEColor;
import appeng.api.util.IConfigManager;
import appeng.helpers.IPriorityHost;
import appeng.me.GridAccessException;
import appeng.me.storage.MEInventoryHandler;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.tile.grid.AENetworkPowerTile;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.Platform;
import appeng.util.item.AEFluidStack;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileChest
extends AENetworkPowerTile
implements IMEChest,
IFluidHandler,
ITerminalHost,
IPriorityHost,
IConfigManagerHost,
IColorableTile {
    static final ChestNoHandler NO_HANDLER = new ChestNoHandler();
    static final int[] SIDES = new int[]{0};
    static final int[] FRONT = new int[]{1};
    static final int[] NO_SLOTS = new int[0];
    final AppEngInternalInventory inv = new AppEngInternalInventory(this, 2);
    final BaseActionSource mySrc = new MachineSource(this);
    final IConfigManager config = new ConfigManager(this);
    ItemStack storageType;
    long lastStateChange = 0L;
    int priority = 0;
    int state = 0;
    boolean wasActive = false;
    AEColor paintedColor = AEColor.Transparent;
    boolean isCached = false;
    private ICellHandler cellHandler;
    private MEMonitorHandler itemCell;
    private MEMonitorHandler fluidCell;

    public TileChest() {
        this.internalMaxPower = PowerMultiplier.CONFIG.multiply(40.0);
        this.gridProxy.setFlags(GridFlags.REQUIRE_CHANNEL);
        this.config.registerSetting(Settings.SORT_BY, SortOrder.NAME);
        this.config.registerSetting(Settings.VIEW_MODE, ViewItems.ALL);
        this.config.registerSetting(Settings.SORT_DIRECTION, SortDir.ASCENDING);
        this.internalPublicPowerStorage = true;
        this.internalPowerFlow = AccessRestriction.WRITE;
    }

    @Override
    protected void PowerEvent(MENetworkPowerStorage.PowerEventType x) {
        if (x == MENetworkPowerStorage.PowerEventType.REQUEST_POWER) {
            try {
                this.gridProxy.getGrid().postEvent(new MENetworkPowerStorage(this, MENetworkPowerStorage.PowerEventType.REQUEST_POWER));
            }
            catch (GridAccessException gridAccessException) {}
        } else {
            this.recalculateDisplay();
        }
    }

    private void recalculateDisplay() {
        int oldState = this.state;
        for (int x = 0; x < this.getCellCount(); ++x) {
            this.state |= this.getCellStatus(x) << 3 * x;
        }
        this.state = this.isPowered() ? (this.state |= 0x40) : (this.state &= 0xFFFFFFBF);
        boolean currentActive = this.gridProxy.isActive();
        if (this.wasActive != currentActive) {
            this.wasActive = currentActive;
            try {
                this.gridProxy.getGrid().postEvent(new MENetworkCellArrayUpdate());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        if (oldState != this.state) {
            this.markForUpdate();
        }
    }

    @Override
    public int getCellCount() {
        return 1;
    }

    public IMEInventoryHandler getHandler(StorageChannel channel) throws ChestNoHandler {
        if (!this.isCached) {
            this.itemCell = null;
            this.fluidCell = null;
            ItemStack is = this.inv.func_70301_a(1);
            if (is != null) {
                this.isCached = true;
                this.cellHandler = AEApi.instance().registries().cell().getHandler(is);
                if (this.cellHandler != null) {
                    double power = 1.0;
                    IMEInventoryHandler itemCell = this.cellHandler.getCellInventory(is, this, StorageChannel.ITEMS);
                    IMEInventoryHandler fluidCell = this.cellHandler.getCellInventory(is, this, StorageChannel.FLUIDS);
                    if (itemCell != null) {
                        power += this.cellHandler.cellIdleDrain(is, itemCell);
                    } else if (fluidCell != null) {
                        power += this.cellHandler.cellIdleDrain(is, fluidCell);
                    }
                    this.gridProxy.setIdlePowerUsage(power);
                    this.itemCell = this.wrap(itemCell);
                    this.fluidCell = this.wrap(fluidCell);
                }
            }
        }
        switch (channel) {
            case FLUIDS: {
                if (this.fluidCell == null) {
                    throw NO_HANDLER;
                }
                return this.fluidCell;
            }
            case ITEMS: {
                if (this.itemCell == null) {
                    throw NO_HANDLER;
                }
                return this.itemCell;
            }
        }
        return null;
    }

    private <StackType extends IAEStack> MEMonitorHandler<StackType> wrap(IMEInventoryHandler h) {
        if (h == null) {
            return null;
        }
        MEInventoryHandler ih = new MEInventoryHandler(h, h.getChannel());
        ih.setPriority(this.priority);
        ChestMonitorHandler g = new ChestMonitorHandler(ih);
        g.addListener(new ChestNetNotifier(h.getChannel()), (Object)g);
        return g;
    }

    @Override
    public int getCellStatus(int slot) {
        if (Platform.isClient()) {
            return this.state >> slot * 3 & 3;
        }
        ItemStack cell = this.inv.func_70301_a(1);
        ICellHandler ch = AEApi.instance().registries().cell().getHandler(cell);
        if (ch != null) {
            IMEInventoryHandler handler;
            try {
                handler = this.getHandler(StorageChannel.ITEMS);
                if (handler instanceof ChestMonitorHandler) {
                    return ch.getStatusForCell(cell, ((ChestMonitorHandler)handler).getInternalHandler());
                }
            }
            catch (ChestNoHandler ignored) {
                // empty catch block
            }
            try {
                handler = this.getHandler(StorageChannel.FLUIDS);
                if (handler instanceof ChestMonitorHandler) {
                    return ch.getStatusForCell(cell, ((ChestMonitorHandler)handler).getInternalHandler());
                }
            }
            catch (ChestNoHandler ignored) {
                // empty catch block
            }
        }
        return 0;
    }

    @Override
    public boolean isPowered() {
        boolean gridPowered;
        if (Platform.isClient()) {
            return (this.state & 0x40) == 64;
        }
        boolean bl = gridPowered = this.getAECurrentPower() > 64.0;
        if (!gridPowered) {
            try {
                gridPowered = this.gridProxy.getEnergy().isNetworkPowered();
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        return super.getAECurrentPower() > 1.0 || gridPowered;
    }

    @Override
    public boolean isCellBlinking(int slot) {
        long now = this.field_145850_b.func_82737_E();
        if (now - this.lastStateChange > 8L) {
            return false;
        }
        return (this.state >> slot * 3 + 2 & 1) == 1;
    }

    @Override
    protected double extractAEPower(double amt, Actionable mode) {
        double stash = 0.0;
        try {
            IEnergyGrid eg = this.gridProxy.getEnergy();
            stash = eg.extractAEPower(amt, mode, PowerMultiplier.ONE);
            if (stash >= amt) {
                return stash;
            }
        }
        catch (GridAccessException e) {
            // empty catch block
        }
        return super.extractAEPower(amt - stash, mode) + stash;
    }

    @TileEvent(value=TileEventType.TICK)
    public void Tick_TileChest() {
        block5: {
            if (this.field_145850_b.field_72995_K) {
                return;
            }
            double idleUsage = this.gridProxy.getIdlePowerUsage();
            try {
                double powerUsed;
                if (!this.gridProxy.getEnergy().isNetworkPowered() && (powerUsed = this.extractAEPower(idleUsage, Actionable.MODULATE, PowerMultiplier.CONFIG)) + 0.1 >= idleUsage != (this.state & 0x40) > 0) {
                    this.recalculateDisplay();
                }
            }
            catch (GridAccessException e) {
                double powerUsed = this.extractAEPower(this.gridProxy.getIdlePowerUsage(), Actionable.MODULATE, PowerMultiplier.CONFIG);
                if (powerUsed + 0.1 >= idleUsage == (this.state & 0x40) > 0) break block5;
                this.recalculateDisplay();
            }
        }
        if (this.inv.func_70301_a(0) != null) {
            this.tryToStoreContents();
        }
    }

    @TileEvent(value=TileEventType.NETWORK_WRITE)
    public void writeToStream_TileChest(ByteBuf data) {
        this.state = this.field_145850_b.func_82737_E() - this.lastStateChange > 8L ? 0 : (this.state &= 0x24924924);
        for (int x = 0; x < this.getCellCount(); ++x) {
            this.state |= this.getCellStatus(x) << 3 * x;
        }
        this.state = this.isPowered() ? (this.state |= 0x40) : (this.state &= 0xFFFFFFBF);
        data.writeByte(this.state);
        data.writeByte(this.paintedColor.ordinal());
        ItemStack is = this.inv.func_70301_a(1);
        if (is == null) {
            data.writeInt(0);
        } else {
            data.writeInt(is.func_77960_j() << 16 | Item.func_150891_b((Item)is.func_77973_b()));
        }
    }

    @TileEvent(value=TileEventType.NETWORK_READ)
    public boolean readFromStream_TileChest(ByteBuf data) {
        int oldState = this.state;
        ItemStack oldType = this.storageType;
        this.state = data.readByte();
        AEColor oldPaintedColor = this.paintedColor;
        this.paintedColor = AEColor.values()[data.readByte()];
        int item = data.readInt();
        this.storageType = item == 0 ? null : new ItemStack(Item.func_150899_d((int)(item & 0xFFFF)), 1, item >> 16);
        this.lastStateChange = this.field_145850_b.func_82737_E();
        return oldPaintedColor != this.paintedColor || (this.state & 0xDB6DB6DB) != (oldState & 0xDB6DB6DB) || !Platform.isSameItemPrecise(oldType, this.storageType);
    }

    @TileEvent(value=TileEventType.WORLD_NBT_READ)
    public void readFromNBT_TileChest(NBTTagCompound data) {
        this.config.readFromNBT(data);
        this.priority = data.func_74762_e("priority");
        if (data.func_74764_b("paintedColor")) {
            this.paintedColor = AEColor.values()[data.func_74771_c("paintedColor")];
        }
    }

    @TileEvent(value=TileEventType.WORLD_NBT_WRITE)
    public void writeToNBT_TileChest(NBTTagCompound data) {
        this.config.writeToNBT(data);
        data.func_74768_a("priority", this.priority);
        data.func_74774_a("paintedColor", (byte)this.paintedColor.ordinal());
    }

    @MENetworkEventSubscribe
    public void powerRender(MENetworkPowerStatusChange c) {
        this.recalculateDisplay();
    }

    @MENetworkEventSubscribe
    public void channelRender(MENetworkChannelsChanged c) {
        this.recalculateDisplay();
    }

    public IMEMonitor getItemInventory() {
        return this.itemCell;
    }

    public IMEMonitor getFluidInventory() {
        return this.fluidCell;
    }

    @Override
    public IInventory getInternalInventory() {
        return this.inv;
    }

    @Override
    public void func_70299_a(int i, ItemStack itemstack) {
        this.inv.func_70299_a(i, itemstack);
        this.tryToStoreContents();
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        if (slot == 1) {
            this.itemCell = null;
            this.fluidCell = null;
            this.isCached = false;
            try {
                this.gridProxy.getGrid().postEvent(new MENetworkCellArrayUpdate());
                IStorageGrid gs = this.gridProxy.getStorage();
                Platform.postChanges(gs, removed, added, this.mySrc);
            }
            catch (GridAccessException ignored) {
                // empty catch block
            }
            if (this.field_145850_b != null) {
                Platform.notifyBlocksOfNeighbors(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.markForUpdate();
            }
        }
    }

    @Override
    public boolean func_102007_a(int slotIndex, ItemStack insertingItem, int side) {
        if (slotIndex == 1) {
            if (AEApi.instance().registries().cell().getCellInventory(insertingItem, this, StorageChannel.ITEMS) != null) {
                return true;
            }
            if (AEApi.instance().registries().cell().getCellInventory(insertingItem, this, StorageChannel.FLUIDS) != null) {
                return true;
            }
        } else {
            try {
                IMEInventoryHandler cell = this.getHandler(StorageChannel.ITEMS);
                IAEItemStack returns = cell.injectItems(AEApi.instance().storage().createItemStack(this.inv.func_70301_a(0)), Actionable.SIMULATE, this.mySrc);
                return returns == null || returns.getStackSize() != (long)insertingItem.field_77994_a;
            }
            catch (ChestNoHandler ignored) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public boolean func_102008_b(int slotIndex, ItemStack extractedItem, int side) {
        return slotIndex == 1;
    }

    @Override
    public int[] getAccessibleSlotsBySide(ForgeDirection side) {
        if (ForgeDirection.SOUTH == side) {
            return FRONT;
        }
        if (this.isPowered()) {
            try {
                if (this.getHandler(StorageChannel.ITEMS) != null) {
                    return SIDES;
                }
            }
            catch (ChestNoHandler chestNoHandler) {
                // empty catch block
            }
        }
        return NO_SLOTS;
    }

    private void tryToStoreContents() {
        try {
            if (this.func_70301_a(0) != null) {
                IMEInventoryHandler cell = this.getHandler(StorageChannel.ITEMS);
                IAEItemStack returns = Platform.poweredInsert(this, cell, AEApi.instance().storage().createItemStack(this.inv.func_70301_a(0)), this.mySrc);
                if (returns == null) {
                    this.inv.func_70299_a(0, null);
                } else {
                    this.inv.func_70299_a(0, returns.getItemStack());
                }
            }
        }
        catch (ChestNoHandler chestNoHandler) {
            // empty catch block
        }
    }

    @Override
    public List<IMEInventoryHandler> getCellArray(StorageChannel channel) {
        if (this.gridProxy.isActive()) {
            try {
                return Collections.singletonList(this.getHandler(channel));
            }
            catch (ChestNoHandler chestNoHandler) {
                // empty catch block
            }
        }
        return new ArrayList<IMEInventoryHandler>();
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int newValue) {
        this.priority = newValue;
        this.itemCell = null;
        this.fluidCell = null;
        this.isCached = false;
        try {
            this.gridProxy.getGrid().postEvent(new MENetworkCellArrayUpdate());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    @Override
    public void blinkCell(int slot) {
        long now = this.field_145850_b.func_82737_E();
        if (now - this.lastStateChange > 8L) {
            this.state = 0;
        }
        this.lastStateChange = now;
        this.state |= 1 << slot * 3 + 2;
        this.recalculateDisplay();
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        double req = (double)resource.amount / 500.0;
        double available = this.extractAEPower(req, Actionable.SIMULATE, PowerMultiplier.CONFIG);
        if (available >= req - 0.01) {
            try {
                IMEInventoryHandler h = this.getHandler(StorageChannel.FLUIDS);
                this.extractAEPower(req, Actionable.MODULATE, PowerMultiplier.CONFIG);
                AEFluidStack results = h.injectItems(AEFluidStack.create(resource), doFill ? Actionable.MODULATE : Actionable.SIMULATE, this.mySrc);
                if (results == null) {
                    return resource.amount;
                }
                return resource.amount - (int)results.getStackSize();
            }
            catch (ChestNoHandler ignored) {
                // empty catch block
            }
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        try {
            IMEInventoryHandler h = this.getHandler(StorageChannel.FLUIDS);
            return h.canAccept(AEFluidStack.create(new FluidStack(fluid, 1)));
        }
        catch (ChestNoHandler chestNoHandler) {
            return false;
        }
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        try {
            IMEInventoryHandler h = this.getHandler(StorageChannel.FLUIDS);
            if (h.getChannel() == StorageChannel.FLUIDS) {
                return new FluidTankInfo[]{new FluidTankInfo(null, 1)};
            }
        }
        catch (ChestNoHandler chestNoHandler) {
            // empty catch block
        }
        return null;
    }

    @Override
    public IStorageMonitorable getMonitorable(ForgeDirection side, BaseActionSource src) {
        if (Platform.canAccess(this.gridProxy, src) && side != this.getForward()) {
            return this;
        }
        return null;
    }

    public ItemStack getStorageType() {
        if (this.isPowered()) {
            return this.storageType;
        }
        return null;
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.config;
    }

    @Override
    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
    }

    public boolean openGui(EntityPlayer p, ICellHandler ch, ItemStack cell, int side) {
        IMEInventoryHandler invHandler;
        try {
            invHandler = this.getHandler(StorageChannel.ITEMS);
            if (ch != null && invHandler != null) {
                ch.openChestGui(p, this, ch, invHandler, cell, StorageChannel.ITEMS);
                return true;
            }
        }
        catch (ChestNoHandler e) {
            // empty catch block
        }
        try {
            invHandler = this.getHandler(StorageChannel.FLUIDS);
            if (ch != null && invHandler != null) {
                ch.openChestGui(p, this, ch, invHandler, cell, StorageChannel.FLUIDS);
                return true;
            }
        }
        catch (ChestNoHandler e) {
            // empty catch block
        }
        return false;
    }

    @Override
    public AEColor getColor() {
        return this.paintedColor;
    }

    @Override
    public boolean recolourBlock(ForgeDirection side, AEColor newPaintedColor, EntityPlayer who) {
        if (this.paintedColor == newPaintedColor) {
            return false;
        }
        this.paintedColor = newPaintedColor;
        this.func_70296_d();
        this.markForUpdate();
        return true;
    }

    @Override
    public void saveChanges(IMEInventory cellInventory) {
        this.field_145850_b.func_147476_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (TileEntity)this);
    }

    class ChestMonitorHandler<T extends IAEStack>
    extends MEMonitorHandler<T> {
        public ChestMonitorHandler(IMEInventoryHandler<T> t) {
            super(t);
        }

        public IMEInventoryHandler<T> getInternalHandler() {
            IMEInventoryHandler h = this.getHandler();
            if (h instanceof MEInventoryHandler) {
                return (IMEInventoryHandler)((MEInventoryHandler)h).getInternal();
            }
            return this.getHandler();
        }

        @Override
        public T injectItems(T input, Actionable mode, BaseActionSource src) {
            if (src.isPlayer() && !this.securityCheck(((PlayerSource)src).player, SecurityPermissions.INJECT)) {
                return input;
            }
            return super.injectItems(input, mode, src);
        }

        private boolean securityCheck(EntityPlayer player, SecurityPermissions requiredPermission) {
            if (TileChest.this.getTile() instanceof IActionHost && requiredPermission != null) {
                IGrid g;
                boolean requirePower = false;
                IGridNode gn = ((IActionHost)TileChest.this.getTile()).getActionableNode();
                if (gn != null && (g = gn.getGrid()) != null) {
                    IEnergyGrid eg;
                    if (requirePower && !(eg = (IEnergyGrid)g.getCache(IEnergyGrid.class)).isNetworkPowered()) {
                        return false;
                    }
                    ISecurityGrid sg = (ISecurityGrid)g.getCache(ISecurityGrid.class);
                    if (sg.hasPermission(player, requiredPermission)) {
                        return true;
                    }
                }
                return false;
            }
            return true;
        }

        @Override
        public T extractItems(T request, Actionable mode, BaseActionSource src) {
            if (src.isPlayer() && !this.securityCheck(((PlayerSource)src).player, SecurityPermissions.EXTRACT)) {
                return null;
            }
            return super.extractItems(request, mode, src);
        }
    }

    class ChestNetNotifier<T extends IAEStack<T>>
    implements IMEMonitorHandlerReceiver<T> {
        final StorageChannel chan;

        public ChestNetNotifier(StorageChannel chan) {
            this.chan = chan;
        }

        @Override
        public boolean isValid(Object verificationToken) {
            if (this.chan == StorageChannel.ITEMS) {
                return verificationToken == TileChest.this.itemCell;
            }
            if (this.chan == StorageChannel.FLUIDS) {
                return verificationToken == TileChest.this.fluidCell;
            }
            return false;
        }

        @Override
        public void postChange(IBaseMonitor<T> monitor, Iterable<T> change, BaseActionSource source) {
            if (source == TileChest.this.mySrc || source instanceof PlayerSource && ((PlayerSource)source).via == TileChest.this) {
                try {
                    if (TileChest.this.gridProxy.isActive()) {
                        TileChest.this.gridProxy.getStorage().postAlterationOfStoredItems(this.chan, change, TileChest.this.mySrc);
                    }
                }
                catch (GridAccessException e) {
                    // empty catch block
                }
            }
            TileChest.this.blinkCell(0);
        }

        @Override
        public void onListUpdate() {
        }
    }

    private static class ChestNoHandler
    extends Exception {
        private static final long serialVersionUID = 7995805326136526631L;

        private ChestNoHandler() {
        }
    }
}

