/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import jds.bibliocraft.BiblioCraft;
import jds.bibliocraft.ClientProxy;
import jds.bibliocraft.blocks.BlockLoader;
import jds.bibliocraft.items.ItemDrill;
import jds.bibliocraft.items.ItemLock;
import jds.bibliocraft.tileentities.TileEntityFramedChest;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockFramedChest
extends BlockContainer {
    public int angle;
    public String customTexture = "none";

    public BlockFramedChest() {
        super(Material.field_151575_d);
        this.func_149672_a(Block.field_149766_f);
        this.func_149647_a(BlockLoader.biblioTab);
    }

    public boolean func_149727_a(World world, int i, int j, int k, EntityPlayer player, int face, float hitX, float hitY, float hitZ) {
        TileEntityFramedChest chest = (TileEntityFramedChest)world.func_147438_o(i, j, k);
        if (chest == null) {
            return false;
        }
        String playername = player.getDisplayName();
        boolean islocked = chest.isLocked();
        String lockeename = chest.getLockee();
        if (!world.field_72995_K) {
            ItemStack playerItem = player.func_70694_bm();
            if (playerItem != null) {
                if (playerItem.func_77973_b() instanceof ItemLock && chest != null) {
                    if (islocked) {
                        if (playername.contains(lockeename)) {
                            chest.setLocked(false);
                            player.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"lock.unlocked")));
                        } else {
                            player.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"lock.notowner")));
                        }
                    } else {
                        chest.setLocked(true);
                        chest.setLockee(playername);
                        player.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"lock.locked")));
                    }
                    return true;
                }
                if (playerItem.func_77973_b() instanceof ItemDrill) {
                    return false;
                }
            }
            if (!islocked || playername.contains(lockeename)) {
                TileEntityFramedChest chest2;
                if (chest.getIsDouble() && (chest2 = this.getAdjacentChest(chest, world)) != null) {
                    chest.setAdjacentChest(chest2);
                    chest2.setAdjacentChest(chest);
                    chest2.addUsingPlayer(true);
                }
                chest.addUsingPlayer(true);
                player.openGui((Object)BiblioCraft.instance, 0, world, i, j, k);
                return true;
            }
            player.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"lock.notowner")));
        }
        return true;
    }

    public TileEntityFramedChest getAdjacentChest(TileEntityFramedChest chest, World world) {
        TileEntityFramedChest chest2;
        TileEntity tile = null;
        switch (chest.getAngle()) {
            case 0: {
                if (chest.getIsLeft()) {
                    tile = world.func_147438_o(chest.field_145851_c, chest.field_145848_d, chest.field_145849_e + 1);
                    break;
                }
                tile = world.func_147438_o(chest.field_145851_c, chest.field_145848_d, chest.field_145849_e - 1);
                break;
            }
            case 1: {
                if (chest.getIsLeft()) {
                    tile = world.func_147438_o(chest.field_145851_c - 1, chest.field_145848_d, chest.field_145849_e);
                    break;
                }
                tile = world.func_147438_o(chest.field_145851_c + 1, chest.field_145848_d, chest.field_145849_e);
                break;
            }
            case 2: {
                if (chest.getIsLeft()) {
                    tile = world.func_147438_o(chest.field_145851_c, chest.field_145848_d, chest.field_145849_e - 1);
                    break;
                }
                tile = world.func_147438_o(chest.field_145851_c, chest.field_145848_d, chest.field_145849_e + 1);
                break;
            }
            case 3: {
                tile = chest.getIsLeft() ? world.func_147438_o(chest.field_145851_c + 1, chest.field_145848_d, chest.field_145849_e) : world.func_147438_o(chest.field_145851_c - 1, chest.field_145848_d, chest.field_145849_e);
            }
        }
        if (tile != null && tile instanceof TileEntityFramedChest && (chest2 = (TileEntityFramedChest)tile).getIsDouble()) {
            return chest2;
        }
        return null;
    }

    public void func_149725_f(World world, int x, int y, int z, int meta) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TileEntityFramedChest) {
            TileEntityFramedChest bookcase = (TileEntityFramedChest)tile;
            this.customTexture = bookcase.getCustomTexString();
        }
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        int count = this.quantityDropped(metadata, fortune, world.field_73012_v);
        for (int i = 0; i < count; ++i) {
            Item item = this.func_149650_a(metadata, world.field_73012_v, fortune);
            if (item == null) continue;
            ItemStack newStack = new ItemStack(item, 1, this.func_149692_a(metadata));
            if (!this.customTexture.contentEquals("none") && !this.customTexture.contentEquals("")) {
                NBTTagCompound tags = new NBTTagCompound();
                tags.func_74778_a("renderTexture", this.customTexture);
                newStack.func_77982_d(tags);
            }
            ret.add(newStack);
        }
        return ret;
    }

    public float func_149712_f(World world, int i, int j, int k) {
        TileEntityFramedChest tilee;
        TileEntity tile = world.func_147438_o(i, j, k);
        if (tile != null && tile instanceof TileEntityFramedChest && (tilee = (TileEntityFramedChest)tile).isLocked()) {
            return -1.0f;
        }
        return 3.0f;
    }

    public void func_149651_a(IIconRegister par1IconRegister) {
        this.field_149761_L = par1IconRegister.func_94245_a("planks_spruce");
    }

    public int func_149692_a(int metadata) {
        return metadata;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item par1, CreativeTabs tab, List subItems) {
        subItems.add(new ItemStack(par1, 1, 0));
    }

    public void func_149719_a(IBlockAccess blockAccess, int i, int j, int k) {
        TileEntityFramedChest chest;
        TileEntity tile = blockAccess.func_147438_o(i, j, k);
        if (tile != null && tile instanceof TileEntityFramedChest && (chest = (TileEntityFramedChest)tile).getIsDouble()) {
            switch (chest.getAngle()) {
                case 0: {
                    if (chest.getIsLeft()) {
                        this.func_149676_a(0.054f, 0.0f, 0.054f, 0.946f, 0.866f, 1.0f);
                    } else {
                        this.func_149676_a(0.054f, 0.0f, 0.0f, 0.946f, 0.866f, 0.946f);
                    }
                    return;
                }
                case 1: {
                    if (chest.getIsLeft()) {
                        this.func_149676_a(0.0f, 0.0f, 0.054f, 0.946f, 0.866f, 0.946f);
                    } else {
                        this.func_149676_a(0.054f, 0.0f, 0.054f, 1.0f, 0.866f, 0.946f);
                    }
                    return;
                }
                case 2: {
                    if (chest.getIsLeft()) {
                        this.func_149676_a(0.054f, 0.0f, 0.0f, 0.946f, 0.866f, 0.946f);
                    } else {
                        this.func_149676_a(0.054f, 0.0f, 0.054f, 0.946f, 0.866f, 1.0f);
                    }
                    return;
                }
                case 3: {
                    if (chest.getIsLeft()) {
                        this.func_149676_a(0.054f, 0.0f, 0.054f, 1.0f, 0.866f, 0.946f);
                    } else {
                        this.func_149676_a(0.0f, 0.0f, 0.054f, 0.946f, 0.866f, 0.946f);
                    }
                    return;
                }
            }
        }
        this.func_149676_a(0.054f, 0.0f, 0.054f, 0.946f, 0.866f, 0.946f);
    }

    public void func_149743_a(World par1World, int par2, int par3, int par4, AxisAlignedBB par5AxisAlignedBB, List par6List, Entity par7Entity) {
        this.func_149719_a((IBlockAccess)par1World, par2, par3, par4);
        super.func_149743_a(par1World, par2, par3, par4, par5AxisAlignedBB, par6List, par7Entity);
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149645_b() {
        return ClientProxy.chestrenderID;
    }

    public void func_149689_a(World world, int i, int j, int k, EntityLivingBase player, ItemStack itemStack) {
        int angler = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        ++angler;
        this.angle = angler %= 4;
        TileEntityFramedChest tileBookCase = (TileEntityFramedChest)world.func_147438_o(i, j, k);
        tileBookCase.setAngle(this.angle);
        NBTTagCompound tags = itemStack.func_77978_p();
        if (tags != null && tags.func_74764_b("renderTexture")) {
            tileBookCase.setCustomTex(tags.func_74779_i("renderTexture"));
        }
    }

    public void func_149749_a(World world, int i, int j, int k, Block par5, int par6) {
        TileEntityFramedChest chest2;
        TileEntityFramedChest chest;
        this.dropItems(world, i, j, k);
        TileEntity tile = world.func_147438_o(i, j, k);
        if (tile != null && tile instanceof TileEntityFramedChest && (chest = (TileEntityFramedChest)tile).getIsDouble() && (chest2 = this.getAdjacentChest(chest, world)) != null) {
            chest2.setIsDouble(false, true, null);
        }
        super.func_149749_a(world, i, j, k, par5, par6);
    }

    private void dropItems(World world, int i, int j, int k) {
        Random rando = new Random();
        TileEntity tileEntity = world.func_147438_o(i, j, k);
        if (!(tileEntity instanceof IInventory)) {
            return;
        }
        IInventory inventory = (IInventory)tileEntity;
        for (int x = 0; x < inventory.func_70302_i_(); ++x) {
            ItemStack item = inventory.func_70301_a(x);
            if (item == null || item.field_77994_a <= 0) continue;
            float ri = rando.nextFloat() * 0.8f + 0.1f;
            float rj = rando.nextFloat() * 0.8f + 0.1f;
            float rk = rando.nextFloat() * 0.8f + 0.1f;
            EntityItem entityItem = new EntityItem(world, (double)((float)i + ri), (double)((float)j + rj), (double)((float)k + rk), new ItemStack(item.func_77973_b(), item.field_77994_a, item.func_77960_j()));
            if (item.func_77942_o()) {
                entityItem.func_92059_d().func_77982_d((NBTTagCompound)item.func_77978_p().func_74737_b());
            }
            float factor = 0.05f;
            entityItem.field_70159_w = rando.nextGaussian() * (double)factor;
            entityItem.field_70181_x = rando.nextGaussian() * (double)factor + (double)0.2f;
            entityItem.field_70179_y = rando.nextGaussian() * (double)factor;
            world.func_72838_d((Entity)entityItem);
            item.field_77994_a = 0;
        }
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public TileEntity func_149915_a(World world, int var2) {
        try {
            return new TileEntityFramedChest();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TileEntityFramedChest) {
            TileEntityFramedChest te = (TileEntityFramedChest)tile;
            int angle = te.getAngle();
            switch (axis) {
                case DOWN: {
                    if (angle <= 0) {
                        te.setAngle(3);
                        break;
                    }
                    te.setAngle(angle - 1);
                    break;
                }
                case UP: {
                    if (angle >= 3) {
                        te.setAngle(0);
                        break;
                    }
                    te.setAngle(angle + 1);
                    break;
                }
                case UNKNOWN: {
                    return false;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public ForgeDirection[] getValidRotations(World worldObj, int x, int y, int z) {
        ForgeDirection[] axises = new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.DOWN};
        return axises;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        TileEntityFramedChest tile;
        String customTexture;
        Item item = this.func_149694_d(world, x, y, z);
        if (item == null) {
            return null;
        }
        BlockFramedChest block = item instanceof ItemBlock && !this.func_149648_K() ? Block.func_149634_a((Item)item) : this;
        ItemStack stack = new ItemStack(item, 1, block.func_149643_k(world, x, y, z));
        TileEntity wtile = world.func_147438_o(x, y, z);
        if (!(wtile == null || !(wtile instanceof TileEntityFramedChest) || (customTexture = (tile = (TileEntityFramedChest)wtile).getCustomTexString()).equals("none") && customTexture.equals(""))) {
            NBTTagCompound tags = new NBTTagCompound();
            tags.func_74778_a("renderTexture", customTexture);
            stack.func_77982_d(tags);
        }
        return stack;
    }
}

