/*
 * Decompiled with CFR 0.152.
 */
package main.ironbackpacks.events;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import main.ironbackpacks.IronBackpacks;
import main.ironbackpacks.container.backpack.ContainerBackpack;
import main.ironbackpacks.container.backpack.InventoryBackpack;
import main.ironbackpacks.handlers.ConfigHandler;
import main.ironbackpacks.items.backpacks.BackpackTypes;
import main.ironbackpacks.items.backpacks.IBackpack;
import main.ironbackpacks.items.backpacks.ItemBackpack;
import main.ironbackpacks.items.upgrades.UpgradeMethods;
import main.ironbackpacks.util.IronBackpacksHelper;
import main.ironbackpacks.util.Logger;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerWorkbench;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerUseItemEvent;
import net.minecraftforge.oredict.OreDictionary;

public class ForgeEventHandler {
    @SubscribeEvent
    public void onItemPickupEvent(EntityItemPickupEvent event) {
        if (event.isCanceled()) {
            return;
        }
        ArrayList<ArrayList<ItemStack>> backpacks = this.getFilterCondenserAndHopperBackpacks(event.entityPlayer);
        boolean doFilter = this.checkHopperUpgradeItemPickup(event, backpacks.get(4));
        if (doFilter) {
            this.checkFilterUpgrade(event, backpacks.get(0));
        }
        for (int i = 1; i < 4; ++i) {
            this.checkCondenserUpgrade(event, backpacks.get(i), i);
        }
    }

    @SubscribeEvent
    public void onPlayerItemUseEvent(PlayerUseItemEvent.Finish event) {
        ArrayList<ArrayList<ItemStack>> backpacks;
        ItemStack resuppliedStack = null;
        if (!event.isCanceled() && (resuppliedStack = this.checkHopperUpgradeItemUse(event, (backpacks = this.getFilterCondenserAndHopperBackpacks(event.entityPlayer)).get(2))) != null) {
            event.result = resuppliedStack;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onDeath(LivingDeathEvent event) {
        if (!event.entity.field_70170_p.field_72995_K && event.entity instanceof EntityPlayer) {
            IronBackpacks.proxy.saveBackpackOnDeath((EntityPlayer)event.entity);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (!event.entity.field_70170_p.field_72995_K && event.entity instanceof EntityPlayer) {
            IronBackpacks.proxy.loadBackpackOnDeath((EntityPlayer)event.entity);
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals("ironbackpacks")) {
            ConfigHandler.syncConfig(false);
            Logger.info("Refreshing configuration file.");
        }
    }

    private ArrayList<ArrayList<ItemStack>> getFilterCondenserAndHopperBackpacks(EntityPlayer player) {
        ArrayList<ItemStack> filterBackpacks = new ArrayList<ItemStack>();
        ArrayList<ItemStack> condenserTinyBackpacks = new ArrayList<ItemStack>();
        ArrayList<ItemStack> condenserSmallBackpacks = new ArrayList<ItemStack>();
        ArrayList<ItemStack> condenserBackpacks = new ArrayList<ItemStack>();
        ArrayList<ItemStack> hopperBackpacks = new ArrayList<ItemStack>();
        ArrayList<ArrayList<ItemStack>> returnArray = new ArrayList<ArrayList<ItemStack>>();
        this.getEventBackpacks(IronBackpacks.proxy.getEquippedBackpack(player), filterBackpacks, condenserTinyBackpacks, condenserSmallBackpacks, condenserBackpacks, hopperBackpacks, player);
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            this.getEventBackpacks(stack, filterBackpacks, condenserTinyBackpacks, condenserSmallBackpacks, condenserBackpacks, hopperBackpacks, player);
        }
        returnArray.add(filterBackpacks);
        returnArray.add(condenserTinyBackpacks);
        returnArray.add(condenserSmallBackpacks);
        returnArray.add(condenserBackpacks);
        returnArray.add(hopperBackpacks);
        return returnArray;
    }

    private void getEventBackpacks(ItemStack backpack, ArrayList<ItemStack> filterBackpacks, ArrayList<ItemStack> condenserTinyBackpacks, ArrayList<ItemStack> condenserSmallBackpacks, ArrayList<ItemStack> condenserBackpacks, ArrayList<ItemStack> hopperBackpacks, EntityPlayer player) {
        if (backpack != null && backpack.func_77973_b() != null && backpack.func_77973_b() instanceof IBackpack) {
            int[] upgrades = IronBackpacksHelper.getUpgradesAppliedFromNBT(backpack);
            this.addToLists(backpack, filterBackpacks, condenserTinyBackpacks, condenserSmallBackpacks, condenserBackpacks, hopperBackpacks, upgrades);
            if (UpgradeMethods.hasDepthUpgrade(upgrades)) {
                ItemBackpack itemBackpack = (ItemBackpack)backpack.func_77973_b();
                ContainerBackpack container = new ContainerBackpack(player, new InventoryBackpack(player, backpack, BackpackTypes.values()[itemBackpack.getId() - 1]), BackpackTypes.values()[itemBackpack.getId() - 1]);
                for (int j = 0; j < container.getInventoryBackpack().func_70302_i_(); ++j) {
                    ItemStack nestedBackpack = container.getInventoryBackpack().func_70301_a(j);
                    if (nestedBackpack == null || nestedBackpack.func_77973_b() == null || !(nestedBackpack.func_77973_b() instanceof IBackpack)) continue;
                    this.addToLists(nestedBackpack, filterBackpacks, condenserTinyBackpacks, condenserSmallBackpacks, condenserBackpacks, hopperBackpacks, IronBackpacksHelper.getUpgradesAppliedFromNBT(nestedBackpack));
                }
            }
        }
    }

    private void addToLists(ItemStack stack, ArrayList<ItemStack> filterBackpacks, ArrayList<ItemStack> condenserTinyBackpacks, ArrayList<ItemStack> condenserSmallBackpacks, ArrayList<ItemStack> condenserBackpacks, ArrayList<ItemStack> hopperBackpacks, int[] upgrades) {
        if (UpgradeMethods.hasFilterBasicUpgrade(upgrades) || UpgradeMethods.hasFilterModSpecificUpgrade(upgrades) || UpgradeMethods.hasFilterFuzzyUpgrade(upgrades) || UpgradeMethods.hasFilterOreDictUpgrade(upgrades) || UpgradeMethods.hasFilterAdvancedUpgrade(upgrades) || UpgradeMethods.hasFilterMiningUpgrade(upgrades)) {
            filterBackpacks.add(stack);
        }
        if (UpgradeMethods.hasCondenserTinyUpgrade(upgrades)) {
            condenserTinyBackpacks.add(stack);
        }
        if (UpgradeMethods.hasCondenserSmallUpgrade(upgrades)) {
            condenserSmallBackpacks.add(stack);
        }
        if (UpgradeMethods.hasCondenserUpgrade(upgrades)) {
            condenserBackpacks.add(stack);
        }
        if (UpgradeMethods.hasHopperUpgrade(upgrades)) {
            hopperBackpacks.add(stack);
        }
    }

    private boolean checkHopperUpgradeItemPickup(EntityItemPickupEvent event, ArrayList<ItemStack> backpackStacks) {
        boolean doFilter = true;
        boolean shouldSave = false;
        if (!backpackStacks.isEmpty()) {
            for (ItemStack backpack : backpackStacks) {
                shouldSave = false;
                BackpackTypes type = BackpackTypes.values()[((ItemBackpack)backpack.func_77973_b()).getGuiId()];
                ContainerBackpack container = new ContainerBackpack(event.entityPlayer, new InventoryBackpack(event.entityPlayer, backpack, type), type);
                if (!(event.entityPlayer.field_71070_bA instanceof ContainerBackpack)) {
                    container.sort();
                    ArrayList<ItemStack> hopperItems = UpgradeMethods.getHopperItems(backpack);
                    block1: for (ItemStack hopperItem : hopperItems) {
                        if (hopperItem == null) continue;
                        boolean foundSlot = false;
                        ItemStack stackToResupply = null;
                        Slot slotToResupply = null;
                        for (int i = type.getSize(); i < type.getSize() + 36; ++i) {
                            ItemStack tempItem;
                            Slot tempSlot = container.func_75139_a(i);
                            if (tempSlot == null || !tempSlot.func_75216_d() || !IronBackpacksHelper.areItemsEqualAndStackable(tempItem = tempSlot.func_75211_c(), hopperItem)) continue;
                            foundSlot = true;
                            slotToResupply = tempSlot;
                            stackToResupply = tempItem;
                            break;
                        }
                        if (!foundSlot) continue;
                        boolean done = false;
                        if (IronBackpacksHelper.areItemsEqualForStacking(event.item.func_92059_d(), stackToResupply)) {
                            int amountToResupply = stackToResupply.func_77976_d() - stackToResupply.field_77994_a;
                            if (event.item.func_92059_d().field_77994_a >= amountToResupply) {
                                event.item.func_92058_a(new ItemStack(event.item.func_92059_d().func_77973_b(), event.item.func_92059_d().field_77994_a - amountToResupply, event.item.func_92059_d().func_77960_j()));
                                slotToResupply.func_75215_d(new ItemStack(stackToResupply.func_77973_b(), stackToResupply.func_77976_d(), stackToResupply.func_77960_j()));
                                done = true;
                                shouldSave = true;
                            } else {
                                doFilter = false;
                            }
                        }
                        if (done) continue;
                        for (int i = 0; i < type.getSize(); ++i) {
                            int amountToResupply;
                            ItemStack tempItem;
                            Slot tempSlot = container.func_75139_a(i);
                            if (tempSlot == null || !tempSlot.func_75216_d() || !IronBackpacksHelper.areItemsEqualForStacking(tempItem = tempSlot.func_75211_c(), stackToResupply)) continue;
                            if (IronBackpacksHelper.areItemsEqualForStacking(event.item.func_92059_d(), stackToResupply)) {
                                amountToResupply = stackToResupply.func_77976_d() - stackToResupply.field_77994_a - event.item.func_92059_d().field_77994_a;
                                if (tempItem.field_77994_a >= amountToResupply) {
                                    tempSlot.func_75209_a(amountToResupply);
                                    slotToResupply.func_75215_d(new ItemStack(stackToResupply.func_77973_b(), stackToResupply.func_77976_d() - event.item.func_92059_d().field_77994_a, stackToResupply.func_77960_j()));
                                    container.sort();
                                    container.func_75134_a(event.entityPlayer);
                                    continue block1;
                                }
                                tempSlot.func_75209_a(tempItem.field_77994_a);
                                slotToResupply.func_75215_d(new ItemStack(stackToResupply.func_77973_b(), stackToResupply.field_77994_a + tempItem.field_77994_a, stackToResupply.func_77960_j()));
                            } else {
                                amountToResupply = stackToResupply.func_77976_d() - stackToResupply.field_77994_a;
                                if (tempItem.field_77994_a >= amountToResupply) {
                                    tempSlot.func_75209_a(amountToResupply);
                                    slotToResupply.func_75215_d(new ItemStack(stackToResupply.func_77973_b(), stackToResupply.func_77976_d(), stackToResupply.func_77960_j()));
                                    container.sort();
                                    container.func_75134_a(event.entityPlayer);
                                    continue block1;
                                }
                                tempSlot.func_75209_a(tempItem.field_77994_a);
                                slotToResupply.func_75215_d(new ItemStack(stackToResupply.func_77973_b(), stackToResupply.field_77994_a + tempItem.field_77994_a, stackToResupply.func_77960_j()));
                            }
                            shouldSave = true;
                        }
                    }
                }
                if (!shouldSave) continue;
                container.sort();
                container.func_75134_a(event.entityPlayer);
                shouldSave = false;
            }
        }
        return doFilter;
    }

    private ItemStack checkHopperUpgradeItemUse(PlayerUseItemEvent.Finish event, ArrayList<ItemStack> backpackStacks) {
        if (!backpackStacks.isEmpty()) {
            for (ItemStack backpack : backpackStacks) {
                BackpackTypes type = BackpackTypes.values()[((ItemBackpack)backpack.func_77973_b()).getGuiId()];
                ContainerBackpack container = new ContainerBackpack(event.entityPlayer, new InventoryBackpack(event.entityPlayer, backpack, type), type);
                if (event.entityPlayer.field_71070_bA instanceof ContainerBackpack) continue;
                container.sort();
                ArrayList<ItemStack> hopperItems = UpgradeMethods.getHopperItems(backpack);
                for (ItemStack hopperItem : hopperItems) {
                    int i;
                    if (hopperItem == null) continue;
                    boolean foundSlot = false;
                    ItemStack stackToResupply = null;
                    Slot slotToResupply = null;
                    for (i = type.getSize(); i < type.getSize() + 36; ++i) {
                        Slot tempSlot = container.func_75139_a(i);
                        if (tempSlot == null || !tempSlot.func_75216_d()) continue;
                        ItemStack tempItem = tempSlot.func_75211_c();
                        if (!IronBackpacksHelper.areItemsEqualForStacking(event.item, hopperItem) || !IronBackpacksHelper.areItemsEqualAndStackable(tempItem, hopperItem)) continue;
                        foundSlot = true;
                        slotToResupply = tempSlot;
                        stackToResupply = tempItem;
                        break;
                    }
                    if (!foundSlot) continue;
                    for (i = 0; i < type.getSize(); ++i) {
                        ItemStack backpackItemStack;
                        Slot backpackSlot = container.func_75139_a(i);
                        if (backpackSlot == null || !backpackSlot.func_75216_d() || !IronBackpacksHelper.areItemsEqualForStacking(stackToResupply, backpackItemStack = backpackSlot.func_75211_c())) continue;
                        int amountToResupply = stackToResupply.func_77976_d() - stackToResupply.field_77994_a;
                        if (backpackItemStack.field_77994_a >= amountToResupply) {
                            backpackSlot.func_75209_a(amountToResupply);
                            container.sort();
                            container.func_75134_a(event.entityPlayer);
                            return new ItemStack(stackToResupply.func_77973_b(), stackToResupply.func_77976_d(), stackToResupply.func_77960_j());
                        }
                        backpackSlot.func_75209_a(backpackItemStack.field_77994_a);
                        container.sort();
                        container.func_75134_a(event.entityPlayer);
                        return new ItemStack(stackToResupply.func_77973_b(), stackToResupply.field_77994_a + backpackItemStack.field_77994_a, stackToResupply.func_77960_j());
                    }
                }
            }
        }
        return null;
    }

    private void checkCondenserUpgrade(EntityItemPickupEvent event, ArrayList<ItemStack> backpackStacks, int craftingGridDiameterToFill) {
        boolean shouldSave = false;
        if (!backpackStacks.isEmpty()) {
            CraftingManager craftingManager = CraftingManager.func_77594_a();
            for (ItemStack backpack : backpackStacks) {
                ArrayList<ItemStack> condenserItems;
                shouldSave = false;
                if (event.entityPlayer.field_71070_bA instanceof ContainerBackpack) continue;
                BackpackTypes type = BackpackTypes.values()[((ItemBackpack)backpack.func_77973_b()).getGuiId()];
                ContainerBackpack container = new ContainerBackpack(event.entityPlayer, new InventoryBackpack(event.entityPlayer, backpack, type), type);
                container.sort();
                if (container.getInventoryBackpack().func_70301_a(container.getInventoryBackpack().func_70302_i_()) != null) break;
                ContainerWorkbench containerWorkbench = new ContainerWorkbench(event.entityPlayer.field_71071_by, event.item.field_70170_p, 0, 0, 0);
                InventoryCrafting inventoryCrafting = new InventoryCrafting((Container)containerWorkbench, 3, 3);
                switch (craftingGridDiameterToFill) {
                    case 1: {
                        condenserItems = UpgradeMethods.getCondenserTinyItems(backpack);
                        break;
                    }
                    case 2: {
                        condenserItems = UpgradeMethods.getCondenserSmallItems(backpack);
                        break;
                    }
                    case 3: {
                        condenserItems = UpgradeMethods.getCondenserItems(backpack);
                        break;
                    }
                    default: {
                        condenserItems = UpgradeMethods.getCondenserItems(backpack);
                        Logger.error("IronBackpacks CraftingUpgrade Error, will probably give the wrong output");
                    }
                }
                for (ItemStack condenserItem : condenserItems) {
                    if (condenserItem == null) continue;
                    block7: for (int index = 0; index < type.getSize(); ++index) {
                        ItemStack theStack;
                        Slot theSlot = container.func_75139_a(index);
                        if (theSlot == null || !theSlot.func_75216_d() || (theStack = theSlot.func_75211_c()) == null || theStack.field_77994_a < craftingGridDiameterToFill * craftingGridDiameterToFill || !IronBackpacksHelper.areItemsEqualForStacking(theStack, condenserItem)) continue;
                        ItemStack myStack = new ItemStack(theStack.func_77973_b(), 1, theStack.func_77960_j());
                        if (craftingGridDiameterToFill == 2) {
                            inventoryCrafting.func_70299_a(0, myStack);
                            inventoryCrafting.func_70299_a(1, myStack);
                            inventoryCrafting.func_70299_a(3, myStack);
                            inventoryCrafting.func_70299_a(4, myStack);
                        } else {
                            for (int i = 0; i < craftingGridDiameterToFill * craftingGridDiameterToFill; ++i) {
                                inventoryCrafting.func_70299_a(i, myStack);
                            }
                        }
                        ItemStack recipeOutput = craftingManager.func_82787_a(inventoryCrafting, event.item.field_70170_p);
                        if (recipeOutput == null) continue;
                        shouldSave = true;
                        int numberOfIterations = (int)Math.floor(theStack.field_77994_a / (craftingGridDiameterToFill * craftingGridDiameterToFill));
                        int numberOfItems = recipeOutput.field_77994_a * numberOfIterations;
                        if (numberOfItems > 64) {
                            ItemStack myRecipeOutput;
                            ItemStack stack;
                            for (int i = 0; i < numberOfIterations && (stack = container.transferStackInSlot(myRecipeOutput = new ItemStack(recipeOutput.func_77973_b(), recipeOutput.field_77994_a, recipeOutput.func_77960_j()))) != null; ++i) {
                                if (stack.field_77994_a != 0) {
                                    Slot slot = container.func_75139_a(container.getType().getSize() - 1);
                                    slot.func_75215_d(new ItemStack(recipeOutput.func_77973_b(), recipeOutput.func_77976_d() - (recipeOutput.field_77994_a - stack.field_77994_a), recipeOutput.func_77960_j()));
                                    continue block7;
                                }
                                theSlot.func_75209_a(1);
                            }
                            continue;
                        }
                        ItemStack myRecipeOutput = new ItemStack(recipeOutput.func_77973_b(), numberOfItems, recipeOutput.func_77960_j());
                        if (container.transferStackInSlot(myRecipeOutput) != null) {
                            theSlot.func_75209_a(theStack.field_77994_a - theStack.field_77994_a % (craftingGridDiameterToFill * craftingGridDiameterToFill));
                        }
                        container.save(event.entityPlayer);
                    }
                }
                if (!shouldSave) continue;
                container.sort();
                container.func_75134_a(event.entityPlayer);
            }
        }
    }

    private void checkFilterUpgrade(EntityItemPickupEvent event, ArrayList<ItemStack> backpackStacks) {
        if (!backpackStacks.isEmpty()) {
            for (ItemStack backpack : backpackStacks) {
                BackpackTypes type = BackpackTypes.values()[((ItemBackpack)backpack.func_77973_b()).getGuiId()];
                ContainerBackpack container = new ContainerBackpack(event.entityPlayer, new InventoryBackpack(event.entityPlayer, backpack, type), type);
                if (event.entityPlayer.field_71070_bA instanceof ContainerBackpack) continue;
                int[] upgrades = IronBackpacksHelper.getUpgradesAppliedFromNBT(backpack);
                if (UpgradeMethods.hasFilterBasicUpgrade(upgrades)) {
                    this.transferWithBasicFilter(UpgradeMethods.getBasicFilterItems(backpack), event, container);
                }
                if (UpgradeMethods.hasFilterModSpecificUpgrade(upgrades)) {
                    this.transferWithModSpecificFilter(UpgradeMethods.getModSpecificFilterItems(backpack), event, container);
                }
                if (UpgradeMethods.hasFilterFuzzyUpgrade(upgrades)) {
                    this.transferWithFuzzyFilter(UpgradeMethods.getFuzzyFilterItems(backpack), event, container);
                }
                if (UpgradeMethods.hasFilterOreDictUpgrade(upgrades)) {
                    this.transferWithOreDictFilter(UpgradeMethods.getOreDictFilterItems(backpack), this.getOreDict(event.item.func_92059_d()), event, container);
                }
                if (UpgradeMethods.hasFilterAdvancedUpgrade(upgrades)) {
                    ItemStack[] advFilterItems = UpgradeMethods.getAdvFilterAllItems(backpack);
                    byte[] advFilterButtonStates = UpgradeMethods.getAdvFilterButtonStates(backpack);
                    this.transferWithBasicFilter(UpgradeMethods.getAdvFilterBasicItems(advFilterItems, advFilterButtonStates), event, container);
                    this.transferWithModSpecificFilter(UpgradeMethods.getAdvFilterModSpecificItems(advFilterItems, advFilterButtonStates), event, container);
                    this.transferWithFuzzyFilter(UpgradeMethods.getAdvFilterFuzzyItems(advFilterItems, advFilterButtonStates), event, container);
                    this.transferWithOreDictFilter(UpgradeMethods.getAdvFilterOreDictItems(advFilterItems, advFilterButtonStates), this.getOreDict(event.item.func_92059_d()), event, container);
                }
                if (UpgradeMethods.hasFilterMiningUpgrade(upgrades)) {
                    this.transferWithMiningFilter(UpgradeMethods.getMiningFilterItems(backpack), this.getOreDict(event.item.func_92059_d()), event, container);
                }
                if (!UpgradeMethods.hasFilterVoidUpgrade(upgrades)) continue;
                this.deleteWithVoidFilter(UpgradeMethods.getVoidFilterItems(backpack), event);
            }
        }
    }

    private void transferWithBasicFilter(ArrayList<ItemStack> filterItems, EntityItemPickupEvent event, ContainerBackpack container) {
        boolean shouldSave = false;
        for (ItemStack filterItem : filterItems) {
            if (filterItem == null || !IronBackpacksHelper.areItemsEqualForStacking(event.item.func_92059_d(), filterItem)) continue;
            container.transferStackInSlot(event.item.func_92059_d());
            shouldSave = true;
        }
        if (shouldSave) {
            container.func_75134_a(event.entityPlayer);
        }
    }

    private void transferWithFuzzyFilter(ArrayList<ItemStack> filterItems, EntityItemPickupEvent event, ContainerBackpack container) {
        boolean shouldSave = false;
        for (ItemStack filterItem : filterItems) {
            if (filterItem == null || event.item.func_92059_d().func_77973_b() != filterItem.func_77973_b()) continue;
            container.transferStackInSlot(event.item.func_92059_d());
            shouldSave = true;
        }
        if (shouldSave) {
            container.func_75134_a(event.entityPlayer);
        }
    }

    private void transferWithOreDictFilter(ArrayList<ItemStack> filterItems, ArrayList<String> itemEntityOre, EntityItemPickupEvent event, ContainerBackpack container) {
        boolean shouldSave = false;
        for (ItemStack filterItem : filterItems) {
            if (filterItem == null) continue;
            ArrayList<String> filterItemOre = this.getOreDict(filterItem);
            if (itemEntityOre == null || filterItemOre == null) continue;
            for (String oreName : itemEntityOre) {
                if (oreName == null || !filterItemOre.contains(oreName)) continue;
                container.transferStackInSlot(event.item.func_92059_d());
                shouldSave = true;
            }
        }
        if (shouldSave) {
            container.func_75134_a(event.entityPlayer);
        }
    }

    private void transferWithModSpecificFilter(ArrayList<ItemStack> filterItems, EntityItemPickupEvent event, ContainerBackpack container) {
        boolean shouldSave = false;
        for (ItemStack filterItem : filterItems) {
            if (filterItem == null || !GameRegistry.findUniqueIdentifierFor((Item)event.item.func_92059_d().func_77973_b()).modId.equals(GameRegistry.findUniqueIdentifierFor((Item)filterItem.func_77973_b()).modId)) continue;
            container.transferStackInSlot(event.item.func_92059_d());
            shouldSave = true;
        }
        if (shouldSave) {
            container.func_75134_a(event.entityPlayer);
        }
    }

    private void transferWithMiningFilter(ArrayList<ItemStack> filterItems, ArrayList<String> itemEntityOre, EntityItemPickupEvent event, ContainerBackpack container) {
        boolean shouldSave = false;
        this.transferWithBasicFilter(filterItems, event, container);
        if (itemEntityOre != null) {
            for (String oreName : itemEntityOre) {
                if (oreName == null || !oreName.contains("ore") && !oreName.contains("gem") && !oreName.contains("dust")) continue;
                container.transferStackInSlot(event.item.func_92059_d());
                shouldSave = true;
            }
        }
        if (shouldSave) {
            container.func_75134_a(event.entityPlayer);
        }
    }

    private void deleteWithVoidFilter(ArrayList<ItemStack> filterItems, EntityItemPickupEvent event) {
        for (ItemStack stack : filterItems) {
            if (stack == null || !IronBackpacksHelper.areItemsEqualForStacking(stack, event.item.func_92059_d())) continue;
            event.item.func_70106_y();
            event.item.func_70071_h_();
            event.setCanceled(true);
        }
    }

    private ArrayList<String> getOreDict(ItemStack itemStack) {
        int[] ids = OreDictionary.getOreIDs((ItemStack)itemStack);
        ArrayList<String> retList = new ArrayList<String>();
        if (ids.length > 0) {
            for (int i = 0; i < ids.length; ++i) {
                if (i > 0 && !retList.contains(OreDictionary.getOreName((int)ids[i]))) {
                    retList.add(OreDictionary.getOreName((int)ids[i]));
                    continue;
                }
                retList.add(OreDictionary.getOreName((int)ids[i]));
            }
        }
        return retList.isEmpty() ? null : retList;
    }
}

