/*
 * Decompiled with CFR 0.152.
 */
package main.ironbackpacks.entity;

import com.google.common.collect.MapMaker;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class EntityBackpack
extends Entity
implements IEntityAdditionalSpawnData {
    private EntityPlayer player;
    private int backpackType;
    public static Map<EntityPlayer, EntityBackpack> backpacksSpawnedMap = new MapMaker().weakKeys().weakValues().makeMap();

    public EntityBackpack(World world) {
        super(world);
    }

    public EntityBackpack(World world, EntityPlayer player, int backpackType) {
        super(world);
        this.player = player;
        this.backpackType = backpackType;
    }

    protected void func_70088_a() {
    }

    public void func_70106_y() {
        super.func_70106_y();
        backpacksSpawnedMap.remove(this.player);
    }

    public int getTextureId() {
        return this.backpackType;
    }

    private static boolean isBackpackValid(EntityPlayer player, EntityBackpack backpack) {
        if (player == null || player.field_70128_L || backpack == null || backpack.field_70128_L) {
            return false;
        }
        return player.field_70170_p.field_73011_w.field_76574_g == backpack.field_70170_p.field_73011_w.field_76574_g;
    }

    @SideOnly(value=Side.CLIENT)
    public static void updateBackpacks(World worldObj) {
        for (Map.Entry<EntityPlayer, EntityBackpack> map : backpacksSpawnedMap.entrySet()) {
            EntityBackpack backpack;
            EntityPlayer player = map.getKey();
            if (EntityBackpack.isBackpackValid(player, backpack = map.getValue())) {
                backpack.fixPositions(player, player instanceof EntityPlayerSP);
                continue;
            }
            backpack.func_70106_y();
        }
    }

    private void fixPositions(EntityPlayer thePlayer, boolean localPlayer) {
        this.field_70142_S = this.field_70169_q = this.player.field_70169_q;
        this.field_70137_T = this.field_70167_r = this.player.field_70167_r;
        this.field_70136_U = this.field_70166_s = this.player.field_70166_s;
        this.field_70165_t = this.player.field_70165_t;
        this.field_70163_u = this.player.field_70163_u;
        this.field_70161_v = this.player.field_70161_v;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70126_B = this.player.field_70760_ar;
        this.field_70177_z = this.player.field_70761_aq;
        this.field_70127_C = this.player.field_70127_C;
        this.field_70125_A = this.player.field_70125_A;
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public void readSpawnData(ByteBuf data) {
        int playerId = data.readInt();
        Entity e = this.field_70170_p.func_73045_a(playerId);
        if (e instanceof EntityPlayer) {
            this.player = (EntityPlayer)e;
            backpacksSpawnedMap.put(this.player, this);
        } else {
            this.func_70106_y();
        }
        this.backpackType = data.readInt();
    }

    public void writeSpawnData(ByteBuf data) {
        if (this.player == null) {
            data.writeInt(-42);
        } else {
            data.writeInt(this.player.func_145782_y());
        }
        data.writeInt(this.backpackType);
    }

    protected void func_70037_a(NBTTagCompound p_70037_1_) {
    }

    protected void func_70014_b(NBTTagCompound p_70014_1_) {
    }
}

