/*
 * Decompiled with CFR 0.152.
 */
package main.ironbackpacks.crafting;

import main.ironbackpacks.items.backpacks.IBackpack;
import main.ironbackpacks.util.IronBackpacksConstants;
import main.ironbackpacks.util.IronBackpacksHelper;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class BackpackRemoveUpgradeRecipe
extends ShapelessOreRecipe {
    private final ItemStack recipeOutput;

    public BackpackRemoveUpgradeRecipe(ItemStack recipeOutput, Object ... items) {
        super(recipeOutput, items);
        this.recipeOutput = recipeOutput;
    }

    public ItemStack func_77572_b(InventoryCrafting inventoryCrafting) {
        int slotOfBackpack = this.getFirstBackpackSlotNumber(inventoryCrafting);
        if (slotOfBackpack == -1) {
            return null;
        }
        ItemStack backpack = inventoryCrafting.func_70301_a(slotOfBackpack);
        ItemStack result = backpack.func_77946_l();
        int[] upgrades = IronBackpacksHelper.getUpgradesAppliedFromNBT(result);
        if (upgrades.length == 0) {
            return null;
        }
        NBTTagCompound nbtTagCompound = result.func_77978_p();
        if (nbtTagCompound == null) {
            nbtTagCompound = new NBTTagCompound();
            nbtTagCompound.func_74782_a("Items", (NBTBase)new NBTTagList());
            result.func_77982_d(nbtTagCompound);
        }
        boolean nullChecksPassed = false;
        int upgradeInQuestion = -1;
        if (slotOfBackpack <= upgrades.length - 1 && slotOfBackpack >= 0 && upgrades[slotOfBackpack] > 0) {
            nullChecksPassed = true;
            upgradeInQuestion = upgrades[slotOfBackpack];
        }
        boolean upgradeRemoved = false;
        NBTTagList tagList = new NBTTagList();
        for (int upgrade : upgrades) {
            if (nullChecksPassed && upgrade == upgradeInQuestion) {
                upgradeRemoved = true;
                if (!IronBackpacksConstants.Upgrades.ALT_GUI_UPGRADE_IDS.contains(upgradeInQuestion)) continue;
                nbtTagCompound.func_74782_a("Removed", (NBTBase)new NBTTagInt(IronBackpacksConstants.Upgrades.ALT_GUI_UPGRADE_IDS.indexOf(upgradeInQuestion)));
                continue;
            }
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Upgrade", (byte)upgrade);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        nbtTagCompound.func_74782_a("Upgrades", (NBTBase)tagList);
        if (upgradeRemoved) {
            return result;
        }
        return null;
    }

    public ItemStack func_77571_b() {
        return this.recipeOutput;
    }

    private int getFirstBackpackSlotNumber(InventoryCrafting inventoryCrafting) {
        for (int i = 0; i < 9; ++i) {
            ItemStack itemstack = inventoryCrafting.func_70301_a(i);
            if (itemstack == null || !(itemstack.func_77973_b() instanceof IBackpack)) continue;
            return i;
        }
        return -1;
    }
}

