/*
 * Decompiled with CFR 0.152.
 */
package main.ironbackpacks.container.backpack;

import codechicken.enderstorage.storage.item.ItemEnderPouch;
import invtweaks.api.container.ChestContainer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import main.ironbackpacks.IronBackpacks;
import main.ironbackpacks.container.backpack.InventoryBackpack;
import main.ironbackpacks.container.slot.AdvancedNestingBackpackSlot;
import main.ironbackpacks.container.slot.BackpackSlot;
import main.ironbackpacks.container.slot.NestingBackpackSlot;
import main.ironbackpacks.integration.InterModSupport;
import main.ironbackpacks.items.backpacks.BackpackTypes;
import main.ironbackpacks.items.backpacks.IBackpack;
import main.ironbackpacks.items.upgrades.UpgradeMethods;
import main.ironbackpacks.util.IronBackpacksHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@ChestContainer
public class ContainerBackpack
extends Container {
    private EntityPlayer player;
    private InventoryBackpack inventory;
    private BackpackTypes type;
    private int xSize = 0;
    private int ySize = 0;

    public ContainerBackpack(EntityPlayer entityPlayer, InventoryBackpack backpackInventory, BackpackTypes type, int xSize, int ySize) {
        this.player = entityPlayer;
        this.inventory = backpackInventory;
        this.type = type;
        this.xSize = xSize;
        this.ySize = ySize;
        this.layoutContainer((IInventory)entityPlayer.field_71071_by, backpackInventory, xSize, ySize, type);
    }

    public ContainerBackpack(EntityPlayer entityPlayer, InventoryBackpack backpackInventory, BackpackTypes type) {
        this.player = entityPlayer;
        this.inventory = backpackInventory;
        this.type = type;
        this.layoutContainer((IInventory)entityPlayer.field_71071_by, backpackInventory, this.xSize, this.ySize, type);
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public InventoryBackpack getInventoryBackpack() {
        return this.inventory;
    }

    public BackpackTypes getType() {
        return this.type;
    }

    protected void layoutContainer(IInventory playerInventory, IInventory backpackInventory, int xSize, int ySize, BackpackTypes type) {
        ItemStack baseBackpack = IronBackpacksHelper.getBackpack(this.player);
        int[] upgrades = IronBackpacksHelper.getUpgradesAppliedFromNBT(baseBackpack);
        for (int backpackRow = 0; backpackRow < type.getRowCount(); ++backpackRow) {
            for (int backpackCol = 0; backpackCol < type.getRowLength(); ++backpackCol) {
                if (UpgradeMethods.hasNestingUpgrade(upgrades)) {
                    this.func_75146_a(new NestingBackpackSlot(backpackInventory, backpackCol + backpackRow * type.getRowLength(), 20 + backpackCol * 18, 18 + backpackRow * 18, this.type));
                    continue;
                }
                if (UpgradeMethods.hasNestingAdvancedUpgrade(upgrades)) {
                    this.func_75146_a(new AdvancedNestingBackpackSlot(backpackInventory, backpackCol + backpackRow * type.getRowLength(), 20 + backpackCol * 18, 18 + backpackRow * 18, this.type));
                    continue;
                }
                this.func_75146_a(new BackpackSlot(backpackInventory, backpackCol + backpackRow * type.getRowLength(), 20 + backpackCol * 18, 18 + backpackRow * 18));
            }
        }
        int leftCol = (xSize - 162) / 2 + 1;
        for (int playerInvRow = 0; playerInvRow < 3; ++playerInvRow) {
            for (int playerInvCol = 0; playerInvCol < 9; ++playerInvCol) {
                this.func_75146_a(new Slot(playerInventory, playerInvCol + playerInvRow * 9 + 9, leftCol + playerInvCol * 18, ySize - (4 - playerInvRow) * 18 - 10));
            }
        }
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            this.func_75146_a(new Slot(playerInventory, hotbarSlot, leftCol + hotbarSlot * 18, ySize - 24));
        }
    }

    public ItemStack func_82846_b(EntityPlayer p, int i) {
        ItemStack itemstack = null;
        Slot slot = (Slot)this.field_75151_b.get(i);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (i < this.type.getSize()) {
                if (!this.func_75135_a(itemstack1, this.type.getSize(), this.field_75151_b.size(), true)) {
                    return null;
                }
            } else {
                if (!((BackpackSlot)((Object)this.field_75151_b.get(1))).acceptsStack(itemstack1)) {
                    return null;
                }
                if (!this.func_75135_a(itemstack1, 0, this.type.getSize(), false)) {
                    return null;
                }
            }
            if (itemstack1.field_77994_a == 0) {
                slot.func_75215_d(null);
            } else {
                slot.func_75218_e();
            }
        }
        return itemstack;
    }

    public ItemStack transferStackInSlot(ItemStack itemToPutInBackpack) {
        if (!this.func_75135_a(itemToPutInBackpack, 0, this.type.getSize(), false)) {
            return null;
        }
        if (!((BackpackSlot)((Object)this.field_75151_b.get(1))).acceptsStack(itemToPutInBackpack)) {
            return null;
        }
        return itemToPutInBackpack;
    }

    public boolean func_75145_c(EntityPlayer player) {
        return true;
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (!player.field_70170_p.field_72995_K) {
            this.inventory.onGuiSaved(player);
        }
    }

    public ItemStack func_75144_a(int slot, int button, int flag, EntityPlayer player) {
        ItemStack currPack = IronBackpacks.proxy.getCurrBackpack(player);
        if (slot >= 0 && this.func_75139_a(slot) != null && this.func_75139_a(slot).func_75216_d() && ItemStack.func_77989_b((ItemStack)this.func_75139_a(slot).func_75211_c(), (ItemStack)currPack) && button == 0) {
            return null;
        }
        if (button == 1 && slot >= 0 && this.func_75139_a(slot) != null && this.func_75139_a(slot).func_75216_d()) {
            if (this.func_75139_a(slot).func_75211_c().func_77973_b() instanceof IBackpack) {
                ItemStack stack = this.func_75139_a(slot).func_75211_c();
                if (!ItemStack.func_77970_a((ItemStack)stack, (ItemStack)IronBackpacksHelper.getBackpack(player))) {
                    stack.func_77957_a(player.field_70170_p, player);
                }
                return null;
            }
            if (InterModSupport.isEnderStorageLoaded && this.func_75139_a(slot).func_75211_c().func_77973_b() instanceof ItemEnderPouch) {
                ItemStack stack = this.func_75139_a(slot).func_75211_c();
                stack.func_77957_a(player.field_70170_p, player);
                return null;
            }
        }
        return super.func_75144_a(slot, button, flag, player);
    }

    public void save(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            this.inventory.onGuiSaved(player);
        }
    }

    public void backpackToInventory() {
        for (int i = 0; i <= this.type.getSize() - 1; ++i) {
            this.func_82846_b(this.player, i);
        }
    }

    public void inventoryToBackpack() {
        int start = this.type.getSize();
        EntityPlayer entityPlayer = this.player;
        int end = start + this.player.field_71071_by.func_70302_i_() - entityPlayer.field_71071_by.func_70451_h() - 4;
        for (int i = start; i < end; ++i) {
            this.func_82846_b(this.player, i);
        }
    }

    public void hotbarToBackpack() {
        EntityPlayer entityPlayer = this.player;
        int start = this.type.getSize() + this.player.field_71071_by.func_70302_i_() - entityPlayer.field_71071_by.func_70451_h() - 4;
        EntityPlayer entityPlayer2 = this.player;
        int end = start + entityPlayer2.field_71071_by.func_70451_h();
        ItemStack equippedPack = IronBackpacksHelper.getBackpack(this.player);
        for (int slot = start; slot < end; ++slot) {
            if (slot < 0 || this.func_75139_a(slot) == null || !this.func_75139_a(slot).func_75216_d()) continue;
            if (!(this.func_75139_a(slot).func_75211_c().func_77973_b() instanceof IBackpack)) {
                this.func_82846_b(this.player, slot);
                continue;
            }
            ItemStack stack = this.func_75139_a(slot).func_75211_c();
            System.out.println(equippedPack.func_82833_r());
            if (ItemStack.func_77970_a((ItemStack)stack, (ItemStack)equippedPack)) continue;
            this.func_82846_b(this.player, slot);
        }
    }

    @ChestContainer.RowSizeCallback
    public int getNumColumns() {
        return this.type.getRowLength();
    }

    @ChestContainer.IsLargeCallback
    public boolean getVerticalButtons() {
        return false;
    }

    public void sort() {
        if (!this.field_75151_b.isEmpty() && !this.field_75153_a.isEmpty()) {
            this.mergeStacks();
            this.swapStacks();
            this.reorderStacks();
        }
    }

    private void mergeStacks() {
        for (int i = 0; i < this.type.getSize(); ++i) {
            ItemStack tempStack;
            Slot tempSlot = (Slot)this.field_75151_b.get(i);
            if (tempSlot == null || !tempSlot.func_75216_d() || (tempStack = tempSlot.func_75211_c()) == null || tempStack.field_77994_a >= tempStack.func_77976_d()) continue;
            this.fillSlot(tempSlot, i + 1);
        }
    }

    private void fillSlot(Slot slotToFill, int startIndex) {
        ItemStack stackToFill = slotToFill.func_75211_c();
        int fillAmt = stackToFill.func_77976_d() - stackToFill.field_77994_a;
        if (fillAmt > 0) {
            for (int i = startIndex; i < this.type.getSize(); ++i) {
                stackToFill = slotToFill.func_75211_c();
                fillAmt = stackToFill.func_77976_d() - stackToFill.field_77994_a;
                Slot tempSlot = (Slot)this.field_75151_b.get(i);
                if (tempSlot == null || !tempSlot.func_75216_d()) continue;
                ItemStack tempStack = tempSlot.func_75211_c();
                if (tempStack.field_77994_a <= 0 || !tempStack.func_77969_a(stackToFill) || !ItemStack.func_77970_a((ItemStack)tempStack, (ItemStack)stackToFill)) continue;
                if (tempStack.field_77994_a > fillAmt) {
                    tempSlot.func_75209_a(fillAmt);
                    slotToFill.func_75215_d(new ItemStack(stackToFill.func_77973_b(), stackToFill.func_77976_d(), stackToFill.func_77960_j()));
                    slotToFill.func_75218_e();
                    break;
                }
                tempSlot.func_75215_d(null);
                slotToFill.func_75215_d(new ItemStack(stackToFill.func_77973_b(), stackToFill.field_77994_a + tempStack.field_77994_a, stackToFill.func_77960_j()));
                slotToFill.func_75218_e();
            }
        }
    }

    private void swapStacks() {
        Slot tempSlot;
        int i;
        ArrayList<Integer> indicesOfSlotsWithItems = new ArrayList<Integer>();
        for (i = 0; i < this.type.getSize(); ++i) {
            ItemStack tempStack;
            tempSlot = (Slot)this.field_75151_b.get(i);
            if (tempSlot == null || !tempSlot.func_75216_d() || (tempStack = tempSlot.func_75211_c()) == null || tempStack.field_77994_a <= 0) continue;
            indicesOfSlotsWithItems.add(i);
        }
        if (!indicesOfSlotsWithItems.isEmpty() && (Integer)indicesOfSlotsWithItems.get(indicesOfSlotsWithItems.size() - 1) != indicesOfSlotsWithItems.size() - 1) {
            for (i = 0; i < indicesOfSlotsWithItems.size(); ++i) {
                tempSlot = (Slot)this.field_75151_b.get(i);
                if (tempSlot == null || tempSlot.func_75216_d()) continue;
                this.swapNull(tempSlot, (Slot)this.field_75151_b.get((Integer)indicesOfSlotsWithItems.get(i)));
            }
        }
    }

    private void swapNull(Slot nullSlot, Slot stackSlot) {
        if (stackSlot != null && stackSlot.func_75216_d()) {
            nullSlot.func_75215_d(stackSlot.func_75211_c());
            stackSlot.func_75215_d(null);
            stackSlot.func_75218_e();
        }
    }

    private void reorderStacks() {
        Slot tempSlot;
        int i;
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>(this.countLengthOfStacks());
        for (i = 0; i < this.type.getSize() && (tempSlot = (Slot)this.field_75151_b.get(i)) != null && tempSlot.func_75216_d(); ++i) {
            itemStacks.add(tempSlot.func_75211_c());
        }
        if (!itemStacks.isEmpty()) {
            Collections.sort(itemStacks, new ItemStackIDComparator());
            for (i = 0; i < itemStacks.size(); ++i) {
                tempSlot = (Slot)this.field_75151_b.get(i);
                tempSlot.func_75215_d((ItemStack)itemStacks.get(i));
            }
        }
    }

    private int countLengthOfStacks() {
        int total = 0;
        for (int i = 0; i < this.type.getSize(); ++i) {
            Slot tempSlot = (Slot)this.field_75151_b.get(i);
            if (tempSlot != null && tempSlot.func_75216_d()) {
                ++total;
                continue;
            }
            return total;
        }
        return total;
    }

    private class ItemStackIDComparator
    implements Comparator<ItemStack> {
        private ItemStackIDComparator() {
        }

        @Override
        public int compare(ItemStack stack1, ItemStack stack2) {
            int item2ID;
            int item1ID = stack1.func_77973_b() instanceof IBackpack ? -100 : Item.func_150891_b((Item)stack1.func_77973_b());
            if (item1ID == (item2ID = stack2.func_77973_b() instanceof IBackpack ? -100 : Item.func_150891_b((Item)stack2.func_77973_b()))) {
                return 0;
            }
            return item1ID > item2ID ? 1 : -1;
        }
    }

    private class ItemStackNameComparator
    implements Comparator<ItemStack> {
        private ItemStackNameComparator() {
        }

        @Override
        public int compare(ItemStack stack1, ItemStack stack2) {
            return stack1.func_82833_r().compareToIgnoreCase(stack2.func_82833_r());
        }
    }
}

