/*
 * Decompiled with CFR 0.152.
 */
package main.ironbackpacks.container.alternateGui;

import invtweaks.api.container.ChestContainer;
import invtweaks.api.container.InventoryContainer;
import java.util.Arrays;
import main.ironbackpacks.client.gui.buttons.ButtonTypes;
import main.ironbackpacks.container.alternateGui.InventoryAlternateGui;
import main.ironbackpacks.container.slot.GhostSlot;
import main.ironbackpacks.handlers.ConfigHandler;
import main.ironbackpacks.items.upgrades.UpgradeMethods;
import main.ironbackpacks.util.IronBackpacksHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

@InventoryContainer
public class ContainerAlternateGui
extends Container {
    private EntityPlayer player;
    private InventoryAlternateGui inventory;
    private int xSize = 0;
    private int ySize = 0;
    private ItemStack stack;
    private int filterAdvSlotIdStart;
    private int[] upgrades;

    public ContainerAlternateGui(EntityPlayer entityPlayer, InventoryAlternateGui inventoryAlternateGui, int xSize, int ySize) {
        this.player = entityPlayer;
        this.inventory = inventoryAlternateGui;
        this.xSize = xSize;
        this.ySize = ySize;
        this.stack = IronBackpacksHelper.getBackpack(this.player);
        this.upgrades = IronBackpacksHelper.getUpgradesAppliedFromNBT(this.stack);
        this.layoutContainer((IInventory)entityPlayer.field_71071_by, inventoryAlternateGui, xSize, ySize);
        if (UpgradeMethods.hasFilterAdvancedUpgrade(this.upgrades)) {
            this.initFilterSlots();
        }
    }

    public ContainerAlternateGui(EntityPlayer entityPlayer, InventoryAlternateGui inventoryAlternateGui) {
        this.player = entityPlayer;
        this.inventory = inventoryAlternateGui;
        this.stack = IronBackpacksHelper.getBackpack(this.player);
        this.upgrades = IronBackpacksHelper.getUpgradesAppliedFromNBT(this.stack);
        this.layoutContainer((IInventory)entityPlayer.field_71071_by, inventoryAlternateGui, this.xSize, this.ySize);
        if (UpgradeMethods.hasFilterAdvancedUpgrade(this.upgrades)) {
            this.initFilterSlots();
        }
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public InventoryAlternateGui getInventoryAlternateGui() {
        return this.inventory;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public int getFilterAdvSlotIdStart() {
        return this.filterAdvSlotIdStart;
    }

    private void layoutContainer(IInventory playerInventory, IInventory customInv, int xSize, int ySize) {
        int advFilterRow;
        int n = advFilterRow = UpgradeMethods.hasFilterAdvancedUpgrade(this.upgrades) ? 0 : -1;
        if (UpgradeMethods.hasFilterBasicUpgrade(this.upgrades)) {
            ++advFilterRow;
        }
        if (UpgradeMethods.hasFilterFuzzyUpgrade(this.upgrades)) {
            ++advFilterRow;
        }
        if (UpgradeMethods.hasFilterOreDictUpgrade(this.upgrades)) {
            ++advFilterRow;
        }
        if (UpgradeMethods.hasFilterModSpecificUpgrade(this.upgrades)) {
            ++advFilterRow;
        }
        this.filterAdvSlotIdStart = advFilterRow * 9;
        int rowCount = (int)Math.floor(customInv.func_70302_i_() / 9);
        int colCount = 9;
        int yStart = UpgradeMethods.hasRenamingUpgrade(this.upgrades) ? 18 : 0;
        for (int row = 0; row < rowCount; ++row) {
            yStart += 36;
            for (int col = 0; col < colCount; ++col) {
                this.func_75146_a(new GhostSlot(customInv, col + row * colCount, 20 + col * 18, yStart));
            }
        }
        int leftCol = (xSize - 162) / 2 + 1;
        for (int playerInvRow = 0; playerInvRow < 3; ++playerInvRow) {
            for (int playerInvCol = 0; playerInvCol < 9; ++playerInvCol) {
                this.func_75146_a(new Slot(playerInventory, playerInvCol + playerInvRow * 9 + 9, leftCol + playerInvCol * 18, ySize - (4 - playerInvRow) * 18 - 10));
            }
        }
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            this.func_75146_a(new Slot(playerInventory, hotbarSlot, leftCol + hotbarSlot * 18, ySize - 24));
        }
    }

    public ItemStack func_82846_b(EntityPlayer p, int i) {
        return null;
    }

    public boolean func_75145_c(EntityPlayer player) {
        return true;
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (UpgradeMethods.hasFilterAdvancedUpgrade(this.upgrades)) {
            this.saveSlots();
        }
        if (!player.field_70170_p.field_72995_K) {
            this.inventory.onGuiSaved(player);
        }
    }

    public ItemStack func_75144_a(int slot, int button, int flag, EntityPlayer player) {
        if (slot >= 0 && this.func_75139_a(slot) != null && this.func_75139_a(slot).func_75216_d() && player.func_70694_bm() != null && this.func_75139_a(slot).func_75211_c().func_77969_a(player.func_70694_bm())) {
            return null;
        }
        if (slot >= 0 && slot < this.inventory.func_70302_i_()) {
            if (player.field_71071_by.func_70445_o() != null) {
                ItemStack usedStack = player.field_71071_by.func_70445_o();
                this.inventory.func_70299_a(slot, new ItemStack(usedStack.func_77973_b(), 1, usedStack.func_77960_j()));
                return null;
            }
            this.inventory.func_70299_a(slot, null);
            return null;
        }
        try {
            return super.func_75144_a(slot, button, flag, player);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void renameBackpack(String toName) {
        this.stack.func_151001_c(ConfigHandler.makeRenamedBackpacksNamesItalic ? toName : "\u00a7r" + toName);
        ItemStack itemStack = IronBackpacksHelper.getBackpackFromPlayersInventory(this.player);
        if (itemStack == null) {
            itemStack = IronBackpacksHelper.getEquippedBackpack(this.player);
        }
        if (itemStack != null) {
            itemStack.func_151001_c(ConfigHandler.makeRenamedBackpacksNamesItalic ? toName : "\u00a7r" + toName);
        }
    }

    public void removeSlotsInRow(int row) {
        if (row == this.filterAdvSlotIdStart / 9 + 1) {
            Arrays.fill(this.inventory.advFilterStacks, null);
            Arrays.fill(this.inventory.advFilterButtonStates, (byte)ButtonTypes.EXACT.getID());
            this.inventory.advFilterButtonStartPoint = 0;
            this.initFilterSlots();
        } else {
            for (int i = (row - 1) * 9; i < row * 9; ++i) {
                this.inventory.func_70299_a(i, null);
            }
        }
    }

    @ChestContainer.RowSizeCallback
    public int getNumColumns() {
        return (int)Math.floor(this.inventory.func_70302_i_() / 9);
    }

    public void initFilterSlots() {
        for (int i = 0; i < 9; ++i) {
            this.func_75139_a(this.filterAdvSlotIdStart + i).func_75215_d(this.inventory.advFilterStacks[this.getWraparoundIndex(i)]);
        }
    }

    public void changeAdvFilterSlots(String side) {
        this.saveSlots();
        int startPoint = this.inventory.advFilterButtonStartPoint--;
        if (side.equals("left")) {
            if (startPoint == 0) {
                this.inventory.advFilterButtonStartPoint = 17;
            }
        } else if (side.equals("right")) {
            this.inventory.advFilterButtonStartPoint = startPoint == 17 ? 0 : ++this.inventory.advFilterButtonStartPoint;
        }
        this.initFilterSlots();
    }

    private void saveSlots() {
        for (int i = 0; i < 9; ++i) {
            this.inventory.advFilterStacks[this.getWraparoundIndex((int)i)] = this.func_75139_a(this.filterAdvSlotIdStart + i).func_75211_c();
        }
    }

    public int getWraparoundIndex(int orderNumber) {
        int startPoint = this.inventory.advFilterButtonStartPoint;
        if (startPoint + orderNumber > 17) {
            return orderNumber + startPoint - 18;
        }
        return startPoint + orderNumber;
    }

    public void setAdvFilterButtonType(int index, int typeToSetTo) {
        this.inventory.advFilterButtonStates[index] = (byte)typeToSetTo;
    }
}

