/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util;

import cofh.core.CoFHProps;
import cofh.core.util.ConfigHandler;
import cofh.thermalexpansion.block.dynamo.TileDynamoCompression;
import cofh.thermalexpansion.block.dynamo.TileDynamoMagmatic;
import cofh.thermalexpansion.block.dynamo.TileDynamoReactant;
import java.io.File;
import java.util.Locale;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.FluidRegistry;

public class FuelManager {
    public static ConfigHandler configFuels = new ConfigHandler("1.7.10R4.1.5");

    private FuelManager() {
    }

    public static boolean addMagmaticFuel(String string, int n) {
        if (!FluidRegistry.isFluidRegistered((String)string)) {
            return false;
        }
        return TileDynamoMagmatic.addFuel(FluidRegistry.getFluid((String)string), n);
    }

    public static boolean removeMagmaticFuel(String string) {
        if (!FluidRegistry.isFluidRegistered((String)string)) {
            return false;
        }
        return TileDynamoMagmatic.removeFuel(FluidRegistry.getFluid((String)string));
    }

    public static boolean addCompressionFuel(String string, int n) {
        if (!FluidRegistry.isFluidRegistered((String)string)) {
            return false;
        }
        return TileDynamoCompression.addFuel(FluidRegistry.getFluid((String)string), n);
    }

    public static boolean removeCompressionFuel(String string) {
        if (!FluidRegistry.isFluidRegistered((String)string)) {
            return false;
        }
        return TileDynamoCompression.removeFuel(FluidRegistry.getFluid((String)string));
    }

    public static boolean addCoolant(String string, int n) {
        if (!FluidRegistry.isFluidRegistered((String)string)) {
            return false;
        }
        return TileDynamoCompression.addCoolant(FluidRegistry.getFluid((String)string), n);
    }

    public static boolean removeCoolant(String string) {
        if (!FluidRegistry.isFluidRegistered((String)string)) {
            return false;
        }
        return TileDynamoCompression.removeCoolant(FluidRegistry.getFluid((String)string));
    }

    public static boolean addReactantFuel(String string, int n) {
        if (!FluidRegistry.isFluidRegistered((String)string)) {
            return false;
        }
        return TileDynamoReactant.addFuel(FluidRegistry.getFluid((String)string), n);
    }

    public static boolean removeReactantFuel(String string) {
        if (!FluidRegistry.isFluidRegistered((String)string)) {
            return false;
        }
        return TileDynamoReactant.removeFuel(FluidRegistry.getFluid((String)string));
    }

    public static boolean addReactant(ItemStack itemStack, int n) {
        return TileDynamoReactant.addReactant(itemStack, n);
    }

    public static boolean removeReactant(ItemStack itemStack) {
        return TileDynamoReactant.removeReactant(itemStack);
    }

    public static void parseFuels() {
        String string = "Fuels.Magmatic";
        configFuels.getCategory(string).setComment("You can add fuels to the Magmatic Dynamo in this section. Fluid names only, as they are registered in Minecraft.");
        FuelManager.addMagmaticFuel("lava", configFuels.get(string, "lava", 180000));
        FuelManager.addMagmaticFuel("pyrotheum", configFuels.get(string, "pyrotheum", 2000000));
        Set set = configFuels.getCategoryKeys(string);
        for (String string2 : set) {
            FuelManager.addMagmaticFuel(string2.toLowerCase(Locale.ENGLISH), configFuels.get(string, string2, 180000));
        }
        string = "Fuels.Compression";
        configFuels.getCategory(string).setComment("You can add fuels to the Compression Dynamo in this section. Fluid names only, as they are registered in Minecraft.");
        FuelManager.addCompressionFuel("coal", configFuels.get(string, "coal", 1000000));
        FuelManager.addCompressionFuel("biofuel", configFuels.get(string, "biofuel", 500000));
        FuelManager.addCompressionFuel("bioethanol", configFuels.get(string, "bioethanol", 500000));
        FuelManager.addCompressionFuel("fuel", configFuels.get(string, "fuel", 1500000));
        FuelManager.addCompressionFuel("oil", configFuels.get(string, "oil", 150000));
        set = configFuels.getCategoryKeys(string);
        for (String string2 : set) {
            FuelManager.addCompressionFuel(string2.toLowerCase(Locale.ENGLISH), configFuels.get(string, string2, 500000));
        }
        string = "Fuels.Reactant";
        configFuels.getCategory(string).setComment("You can add fuels to the Reactant Dynamo in this section. Fluid names only, as they are registered in Minecraft.");
        FuelManager.addReactantFuel("redstone", configFuels.get(string, "redstone", 600000));
        FuelManager.addReactantFuel("glowstone", configFuels.get(string, "glowstone", 750000));
        FuelManager.addReactantFuel("mobessence", configFuels.get(string, "mobessence", 500000));
        FuelManager.addReactantFuel("sewage", configFuels.get(string, "sewage", 12000));
        FuelManager.addReactantFuel("sludge", configFuels.get(string, "sludge", 12000));
        FuelManager.addReactantFuel("seedoil", configFuels.get(string, "seedoil", 250000));
        FuelManager.addReactantFuel("biomass", configFuels.get(string, "biomass", 450000));
        FuelManager.addReactantFuel("creosote", configFuels.get(string, "creosote", 200000));
        set = configFuels.getCategoryKeys(string);
        for (String string2 : set) {
            FuelManager.addReactantFuel(string2.toLowerCase(Locale.ENGLISH), configFuels.get(string, string2, 200000));
        }
        string = "Coolants";
        configFuels.getCategory(string).setComment("You can add Coolants in this section. Fluid names only, as they are registered in Minecraft. Currently only used by the Compression Dynamo.");
        FuelManager.addCoolant("water", configFuels.get(string, "water", 400000));
        FuelManager.addCoolant("cryotheum", configFuels.get(string, "cryotheum", 4000000));
        FuelManager.addCoolant("ice", configFuels.get(string, "ice", 2000000));
        set = configFuels.getCategoryKeys(string);
        for (String string2 : set) {
            FuelManager.addCoolant(string2.toLowerCase(Locale.ENGLISH), configFuels.get(string, string2, 400000));
        }
        configFuels.cleanUp(true, false);
    }

    static {
        configFuels.setConfiguration(new Configuration(new File(CoFHProps.configDir, "cofh/thermalexpansion/fuels.cfg"), true));
    }
}

