/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.gui.element;

import cofh.core.gui.element.TabConfiguration;
import cofh.lib.gui.GuiBase;
import cofh.lib.gui.element.ElementBase;
import cofh.lib.gui.element.TabBase;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermalexpansion.block.ender.TileTesseract;
import java.util.List;
import org.lwjgl.opengl.GL11;

public class TabConfigTesseract
extends TabBase {
    public static final String[] TOOLTIPS = new String[]{StringHelper.localize((String)"info.thermalexpansion.modeSend"), StringHelper.localize((String)"info.thermalexpansion.modeRecv"), StringHelper.localize((String)"info.thermalexpansion.modeSendRecv"), StringHelper.localize((String)"info.thermalexpansion.modeBlocked")};
    TileTesseract myTile;
    public static final String[] buttonNames = new String[]{"IconSendOnly", "IconRecvOnly", "IconSendRecv", "IconBlocked"};

    public TabConfigTesseract(GuiBase guiBase, TileTesseract tileTesseract) {
        this(guiBase, TabConfiguration.defaultSide, tileTesseract);
    }

    public TabConfigTesseract(GuiBase guiBase, int n, TileTesseract tileTesseract) {
        super(guiBase, n);
        this.headerColor = TabConfiguration.defaultHeaderColor;
        this.subheaderColor = TabConfiguration.defaultSubHeaderColor;
        this.textColor = TabConfiguration.defaultTextColor;
        this.backgroundColor = TabConfiguration.defaultBackgroundColor;
        this.maxHeight = 92;
        this.maxWidth = 100;
        this.myTile = tileTesseract;
    }

    private boolean modeReceiveAll() {
        return this.myTile.modeReceiveItems() && this.myTile.modeReceiveFluid() && this.myTile.modeReceiveEnergy();
    }

    private boolean modeSendAll() {
        return this.myTile.modeSendItems() && this.myTile.modeSendFluid() && this.myTile.modeSendEnergy();
    }

    public void addTooltip(List<String> list) {
        if (!this.isFullyOpened()) {
            list.add(StringHelper.localize((String)"info.cofh.configuration"));
        }
        int n = ((ElementBase)this).gui.getMouseX() - this.currentShiftX;
        int n2 = ((ElementBase)this).gui.getMouseY() - this.currentShiftY;
        if (24 <= n && n < 40 && 20 <= n2 && n2 < 36) {
            list.add(StringHelper.localize((String)"info.thermalexpansion.modeItem") + ": " + TOOLTIPS[this.myTile.modeItem]);
        } else if (42 <= n && n < 58 && 20 <= n2 && n2 < 36) {
            list.add(StringHelper.localize((String)"info.thermalexpansion.modeFluid") + ": " + TOOLTIPS[this.myTile.modeFluid]);
        } else if (60 <= n && n < 76 && 20 <= n2 && n2 < 36) {
            list.add(StringHelper.localize((String)"info.thermalexpansion.modeEnergy") + ": " + TOOLTIPS[this.myTile.modeEnergy]);
        }
    }

    public boolean onMousePressed(int n, int n2, int n3) {
        if (!this.isFullyOpened()) {
            return false;
        }
        if (this.side == 0) {
            n += this.currentWidth;
        }
        if ((n -= this.currentShiftX) < 18 || n > 82 || (n2 -= this.currentShiftY) < 16 || n2 > 40) {
            return false;
        }
        if (24 <= n && n < 40 && 20 <= n2 && n2 < 36) {
            if (n3 == 0) {
                this.myTile.incItemMode();
                GuiBase.playSound((String)"random.click", (float)1.0f, (float)0.8f);
            } else if (n3 == 1) {
                this.myTile.decItemMode();
                GuiBase.playSound((String)"random.click", (float)1.0f, (float)0.6f);
            }
            this.myTile.setTileInfo(this.myTile.frequency);
        } else if (42 <= n && n < 58 && 20 <= n2 && n2 < 36) {
            if (n3 == 0) {
                this.myTile.incFluidMode();
                GuiBase.playSound((String)"random.click", (float)1.0f, (float)0.8f);
            } else if (n3 == 1) {
                this.myTile.decFluidMode();
                GuiBase.playSound((String)"random.click", (float)1.0f, (float)0.6f);
            }
            this.myTile.setTileInfo(this.myTile.frequency);
        } else if (60 <= n && n < 76 && 20 <= n2 && n2 < 36) {
            if (n3 == 0) {
                this.myTile.incEnergyMode();
                GuiBase.playSound((String)"random.click", (float)1.0f, (float)0.8f);
            } else if (n3 == 1) {
                this.myTile.decEnergyMode();
                GuiBase.playSound((String)"random.click", (float)1.0f, (float)0.6f);
            }
            this.myTile.setTileInfo(this.myTile.frequency);
        }
        return true;
    }

    protected void drawBackground() {
        super.drawBackground();
        if (!this.isFullyOpened()) {
            return;
        }
        float f = (float)(this.backgroundColor >> 16 & 0xFF) / 255.0f * 0.6f;
        float f2 = (float)(this.backgroundColor >> 8 & 0xFF) / 255.0f * 0.6f;
        float f3 = (float)(this.backgroundColor & 0xFF) / 255.0f * 0.6f;
        GL11.glColor4f((float)f, (float)f2, (float)f3, (float)1.0f);
        ((ElementBase)this).gui.func_73729_b(this.posX() + 18, ((ElementBase)this).posY + 16, 16, 20, 64, 24);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void drawForeground() {
        this.drawTabIcon("IconConfigTesseract");
        if (!this.isFullyOpened()) {
            return;
        }
        this.getFontRenderer().func_78261_a(StringHelper.localize((String)"info.cofh.configuration"), this.posXOffset() + 18, ((ElementBase)this).posY + 6, this.headerColor);
        this.getFontRenderer().func_78261_a(StringHelper.localize((String)"info.cofh.sending") + ":", this.posXOffset() + 6, ((ElementBase)this).posY + 42, this.subheaderColor);
        this.getFontRenderer().func_78261_a(StringHelper.localize((String)"info.cofh.receiving") + ":", this.posXOffset() + 6, ((ElementBase)this).posY + 66, this.subheaderColor);
        ((ElementBase)this).gui.drawButton(buttonNames[this.myTile.modeItem], this.posX() + 24, ((ElementBase)this).posY + 20, 1, 0);
        ((ElementBase)this).gui.drawButton(buttonNames[this.myTile.modeFluid], this.posX() + 42, ((ElementBase)this).posY + 20, 1, 0);
        ((ElementBase)this).gui.drawButton(buttonNames[this.myTile.modeEnergy], this.posX() + 60, ((ElementBase)this).posY + 20, 1, 0);
        String string = "";
        String string2 = "";
        if (this.modeReceiveAll()) {
            string2 = StringHelper.localize((String)"info.cofh.all");
        } else {
            if (this.myTile.modeReceiveItems()) {
                string2 = string2 + StringHelper.localize((String)"info.cofh.items");
            }
            if (this.myTile.modeReceiveFluid()) {
                if (this.myTile.modeReceiveItems()) {
                    string2 = string2 + ", ";
                }
                string2 = string2 + StringHelper.localize((String)"info.cofh.fluid");
            }
            if (this.myTile.modeReceiveEnergy()) {
                if (this.myTile.modeReceiveItems() || this.myTile.modeReceiveFluid()) {
                    string2 = string2 + ", ";
                }
                string2 = string2 + StringHelper.localize((String)"info.cofh.energy");
            }
            if (string2.isEmpty()) {
                string2 = StringHelper.localize((String)"info.cofh.none");
            }
        }
        if (this.modeSendAll()) {
            string = StringHelper.localize((String)"info.cofh.all");
        } else {
            if (this.myTile.modeSendItems()) {
                string = string + StringHelper.localize((String)"info.cofh.items");
            }
            if (this.myTile.modeSendFluid()) {
                if (this.myTile.modeSendItems()) {
                    string = string + ", ";
                }
                string = string + StringHelper.localize((String)"info.cofh.fluid");
            }
            if (this.myTile.modeSendEnergy()) {
                if (this.myTile.modeSendItems() || this.myTile.modeSendFluid()) {
                    string = string + ", ";
                }
                string = string + StringHelper.localize((String)"info.cofh.energy");
            }
            if (string.isEmpty()) {
                string = StringHelper.localize((String)"info.cofh.none");
            }
        }
        this.getFontRenderer().func_78276_b(string, this.posXOffset() + 14, ((ElementBase)this).posY + 54, this.textColor);
        this.getFontRenderer().func_78276_b(string2, this.posXOffset() + 14, ((ElementBase)this).posY + 78, this.textColor);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

