/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import powercrystals.minefactoryreloaded.core.MFRUtil;
import powercrystals.minefactoryreloaded.item.base.ItemFactory;
import powercrystals.minefactoryreloaded.net.Packets;

public class ItemPortaSpawner
extends ItemFactory {
    private static Block _block = Blocks.field_150474_ac;
    public static final String spawnerTag = "spawner";
    private static final String placeTag = "placeDelay";

    public static NBTTagCompound getSpawnerTag(ItemStack itemStack) {
        NBTTagCompound nBTTagCompound = itemStack.func_77978_p();
        if (nBTTagCompound != null && nBTTagCompound.func_74764_b(spawnerTag)) {
            return nBTTagCompound.func_74775_l(spawnerTag);
        }
        return null;
    }

    private static String getEntityId(ItemStack itemStack) {
        NBTTagCompound nBTTagCompound = ItemPortaSpawner.getSpawnerTag(itemStack);
        if (nBTTagCompound != null) {
            return nBTTagCompound.func_74779_i("EntityId");
        }
        return null;
    }

    public static boolean hasData(ItemStack itemStack) {
        return ItemPortaSpawner.getEntityId(itemStack) != null;
    }

    private static int getDelay(ItemStack itemStack) {
        NBTTagCompound nBTTagCompound = itemStack.func_77978_p();
        if (nBTTagCompound != null) {
            return nBTTagCompound.func_74762_e(placeTag);
        }
        return 0;
    }

    @Override
    public void addInfo(ItemStack itemStack, EntityPlayer entityPlayer, List<String> list, boolean bl) {
        int n;
        super.addInfo(itemStack, entityPlayer, list, bl);
        String string = ItemPortaSpawner.getEntityId(itemStack);
        if (string != null) {
            list.add(MFRUtil.localize("tile.mobSpawner") + ": " + MFRUtil.localize("entity.", string));
        }
        if ((n = ItemPortaSpawner.getDelay(itemStack)) > 0) {
            String string2 = MFRUtil.localize("tip.info.mfr.cannotplace", true, "%s");
            list.add(String.format(string2, Math.ceil((float)n / 20.0f)));
        }
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int n, boolean bl) {
        NBTTagCompound nBTTagCompound = itemStack.func_77978_p();
        if (nBTTagCompound != null && nBTTagCompound.func_74764_b(placeTag) && nBTTagCompound.func_74762_e(placeTag) > 0) {
            nBTTagCompound.func_74768_a(placeTag, nBTTagCompound.func_74762_e(placeTag) - 1);
        }
    }

    public boolean func_77648_a(ItemStack itemStack, EntityPlayer entityPlayer, World world, int n, int n2, int n3, int n4, float f, float f2, float f3) {
        if (world.field_72995_K) {
            return true;
        }
        if (ItemPortaSpawner.getEntityId(itemStack) == null) {
            if (world.func_147439_a(n, n2, n3).equals(_block)) {
                TileEntity tileEntity = world.func_147438_o(n, n2, n3);
                NBTTagCompound nBTTagCompound = new NBTTagCompound();
                nBTTagCompound.func_74782_a(spawnerTag, (NBTBase)new NBTTagCompound());
                tileEntity.func_145841_b(nBTTagCompound.func_74775_l(spawnerTag));
                nBTTagCompound.func_74768_a(placeTag, 800);
                itemStack.func_77982_d(nBTTagCompound);
                world.func_147468_f(n, n2, n3);
                return true;
            }
            return false;
        }
        return ItemPortaSpawner.getDelay(itemStack) <= 0 && this.placeBlock(itemStack, entityPlayer, world, n, n2, n3, n4, f, f2, f3);
    }

    private boolean placeBlock(ItemStack itemStack, EntityPlayer entityPlayer, World world, int n, int n2, int n3, int n4, float f, float f2, float f3) {
        Block block = world.func_147439_a(n, n2, n3);
        if (block == Blocks.field_150431_aC) {
            n4 = 1;
        } else if (!block.isReplaceable((IBlockAccess)world, n, n2, n3)) {
            switch (n4) {
                case 0: {
                    --n2;
                    break;
                }
                case 1: {
                    ++n2;
                    break;
                }
                case 2: {
                    --n3;
                    break;
                }
                case 3: {
                    ++n3;
                    break;
                }
                case 4: {
                    --n;
                    break;
                }
                case 5: {
                    ++n;
                }
            }
        }
        if (itemStack.field_77994_a == 0) {
            return false;
        }
        if (!entityPlayer.func_82247_a(n, n2, n3, n4, itemStack)) {
            return false;
        }
        if (n2 == 255 && block.func_149688_o().func_76220_a()) {
            return false;
        }
        if (world.func_147472_a(_block, n, n2, n3, false, n4, (Entity)entityPlayer, itemStack)) {
            int n5 = block.func_149660_a(world, n, n2, n3, n4, f, f2, f3, 0);
            if (this.placeBlockAt(itemStack, entityPlayer, world, n, n2, n3, n4, f, f2, f3, n5)) {
                world.func_72908_a((double)((float)n + 0.5f), (double)((float)n2 + 0.5f), (double)((float)n3 + 0.5f), block.field_149762_H.func_150496_b(), (block.field_149762_H.func_150497_c() + 1.0f) / 2.0f, block.field_149762_H.func_150494_d() * 0.8f);
                --itemStack.field_77994_a;
            }
            return true;
        }
        return false;
    }

    private boolean placeBlockAt(ItemStack itemStack, EntityPlayer entityPlayer, World world, int n, int n2, int n3, int n4, float f, float f2, float f3, int n5) {
        if (!world.func_147465_d(n, n2, n3, _block, n5, 3)) {
            return false;
        }
        Block block = world.func_147439_a(n, n2, n3);
        if (block.equals(_block)) {
            block.func_149689_a(world, n, n2, n3, (EntityLivingBase)entityPlayer, itemStack);
            block.func_149714_e(world, n, n2, n3, n5);
            TileEntity tileEntity = world.func_147438_o(n, n2, n3);
            NBTTagCompound nBTTagCompound = itemStack.func_77978_p();
            if (nBTTagCompound.func_74764_b(spawnerTag)) {
                nBTTagCompound = nBTTagCompound.func_74775_l(spawnerTag);
            }
            nBTTagCompound.func_74768_a("x", n);
            nBTTagCompound.func_74768_a("y", n2);
            nBTTagCompound.func_74768_a("z", n3);
            tileEntity.func_145839_a(nBTTagCompound);
            Packets.sendToAllPlayersWatching(world, n, n2, n3, tileEntity.func_145844_m());
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack itemStack) {
        return ItemPortaSpawner.hasData(itemStack);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack itemStack) {
        return ItemPortaSpawner.hasData(itemStack) ? EnumRarity.epic : EnumRarity.rare;
    }
}

