/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.material;

import crazypants.enderio.EnderIO;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.StringUtils;

public enum Alloy {
    ELECTRICAL_STEEL("electricalSteel", 6.0f),
    ENERGETIC_ALLOY("energeticAlloy", 7.0f),
    PHASED_GOLD("phasedGold", 4.0f, "vibrantAlloy"),
    REDSTONE_ALLOY("redstoneAlloy", 1.0f),
    CONDUCTIVE_IRON("conductiveIron", 5.2f),
    PHASED_IRON("phasedIron", 7.0f, "pulsatingIron"),
    DARK_STEEL("darkSteel", 10.0f),
    SOULARIUM("soularium", 10.0f);

    public final String unlocalisedName;
    public final String iconKey;
    private final List<String> oreIngots = new ArrayList<String>();
    private final List<String> oreBlocks = new ArrayList<String>();
    private final float hardness;

    private Alloy(String baseName, float hardness, String oreDictName) {
        this.unlocalisedName = "enderio." + baseName;
        this.iconKey = "enderio:" + baseName;
        if (oreDictName != null) {
            this.oreIngots.add("ingot" + StringUtils.capitalize((String)oreDictName));
            this.oreBlocks.add("block" + StringUtils.capitalize((String)oreDictName));
        }
        this.oreIngots.add("ingot" + StringUtils.capitalize((String)baseName));
        this.oreBlocks.add("block" + StringUtils.capitalize((String)baseName));
        this.hardness = hardness;
    }

    private Alloy(String baseName, float hardness) {
        this(baseName, hardness, null);
    }

    public float getHardness() {
        return this.hardness;
    }

    public ItemStack getStackIngot() {
        return this.getStackIngot(1);
    }

    public ItemStack getStackIngot(int size) {
        return new ItemStack((Item)EnderIO.itemAlloy, size, this.ordinal());
    }

    public ItemStack getStackBlock() {
        return this.getStackBlock(1);
    }

    public ItemStack getStackBlock(int size) {
        return new ItemStack((Block)EnderIO.blockIngotStorage, size, this.ordinal());
    }

    public String getOreIngot() {
        return this.oreIngots.get(0);
    }

    public String getOreBlock() {
        return this.oreBlocks.get(0);
    }

    public List<String> getOreIngots() {
        return this.oreIngots;
    }

    public List<String> getOreBlocks() {
        return this.oreBlocks;
    }
}

