/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.block;

import cofh.api.energy.IEnergyHandler;
import cofh.api.tileentity.ITileInfo;
import cofh.core.block.BlockCoFHBase;
import cofh.lib.util.helpers.ServerHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.repack.codechicken.lib.raytracer.IndexedCuboid6;
import cofh.repack.codechicken.lib.raytracer.RayTracer;
import cofh.repack.codechicken.lib.vec.BlockCoord;
import cofh.repack.codechicken.lib.vec.Vector3;
import cofh.thermaldynamics.block.TileTDBase;
import cofh.thermaldynamics.duct.entity.EntityTransport;
import cofh.thermaldynamics.util.Utils;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public abstract class BlockTDBase
extends BlockCoFHBase {
    protected BlockTDBase(Material material) {
        super(material);
    }

    public TileEntity func_149915_a(World world, int n) {
        return null;
    }

    public boolean isSideSolid(IBlockAccess iBlockAccess, int n, int n2, int n3, ForgeDirection forgeDirection) {
        TileTDBase tileTDBase = (TileTDBase)iBlockAccess.func_147438_o(n, n2, n3);
        return tileTDBase != null && (tileTDBase.covers[forgeDirection.ordinal()] != null || tileTDBase.attachments[forgeDirection.ordinal()] != null && tileTDBase.attachments[forgeDirection.ordinal()].makesSideSolid()) || super.isSideSolid(iBlockAccess, n, n2, n3, forgeDirection);
    }

    public float getSize(World world, int n, int n2, int n3) {
        return 0.3f;
    }

    public void func_149743_a(World world, int n, int n2, int n3, AxisAlignedBB axisAlignedBB, List list, Entity entity) {
        if (entity instanceof EntityTransport) {
            return;
        }
        float f = this.getSize(world, n, n2, n3);
        float f2 = 1.0f - f;
        this.func_149676_a(f, f, f, f2, f2, f2);
        super.func_149743_a(world, n, n2, n3, axisAlignedBB, list, entity);
        TileTDBase tileTDBase = (TileTDBase)world.func_147438_o(n, n2, n3);
        if (tileTDBase != null) {
            for (int n4 = 0; n4 < 6; n4 = (int)((byte)(n4 + 1))) {
                if (tileTDBase.attachments[n4] != null) {
                    tileTDBase.attachments[n4].addCollisionBoxesToList(axisAlignedBB, list, entity);
                }
                if (tileTDBase.covers[n4] == null) continue;
                tileTDBase.covers[n4].addCollisionBoxesToList(axisAlignedBB, list, entity);
            }
            if (tileTDBase.neighborTypes[0] != TileTDBase.NeighborTypes.NONE) {
                this.func_149676_a(f, 0.0f, f, f2, f2, f2);
                super.func_149743_a(world, n, n2, n3, axisAlignedBB, list, entity);
            }
            if (tileTDBase.neighborTypes[1] != TileTDBase.NeighborTypes.NONE) {
                this.func_149676_a(f, f, f, f2, 1.0f, f2);
                super.func_149743_a(world, n, n2, n3, axisAlignedBB, list, entity);
            }
            if (tileTDBase.neighborTypes[2] != TileTDBase.NeighborTypes.NONE) {
                this.func_149676_a(f, f, 0.0f, f2, f2, f2);
                super.func_149743_a(world, n, n2, n3, axisAlignedBB, list, entity);
            }
            if (tileTDBase.neighborTypes[3] != TileTDBase.NeighborTypes.NONE) {
                this.func_149676_a(f, f, f, f2, f2, 1.0f);
                super.func_149743_a(world, n, n2, n3, axisAlignedBB, list, entity);
            }
            if (tileTDBase.neighborTypes[4] != TileTDBase.NeighborTypes.NONE) {
                this.func_149676_a(0.0f, f, f, f2, f2, f2);
                super.func_149743_a(world, n, n2, n3, axisAlignedBB, list, entity);
            }
            if (tileTDBase.neighborTypes[5] != TileTDBase.NeighborTypes.NONE) {
                this.func_149676_a(f, f, f, 1.0f, f2, f2);
                super.func_149743_a(world, n, n2, n3, axisAlignedBB, list, entity);
            }
        }
        this.func_149676_a(f, f, f, f2, f2, f2);
    }

    public MovingObjectPosition func_149731_a(World world, int n, int n2, int n3, Vec3 vec3, Vec3 vec32) {
        TileTDBase tileTDBase = (TileTDBase)world.func_147438_o(n, n2, n3);
        if (tileTDBase == null) {
            return null;
        }
        LinkedList<IndexedCuboid6> linkedList = new LinkedList<IndexedCuboid6>();
        tileTDBase.addTraceableCuboids(linkedList);
        return RayTracer.instance().rayTraceCuboids(new Vector3(vec3), new Vector3(vec32), linkedList, new BlockCoord(n, n2, n3), (Block)this);
    }

    public boolean func_149727_a(World world, int n, int n2, int n3, EntityPlayer entityPlayer, int n4, float f, float f2, float f3) {
        PlayerInteractEvent playerInteractEvent = new PlayerInteractEvent(entityPlayer, PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK, n, n2, n3, n4, world);
        if (MinecraftForge.EVENT_BUS.post((Event)playerInteractEvent) || playerInteractEvent.getResult() == Event.Result.DENY || playerInteractEvent.useBlock == Event.Result.DENY) {
            return false;
        }
        if (entityPlayer.func_70093_af()) {
            if (Utils.isHoldingUsableWrench(entityPlayer, n, n2, n3)) {
                if (ServerHelper.isServerWorld((World)world) && this.canDismantle(entityPlayer, world, n, n2, n3)) {
                    this.dismantleBlock(entityPlayer, world, n, n2, n3, false);
                }
                Utils.usedWrench(entityPlayer, n, n2, n3);
                return true;
            }
            return false;
        }
        TileTDBase tileTDBase = (TileTDBase)world.func_147438_o(n, n2, n3);
        if (tileTDBase == null) {
            return false;
        }
        if (Utils.isHoldingUsableWrench(entityPlayer, n, n2, n3)) {
            if (ServerHelper.isServerWorld((World)world)) {
                tileTDBase.onWrench(entityPlayer, n4);
            }
            Utils.usedWrench(entityPlayer, n, n2, n3);
            return true;
        }
        return tileTDBase.openGui(entityPlayer);
    }

    public void debugBlock(IBlockAccess iBlockAccess, int n, int n2, int n3, ForgeDirection forgeDirection, EntityPlayer entityPlayer) {
        ((TileTDBase)iBlockAccess.func_147438_o(n, n2, n3)).doDebug(entityPlayer);
    }

    public void getBlockInfo(IBlockAccess iBlockAccess, int n, int n2, int n3, ForgeDirection forgeDirection, EntityPlayer entityPlayer, List<IChatComponent> list, boolean bl) {
        TileEntity tileEntity = iBlockAccess.func_147438_o(n, n2, n3);
        if (tileEntity instanceof ITileInfo) {
            ((ITileInfo)tileEntity).getTileInfo(list, forgeDirection, entityPlayer, bl);
        } else if (tileEntity instanceof IEnergyHandler) {
            IEnergyHandler iEnergyHandler = (IEnergyHandler)tileEntity;
            if (iEnergyHandler.getMaxEnergyStored(forgeDirection) <= 0) {
                return;
            }
            list.add((IChatComponent)new ChatComponentText(StringHelper.localize((String)"info.cofh.energy") + ": " + iEnergyHandler.getEnergyStored(forgeDirection) + "/" + iEnergyHandler.getMaxEnergyStored(forgeDirection) + " RF."));
        }
    }
}

